/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.opengl.gui.event;

import com.threerings.opengl.gui.event.ComponentListener;
import com.threerings.opengl.gui.event.InputEvent;
import com.threerings.opengl.gui.event.MouseListener;
import com.threerings.opengl.gui.event.MouseMotionListener;
import com.threerings.opengl.gui.event.MouseWheelListener;

public class MouseEvent
extends InputEvent {
    public static final int MOUSE_PRESSED = 0;
    public static final int MOUSE_RELEASED = 1;
    public static final int MOUSE_CLICKED = 2;
    public static final int MOUSE_ENTERED = 3;
    public static final int MOUSE_EXITED = 4;
    public static final int MOUSE_MOVED = 5;
    public static final int MOUSE_DRAGGED = 6;
    public static final int MOUSE_WHEELED = 7;
    public static final int BUTTON1 = 0;
    public static final int BUTTON2 = 1;
    public static final int BUTTON3 = 2;
    public static final int BUTTON4 = 3;
    public static final int BUTTON5 = 4;
    protected int _type;
    protected int _button;
    protected int _mx;
    protected int _my;
    protected int _ccount;
    protected int _delta;

    public MouseEvent(Object source, long when, int modifiers, int type, int mx, int my) {
        this(source, when, modifiers, type, -1, mx, my);
    }

    public MouseEvent(Object source, long when, int modifiers, int type, int button, int mx, int my) {
        this(source, when, modifiers, type, button, mx, my, 0);
    }

    public MouseEvent(Object source, long when, int modifiers, int type, int button, int mx, int my, int ccount) {
        this(source, when, modifiers, type, button, mx, my, ccount, 0);
    }

    public MouseEvent(Object source, long when, int modifiers, int type, int button, int mx, int my, int ccount, int delta) {
        super(source, when, modifiers);
        this._type = type;
        this._button = button;
        this._mx = mx;
        this._my = my;
        this._ccount = ccount;
        this._delta = delta;
    }

    public int getType() {
        return this._type;
    }

    public int getButton() {
        return this._button;
    }

    public int getX() {
        return this._mx;
    }

    public int getY() {
        return this._my;
    }

    public int getClickCount() {
        return this._ccount;
    }

    public int getDelta() {
        return this._delta;
    }

    public void dispatch(ComponentListener listener) {
        super.dispatch(listener);
        switch (this._type) {
            case 0: {
                if (!(listener instanceof MouseListener)) break;
                ((MouseListener)listener).mousePressed(this);
                break;
            }
            case 1: {
                if (!(listener instanceof MouseListener)) break;
                ((MouseListener)listener).mouseReleased(this);
                break;
            }
            case 2: {
                if (!(listener instanceof MouseListener)) break;
                ((MouseListener)listener).mouseClicked(this);
                break;
            }
            case 3: {
                if (!(listener instanceof MouseListener)) break;
                ((MouseListener)listener).mouseEntered(this);
                break;
            }
            case 4: {
                if (!(listener instanceof MouseListener)) break;
                ((MouseListener)listener).mouseExited(this);
                break;
            }
            case 5: {
                if (!(listener instanceof MouseMotionListener)) break;
                ((MouseMotionListener)listener).mouseMoved(this);
                break;
            }
            case 6: {
                if (!(listener instanceof MouseMotionListener)) break;
                ((MouseMotionListener)listener).mouseDragged(this);
                break;
            }
            case 7: {
                if (!(listener instanceof MouseWheelListener)) break;
                ((MouseWheelListener)listener).mouseWheeled(this);
            }
        }
    }

    protected void toString(StringBuilder buf) {
        super.toString(buf);
        buf.append(", type=").append(this._type);
        buf.append(", button=").append(this._button);
        buf.append(", x=").append(this._mx);
        buf.append(", y=").append(this._my);
        if (this._ccount != 0) {
            buf.append(", ccount=").append(this._ccount);
        }
        if (this._delta != 0) {
            buf.append(", delta=").append(this._delta);
        }
    }
}

