/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.opengl.gui.event;

import com.threerings.opengl.gui.event.ComponentListener;
import com.threerings.opengl.gui.event.ControllerListener;
import com.threerings.opengl.gui.event.InputEvent;
import org.lwjgl.input.Controller;

public class ControllerEvent
extends InputEvent {
    public static final int CONTROLLER_PRESSED = 0;
    public static final int CONTROLLER_RELEASED = 1;
    public static final int CONTROLLER_MOVED = 2;
    public static final int CONTROLLER_POV_X_MOVED = 3;
    public static final int CONTROLLER_POV_Y_MOVED = 4;
    protected int _type;
    protected int _controlIndex;
    protected boolean _xAxis;
    protected boolean _yAxis;
    protected float _value;

    public ControllerEvent(Controller source, long when, int modifiers, int type, int controlIndex) {
        this(source, when, modifiers, type, controlIndex, false, false, 0.0f);
    }

    public ControllerEvent(Controller source, long when, int modifiers, int type, float value) {
        this(source, when, modifiers, type, -1, false, false, value);
    }

    public ControllerEvent(Controller source, long when, int modifiers, int type, int controlIndex, boolean xAxis, boolean yAxis, float value) {
        super(source, when, modifiers);
        this._type = type;
        this._controlIndex = controlIndex;
        this._xAxis = xAxis;
        this._yAxis = yAxis;
        this._value = value;
    }

    public Controller getController() {
        return (Controller)this.getSource();
    }

    public int getType() {
        return this._type;
    }

    public int getControlIndex() {
        return this._controlIndex;
    }

    public boolean isXAxis() {
        return this._xAxis;
    }

    public boolean isYAxis() {
        return this._yAxis;
    }

    public float getValue() {
        return this._value;
    }

    public void dispatch(ComponentListener listener) {
        super.dispatch(listener);
        switch (this._type) {
            case 0: {
                if (!(listener instanceof ControllerListener)) break;
                ((ControllerListener)listener).controllerPressed(this);
                break;
            }
            case 1: {
                if (!(listener instanceof ControllerListener)) break;
                ((ControllerListener)listener).controllerReleased(this);
                break;
            }
            case 2: {
                if (!(listener instanceof ControllerListener)) break;
                ((ControllerListener)listener).controllerMoved(this);
                break;
            }
            case 3: {
                if (!(listener instanceof ControllerListener)) break;
                ((ControllerListener)listener).controllerPovXMoved(this);
                break;
            }
            case 4: {
                if (!(listener instanceof ControllerListener)) break;
                ((ControllerListener)listener).controllerPovYMoved(this);
            }
        }
    }

    protected void toString(StringBuilder buf) {
        super.toString(buf);
        buf.append(", type=").append(this._type);
        buf.append(", controlIndex=").append(this._controlIndex);
        buf.append(", xAxis=").append(this._xAxis);
        buf.append(", yAxis=").append(this._yAxis);
        buf.append(", value=").append(this._value);
    }
}

