/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.opengl.gui.config;

import com.samskivert.util.StringUtil;
import com.threerings.config.ConfigManager;
import com.threerings.config.ConfigReference;
import com.threerings.config.ConfigReferenceSet;
import com.threerings.config.ParameterizedConfig;
import com.threerings.editor.Editable;
import com.threerings.editor.EditorTypes;
import com.threerings.editor.FileConstraints;
import com.threerings.export.Exportable;
import com.threerings.expr.Scope;
import com.threerings.expr.util.ScopeUtil;
import com.threerings.opengl.gui.Component;
import com.threerings.opengl.gui.config.ActionConfig;
import com.threerings.opengl.gui.config.ComponentConfig;
import com.threerings.opengl.util.GlContext;
import com.threerings.util.DeepObject;
import com.threerings.util.MessageBundle;
import com.threerings.util.MessageManager;
import java.io.PrintStream;

public class UserInterfaceConfig
extends ParameterizedConfig {
    @Editable
    public Implementation implementation = new Original();
    protected ConfigManager _configs = new ConfigManager();

    public Original getOriginal() {
        return this.implementation.getOriginal(this._configs);
    }

    public Component getComponent(GlContext ctx, Scope scope, Component comp) {
        return this.implementation.getComponent(ctx, scope, comp);
    }

    public void init(ConfigManager cfgmgr) {
        this._configs.init("user_interface", cfgmgr);
        super.init(this._configs);
    }

    public ConfigManager getConfigManager() {
        return this.implementation.getConfigManager(this._configs);
    }

    public boolean validateReferences(String where, PrintStream out) {
        boolean valid = super.validateReferences(where, out);
        return this._configs.validateReferences(where + ":", out) && valid;
    }

    protected void fireConfigUpdated() {
        this.implementation.invalidate();
        super.fireConfigUpdated();
    }

    protected void getUpdateReferences(ConfigReferenceSet refs) {
        this.implementation.getUpdateReferences(refs);
    }

    public static class Derived
    extends Implementation {
        @Editable(nullable=true)
        public ConfigReference<UserInterfaceConfig> userInterface;

        public void getUpdateReferences(ConfigReferenceSet refs) {
            refs.add(UserInterfaceConfig.class, this.userInterface);
        }

        public ConfigManager getConfigManager(ConfigManager cfgmgr) {
            UserInterfaceConfig config = cfgmgr.getConfig(UserInterfaceConfig.class, this.userInterface);
            return config == null ? cfgmgr : config.getConfigManager();
        }

        public Original getOriginal(ConfigManager cfgmgr) {
            UserInterfaceConfig config = cfgmgr.getConfig(UserInterfaceConfig.class, this.userInterface);
            return config == null ? null : config.getOriginal();
        }

        public Component getComponent(GlContext ctx, Scope scope, Component comp) {
            UserInterfaceConfig config = ctx.getConfigManager().getConfig(UserInterfaceConfig.class, this.userInterface);
            return config == null ? null : config.getComponent(ctx, scope, comp);
        }
    }

    public static class Original
    extends Implementation {
        @Editable(hgroup="a")
        public String bundle = "";
        @Editable(hgroup="a")
        public String controller = "";
        @Editable
        public ComponentConfig root = new ComponentConfig.Spacer();
        @Editable(editor="resource", nullable=true)
        @FileConstraints(description="m.sound_files_desc", extensions={".ogg"}, directory="sound_dir")
        public String addSound;
        @Editable(editor="resource", nullable=true)
        @FileConstraints(description="m.sound_files_desc", extensions={".ogg"}, directory="sound_dir")
        public String removeSound;
        @Editable(nullable=true)
        public ActionConfig addAction;
        @Editable(nullable=true)
        public ActionConfig removeAction;

        public ConfigManager getConfigManager(ConfigManager cfgmgr) {
            return cfgmgr;
        }

        public Original getOriginal(ConfigManager cfgmgr) {
            return this;
        }

        public Component getComponent(GlContext ctx, Scope scope, Component comp) {
            MessageManager msgmgr = ctx.getMessageManager();
            MessageBundle msgs = StringUtil.isBlank((String)this.bundle) ? ScopeUtil.resolve(scope, "msgs", msgmgr.getBundle("global"), MessageBundle.class) : msgmgr.getBundle(this.bundle);
            return this.root.getComponent(ctx, scope, msgs, comp);
        }

        public void invalidate() {
            this.root.invalidate();
            if (this.addAction != null) {
                this.addAction.invalidate();
            }
            if (this.removeAction != null) {
                this.removeAction.invalidate();
            }
        }
    }

    @EditorTypes(value={Original.class, Derived.class})
    public static abstract class Implementation
    extends DeepObject
    implements Exportable {
        public void getUpdateReferences(ConfigReferenceSet refs) {
        }

        public abstract ConfigManager getConfigManager(ConfigManager var1);

        public abstract Original getOriginal(ConfigManager var1);

        public abstract Component getComponent(GlContext var1, Scope var2, Component var3);

        public void invalidate() {
        }
    }
}

