/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.opengl.gui.config;

import com.threerings.editor.Editable;
import com.threerings.editor.EditorTypes;
import com.threerings.editor.FileConstraints;
import com.threerings.export.Exportable;
import com.threerings.media.image.Colorization;
import com.threerings.opengl.gui.icon.BlankIcon;
import com.threerings.opengl.gui.icon.Icon;
import com.threerings.opengl.gui.icon.ImageIcon;
import com.threerings.opengl.gui.icon.RotatedIcon;
import com.threerings.opengl.renderer.config.ColorizationConfig;
import com.threerings.opengl.util.GlContext;
import com.threerings.util.DeepObject;
import com.threerings.util.DeepOmit;
import java.lang.ref.SoftReference;
import java.util.HashSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@EditorTypes(value={Image.class, ColorizedImage.class, Rotated.class, Blank.class})
public abstract class IconConfig
extends DeepObject
implements Exportable {
    @DeepOmit
    protected transient SoftReference<Icon> _icon;

    public static com.threerings.opengl.gui.Image getImage(GlContext ctx, String file, ColorizationConfig[] colorizations) {
        Colorization[] zations = new Colorization[colorizations.length];
        for (int ii = 0; ii < zations.length; ++ii) {
            zations[ii] = colorizations[ii].getColorization(ctx);
        }
        return ctx.getImageCache().getImage(file, zations);
    }

    public void getUpdateResources(HashSet<String> paths) {
    }

    public Icon getIcon(GlContext ctx) {
        Icon icon;
        Icon icon2 = icon = this._icon == null ? null : this._icon.get();
        if (icon == null) {
            icon = this.createIcon(ctx);
            this._icon = new SoftReference<Icon>(icon);
        }
        return icon;
    }

    public void invalidate() {
        this._icon = null;
    }

    protected abstract Icon createIcon(GlContext var1);

    public static class Blank
    extends IconConfig {
        @Editable(hgroup="d")
        public int width;
        @Editable(hgroup="d")
        public int height;

        protected Icon createIcon(GlContext ctx) {
            return new BlankIcon(this.width, this.height);
        }
    }

    public static class Rotated
    extends IconConfig {
        @Editable(min=-180.0, max=180.0)
        public float rotation;
        @Editable(nullable=true)
        public IconConfig icon;

        protected Icon createIcon(GlContext ctx) {
            return this.icon == null ? new BlankIcon(1, 1) : new RotatedIcon(this.icon.createIcon(ctx), this.rotation);
        }
    }

    public static class ColorizedImage
    extends Image {
        @Editable
        public ColorizationConfig[] colorizations = new ColorizationConfig[0];

        public com.threerings.opengl.gui.Image getImage(GlContext ctx) {
            return ColorizedImage.getImage(ctx, this.file, this.colorizations);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Image
    extends IconConfig {
        @Editable(editor="resource", nullable=true)
        @FileConstraints(description="m.image_files_desc", extensions={".png", ".jpg", ".dds"}, directory="image_dir")
        public String file;

        public com.threerings.opengl.gui.Image getImage(GlContext ctx) {
            return ctx.getImageCache().getImage(this.file, new Colorization[0]);
        }

        @Override
        public void getUpdateResources(HashSet<String> paths) {
            if (this.file != null) {
                paths.add(this.file);
            }
        }

        @Override
        protected Icon createIcon(GlContext ctx) {
            return this.file == null ? new BlankIcon(1, 1) : new ImageIcon(this.getImage(ctx));
        }
    }
}

