/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.opengl.gui.config;

import com.threerings.config.ManagedConfig;
import com.threerings.editor.Editable;
import com.threerings.editor.FileConstraints;
import com.threerings.opengl.gui.Cursor;
import com.threerings.opengl.renderer.config.ColorizationConfig;
import com.threerings.opengl.renderer.config.TextureConfig;
import com.threerings.opengl.util.GlContext;
import com.threerings.util.DeepOmit;
import java.lang.ref.SoftReference;
import java.util.HashSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CursorConfig
extends ManagedConfig {
    @Editable(editor="resource", nullable=true)
    @FileConstraints(description="m.image_files_desc", extensions={".png", ".jpg"}, directory="image_dir")
    public String image;
    @Editable
    public ColorizationConfig[] colorizations = new ColorizationConfig[0];
    @Editable(min=0.0, hgroup="h")
    public int hotSpotX;
    @Editable(min=0.0, hgroup="h")
    public int hotSpotY;
    @DeepOmit
    protected transient SoftReference<Cursor> _cursor;

    public Cursor getCursor(GlContext ctx) {
        Cursor cursor;
        Cursor cursor2 = cursor = this._cursor == null ? null : this._cursor.get();
        if (cursor == null) {
            cursor = new Cursor(TextureConfig.getImage(ctx, this.image, this.colorizations), this.hotSpotX, this.hotSpotY);
            this._cursor = new SoftReference<Cursor>(cursor);
        }
        return cursor;
    }

    @Override
    protected void fireConfigUpdated() {
        this._cursor = null;
        super.fireConfigUpdated();
    }

    @Override
    protected void getUpdateResources(HashSet<String> paths) {
        if (this.image != null) {
            paths.add(this.image);
        }
    }
}

