/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.opengl.gui.border;

import com.threerings.opengl.gui.border.Border;
import com.threerings.opengl.gui.util.Insets;
import com.threerings.opengl.renderer.Color4f;
import com.threerings.opengl.renderer.Renderer;
import org.lwjgl.opengl.GL11;

public class LineBorder
extends Border {
    protected Color4f _color = new Color4f();
    protected int _width;
    protected static final Insets ONE_PIXEL_INSETS = new Insets(1, 1, 1, 1);

    public LineBorder(Color4f color) {
        this(color, 1);
    }

    public LineBorder(Color4f color, int width) {
        this._color.set(color);
        this._width = width;
    }

    public Insets adjustInsets(Insets insets) {
        return new Insets(this._width + insets.left, this._width + insets.top, this._width + insets.right, this._width + insets.bottom);
    }

    public void render(Renderer renderer, int x, int y, int width, int height, float alpha) {
        super.render(renderer, x, y, width, height, alpha);
        float offset = (float)this._width / 2.0f;
        float a = this._color.a * alpha;
        renderer.setColorState(this._color.r * a, this._color.g * a, this._color.b * a, a);
        renderer.setTextureState(null);
        GL11.glLineWidth((float)this._width);
        GL11.glBegin((int)3);
        GL11.glVertex2f((float)((float)x + offset), (float)((float)y + offset));
        GL11.glVertex2f((float)((float)(x + width) - offset), (float)((float)y + offset));
        GL11.glVertex2f((float)((float)(x + width) - offset), (float)((float)(y + height) - offset));
        GL11.glVertex2f((float)((float)x + offset), (float)((float)(y + height) - offset));
        GL11.glVertex2f((float)((float)x + offset), (float)((float)y + offset));
        GL11.glEnd();
        GL11.glLineWidth((float)1.0f);
    }
}

