/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.opengl.gui;

import com.google.common.base.Function;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import com.samskivert.util.StringUtil;
import com.threerings.config.ConfigEvent;
import com.threerings.config.ConfigManager;
import com.threerings.config.ConfigReference;
import com.threerings.config.ConfigUpdateListener;
import com.threerings.config.ManagedConfig;
import com.threerings.expr.DynamicScope;
import com.threerings.expr.MutableLong;
import com.threerings.expr.Scoped;
import com.threerings.opengl.gui.Component;
import com.threerings.opengl.gui.Container;
import com.threerings.opengl.gui.EditableTextComponent;
import com.threerings.opengl.gui.Log;
import com.threerings.opengl.gui.Root;
import com.threerings.opengl.gui.TextComponent;
import com.threerings.opengl.gui.ToggleButton;
import com.threerings.opengl.gui.Window;
import com.threerings.opengl.gui.config.InterfaceScriptConfig;
import com.threerings.opengl.gui.config.UserInterfaceConfig;
import com.threerings.opengl.gui.event.ComponentListener;
import com.threerings.opengl.gui.layout.BorderLayout;
import com.threerings.opengl.util.GlContext;
import com.threerings.opengl.util.GlContextWrapper;
import com.threerings.opengl.util.Tickable;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UserInterface
extends Container {
    protected DynamicScope _scope = new DynamicScope(this, "interface");
    protected UserInterfaceConfig _config;
    protected Controller _controller;
    protected ListMultimap<String, Component> _tagged = ArrayListMultimap.create();
    protected Root _root;
    protected List<Script> _scripts = Lists.newArrayList();
    @Scoped
    protected MutableLong _epoch = new MutableLong(System.currentTimeMillis());

    public UserInterface(GlContext ctx) {
        this(ctx, (UserInterfaceConfig)null);
    }

    public UserInterface(GlContext ctx, String name) {
        this(ctx, ctx.getConfigManager().getConfig(UserInterfaceConfig.class, name));
    }

    public UserInterface(GlContext ctx, String name, String firstKey, Object firstValue, Object ... otherArgs) {
        this(ctx, ctx.getConfigManager().getConfig(UserInterfaceConfig.class, name, firstKey, firstValue, otherArgs));
    }

    public UserInterface(GlContext ctx, ConfigReference<UserInterfaceConfig> ref) {
        this(ctx, ctx.getConfigManager().getConfig(UserInterfaceConfig.class, ref));
    }

    public UserInterface(GlContext ctx, UserInterfaceConfig config) {
        super(ctx, new BorderLayout());
        this._scope.setParentScope(ctx.getScope());
        this._ctx = new GlContextWrapper(ctx){

            public ConfigManager getConfigManager() {
                return UserInterface.this._config == null ? this._wrapped.getConfigManager() : UserInterface.this._config.getConfigManager();
            }
        };
        this.setConfig(config);
    }

    public DynamicScope getScope() {
        return this._scope;
    }

    public void setConfig(String name) {
        this.setConfig(this._ctx.getConfigManager().getConfig(UserInterfaceConfig.class, name));
    }

    public void setConfig(ConfigReference<UserInterfaceConfig> ref) {
        this.setConfig(this._ctx.getConfigManager().getConfig(UserInterfaceConfig.class, ref));
    }

    public void setConfig(String name, String firstKey, Object firstValue, Object ... otherArgs) {
        this.setConfig(this._ctx.getConfigManager().getConfig(UserInterfaceConfig.class, name, firstKey, firstValue, otherArgs));
    }

    public void setConfig(UserInterfaceConfig config) {
        if (this._config == config) {
            return;
        }
        if (this._config != null) {
            this._config.removeListener(this);
        }
        if ((this._config = config) != null) {
            this._config.addListener(this);
        }
        this.updateFromConfig();
    }

    public UserInterfaceConfig getConfig() {
        return this._config;
    }

    public void setEnabled(String tag, boolean enabled) {
        for (Component comp : this.getComponents(tag)) {
            comp.setEnabled(enabled);
        }
    }

    public void setVisible(String tag, boolean visible) {
        for (Component comp : this.getComponents(tag)) {
            comp.setVisible(visible);
        }
    }

    public void setHoverable(String tag, boolean hoverable) {
        for (Component comp : this.getComponents(tag)) {
            comp.setHoverable(hoverable);
        }
    }

    public void setText(String tag, String text) {
        for (TextComponent comp : this.getComponents(tag, TextComponent.class)) {
            comp.setText(text);
        }
    }

    public String getText(String tag) {
        TextComponent comp = this.getComponent(tag, EditableTextComponent.class);
        if (comp == null && (comp = this.getComponent(tag, TextComponent.class)) == null) {
            Log.log.warning((Object)"Not a text component.", new Object[]{"tag", tag, "components", this.getComponents(tag)});
            return "";
        }
        return comp.getText();
    }

    public boolean isSelected(String tag) {
        ToggleButton comp = this.getComponent(tag, ToggleButton.class);
        if (comp == null) {
            Log.log.warning((Object)"Not a toggle button.", new Object[]{"tag", tag, "component", this.getComponent(tag)});
            return false;
        }
        return comp.isSelected();
    }

    public void addListener(String tag, ComponentListener listener) {
        for (Component comp : this.getComponents(tag)) {
            comp.addListener(listener);
        }
    }

    public void removeListener(String tag, ComponentListener listener) {
        for (Component comp : this.getComponents(tag)) {
            comp.removeListener(listener);
        }
    }

    public void removeAllListeners(String tag) {
        for (Component comp : this.getComponents(tag)) {
            comp.removeAllListeners();
        }
    }

    public Component getComponent(String tag) {
        return (Component)Iterables.getFirst(this.getComponents(tag), null);
    }

    public <C extends Component> C getComponent(String tag, Class<C> clazz) {
        return (C)((Component)Iterables.getFirst(this.getComponents(tag, clazz), null));
    }

    public <C extends Component> Iterable<C> getComponents(String tag, Class<C> clazz) {
        return Iterables.filter(this.getComponents(tag), clazz);
    }

    public Iterable<Component> getComponents(String tag) {
        if (StringUtil.isBlank((String)tag)) {
            return Collections.singletonList(this);
        }
        int idx = tag.indexOf(47);
        if (idx == -1) {
            return this._tagged.get((Object)tag);
        }
        final String nextpath = tag.substring(idx + 1);
        tag = tag.substring(0, idx);
        return Iterables.concat((Iterable)Iterables.transform(this.getComponents(tag, UserInterface.class), (Function)new Function<UserInterface, Iterable<Component>>(){

            public Iterable<Component> apply(UserInterface comp) {
                return comp.getComponents(nextpath);
            }
        }));
    }

    public Map<String, Collection<Component>> getTagged() {
        return this._tagged.asMap();
    }

    public boolean replace(String tag, Component newc) {
        Component oldc;
        List list = this._tagged.get((Object)tag);
        if (!list.isEmpty() && (oldc = (Component)list.get(0)).getParent().replace(oldc, newc)) {
            list.set(0, newc);
            return true;
        }
        return false;
    }

    public Root getRoot() {
        return this._root;
    }

    public void runScript(String name) {
        this.runScript(this._ctx.getConfigManager().getConfig(InterfaceScriptConfig.class, name));
    }

    public void runScript(ConfigReference<InterfaceScriptConfig> ref) {
        this.runScript(this._ctx.getConfigManager().getConfig(InterfaceScriptConfig.class, ref));
    }

    public void runScript(String name, String firstKey, Object firstValue, Object ... otherArgs) {
        this.runScript(this._ctx.getConfigManager().getConfig(InterfaceScriptConfig.class, name, firstKey, firstValue, otherArgs));
    }

    public void runScript(InterfaceScriptConfig config) {
        this.addScript(new ConfigScript(config));
    }

    public void addScript(Script script) {
        if (this._root == null) {
            throw new IllegalStateException("Can't add script to non-added interface.");
        }
        this._scripts.add(script);
        script.init();
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.checkController();
    }

    @Override
    public void setVisible(boolean visible) {
        super.setVisible(visible);
        this.checkController();
    }

    @Override
    public void configUpdated(ConfigEvent<ManagedConfig> event) {
        if (event.getConfig() instanceof UserInterfaceConfig) {
            this.updateFromConfig();
        } else {
            super.configUpdated(event);
        }
    }

    @Override
    protected void wasAdded() {
        super.wasAdded();
        Window window = this.getWindow();
        Root root = this._root = window == null ? null : window.getRoot();
        if (this._root == null) {
            return;
        }
        UserInterfaceConfig.Original original = this.getOriginal();
        if (original.addSound != null) {
            this._root.playSound(original.addSound);
        }
        this.checkController();
        if (original.addAction != null) {
            original.addAction.execute(this, null);
        }
    }

    @Override
    protected void wasRemoved() {
        super.wasRemoved();
        if (this._root == null) {
            return;
        }
        this.checkController();
        UserInterfaceConfig.Original original = this.getOriginal();
        if (original.removeSound != null) {
            this._root.playSound(original.removeSound);
        }
        if (original.removeAction != null) {
            original.removeAction.execute(this, null);
        }
        for (Script script : this._scripts) {
            script.cleanup();
        }
        this._scripts.clear();
        this._root = null;
    }

    protected void updateFromConfig() {
        String controller;
        this._tagged.clear();
        if (this._controller != null) {
            this._controller.setActive(false);
        }
        this._controller = null;
        Component ocomp = this.getComponentCount() == 0 ? null : this.getComponent(0);
        Component ncomp = this._config == null ? null : this._config.getComponent(this._ctx, this._scope, ocomp);
        this.removeAll();
        if (ncomp != null) {
            this.add(ncomp, BorderLayout.CENTER);
        }
        if (!"".equals(controller = this.getOriginal().controller)) {
            try {
                Controller c = (Controller)Class.forName(controller).newInstance();
                if (c.init(this._ctx.getApp(), this)) {
                    this._controller = c;
                    this.checkController();
                }
            }
            catch (ClassNotFoundException cnfe) {
                Log.log.warning((Object)("Controller not found: " + controller), new Object[0]);
            }
            catch (Exception e) {
                Log.log.warning((Object)"Error initializing controller", new Object[]{"controller", controller, e});
                this._controller = null;
            }
        }
    }

    protected UserInterfaceConfig.Original getOriginal() {
        UserInterfaceConfig.Original orig;
        UserInterfaceConfig.Original original = orig = this._config == null ? null : this._config.getOriginal();
        if (orig == null) {
            orig = new UserInterfaceConfig.Original();
        }
        return orig;
    }

    @Scoped
    protected void registerComponents(Map<String, Collection<Component>> tagged) {
        for (Map.Entry<String, Collection<Component>> entry : tagged.entrySet()) {
            this._tagged.get((Object)entry.getKey()).addAll(entry.getValue());
        }
    }

    @Scoped
    protected void registerComponent(String tag, Component comp) {
        this._tagged.put((Object)tag, (Object)comp);
    }

    protected void checkController() {
        if (this._controller != null) {
            this._controller.setActive(this.isShowing() && this.isEnabled());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class ConfigScript
    extends TickableScript
    implements ConfigUpdateListener<InterfaceScriptConfig> {
        protected InterfaceScriptConfig _config;
        protected InterfaceScriptConfig.Original _original;
        protected float _time;
        protected int _aidx;
        protected boolean _paused;

        public ConfigScript(InterfaceScriptConfig config) {
            this._config = config;
            if (this._config != null) {
                this._config.addListener(this);
            }
            this.updateFromConfig();
        }

        public void setPaused(boolean paused) {
            if (this._paused == paused) {
                return;
            }
            this._paused = paused;
            if (this._paused) {
                UserInterface.this._root.removeTickParticipant(this);
            } else {
                UserInterface.this._root.addTickParticipant(this);
            }
        }

        @Override
        public void configUpdated(ConfigEvent<InterfaceScriptConfig> event) {
            this.updateFromConfig();
        }

        @Override
        public void tick(float elapsed) {
            this._time += elapsed;
            this.executeActions();
            if (this._paused) {
                return;
            }
            if (this._original.loopDuration > 0.0f) {
                if (this._time >= this._original.loopDuration) {
                    this._time %= this._original.loopDuration;
                    this._aidx = 0;
                    this.executeActions();
                }
            } else if (this._aidx >= this._original.actions.length) {
                this.remove();
            }
        }

        @Override
        public void cleanup() {
            super.cleanup();
            if (this._config != null) {
                this._config.removeListener(this);
            }
        }

        protected void updateFromConfig() {
            this._original = this._config.getOriginal(UserInterface.this._ctx.getConfigManager());
            if (this._original == null) {
                this._original = new InterfaceScriptConfig.Original();
            }
        }

        protected void executeActions() {
            while (this._aidx < this._original.actions.length && this._original.actions[this._aidx].time < this._time && !this._paused) {
                this._original.actions[this._aidx].action.execute(UserInterface.this, this);
                ++this._aidx;
            }
        }
    }

    public abstract class TickableScript
    extends Script
    implements Tickable {
        public void init() {
            UserInterface.this._root.addTickParticipant(this);
            this.tick(0.0f);
        }

        public void cleanup() {
            UserInterface.this._root.removeTickParticipant(this);
        }
    }

    public abstract class Script {
        public void init() {
        }

        public void cleanup() {
        }

        public void remove() {
            UserInterface.this._scripts.remove(this);
            this.cleanup();
        }
    }

    public static interface Controller {
        public boolean init(GlContext var1, UserInterface var2);

        public void setActive(boolean var1);
    }
}

