/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.opengl.gui;

import com.threerings.opengl.gui.EditableTextComponent;
import com.threerings.opengl.gui.background.Background;
import com.threerings.opengl.gui.text.Text;
import com.threerings.opengl.gui.util.Dimension;
import com.threerings.opengl.gui.util.Insets;
import com.threerings.opengl.gui.util.Rectangle;
import com.threerings.opengl.renderer.Renderer;
import com.threerings.opengl.util.GlContext;

public class TextField
extends EditableTextComponent {
    protected Text _glyphs;
    protected int _cursx;
    protected int _selx;
    protected int _txoff;

    public TextField(GlContext ctx) {
        this(ctx, "");
    }

    public TextField(GlContext ctx, int maxLength) {
        this(ctx, "", maxLength);
    }

    public TextField(GlContext ctx, String text) {
        this(ctx, text, 0);
    }

    public TextField(GlContext ctx, String text, int maxLength) {
        super(ctx, text, maxLength);
        this._keymap.addMapping(-1, 28, 0);
        this._keymap.addMapping(-1, 156, 0);
    }

    protected String getDefaultStyleConfig() {
        return "Default/TextField";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void renderComponent(Renderer renderer) {
        Background background;
        super.renderComponent(renderer);
        Insets insets = this.getInsets();
        int lineHeight = this.getTextFactory().getHeight();
        if (this.showCursor() && this._cursx != this._selx && (background = this.getSelectionBackground()) != null) {
            int cx = this._cursx - this._txoff;
            int sx = Math.min(Math.max(this._selx - this._txoff, 0), this._width - insets.getHorizontal() - 1);
            int x1 = Math.min(cx, sx);
            int x2 = Math.max(cx, sx);
            background.render(renderer, insets.left + x1, insets.bottom, x2 - x1 + 1, lineHeight, this._alpha);
        }
        if (this._glyphs != null) {
            Rectangle oscissor = TextField.intersectScissor(renderer, this._srect, this.getAbsoluteX() + insets.left, this.getAbsoluteY() + insets.bottom, this._width - insets.getHorizontal(), this._height - insets.getVertical());
            try {
                this._glyphs.render(renderer, insets.left - this._txoff, insets.bottom, this._alpha);
                Object var10_9 = null;
                renderer.setScissor(oscissor);
            }
            catch (Throwable throwable) {
                Object var10_10 = null;
                renderer.setScissor(oscissor);
                throw throwable;
            }
        }
        if (this.showCursor() && this._cursx == this._selx) {
            this.renderCursor(renderer, insets.left - this._txoff + this._cursx, insets.bottom, lineHeight);
        }
    }

    protected Dimension computePreferredSize(int whint, int hhint) {
        Dimension d;
        Dimension dimension = d = this._glyphs == null ? new Dimension(0, this.getTextFactory().getHeight()) : new Dimension(this._glyphs.getSize());
        if (this._prefWidth != -1) {
            d.width = this._prefWidth;
        }
        return d;
    }

    protected boolean processCommand(int cmd) {
        switch (cmd) {
            default: {
                return super.processCommand(cmd);
            }
            case 9: {
                this.setCursorPos(0);
                break;
            }
            case 10: {
                this.setCursorPos(this._text.getLength());
            }
        }
        return true;
    }

    protected String validatePaste(String pasted) {
        int idx = pasted.indexOf(10);
        return idx == -1 ? pasted : pasted.substring(0, idx);
    }

    protected boolean hasGlyphs() {
        return this._glyphs != null;
    }

    protected void createGlyphs() {
        this._glyphs = this.getTextFactory().createText(this.getDisplayText(), this.getColor(), 3, 1, null, true);
    }

    protected void clearGlyphs() {
        this._glyphs = null;
    }

    protected int getPosition(int mouseX, int mouseY) {
        return this._glyphs.getHitPos(mouseX + this._txoff, mouseY);
    }

    protected void selectionWasSet() {
        if (this._glyphs == null) {
            this._selx = 0;
            this._cursx = 0;
        } else {
            this._cursx = this._glyphs.getCursorPos(this._cursp);
            int n = this._selx = this._cursp == this._selp ? this._cursx : this._glyphs.getCursorPos(this._selp);
        }
        if (this._cursx < this._txoff) {
            this._txoff = this._cursx;
        } else if (this._width > 0) {
            int avail = this.getWidth() - this.getInsets().getHorizontal();
            if (this._cursx > this._txoff + avail) {
                this._txoff = this._cursx - avail;
            } else if (this._glyphs != null && this._glyphs.getSize().width - this._txoff < avail) {
                this._txoff = Math.max(0, this._cursx - avail);
            }
        }
    }
}

