/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.opengl.gui;

import com.samskivert.util.Interval;
import com.threerings.opengl.gui.Label;
import com.threerings.opengl.gui.config.StyleConfig;
import com.threerings.opengl.gui.icon.BlankIcon;
import com.threerings.opengl.gui.icon.Icon;
import com.threerings.opengl.util.GlContext;

public class StatusLabel
extends Label {
    protected Icon[] _icons = new Icon[this.getStateCount()];
    protected Interval _flashAlert;
    protected static final long FLASH_DELAY = 300L;

    public StatusLabel(GlContext ctx) {
        super(ctx, "");
    }

    public void setStatus(String bundle, String message, boolean flash) {
        this.setStatus(this._ctx.getApp().xlate(bundle, message), flash);
    }

    public void setStatus(String message, boolean flash) {
        Icon alert;
        super.setText(message);
        if (this._flashAlert != null) {
            this._flashAlert.cancel();
        }
        final BlankIcon blank = (alert = this._icons[this.getState()]) == null ? null : new BlankIcon(alert.getWidth(), alert.getHeight());
        this.setIcon(flash ? alert : blank);
        if (flash) {
            this._flashAlert = new Interval(this._ctx.getApp().getRunQueue()){
                protected int _flashCount;
                {
                    super(x0);
                    this._flashCount = 0;
                }

                public void expired() {
                    ++this._flashCount;
                    StatusLabel.this.setIcon(this._flashCount % 2 == 0 ? alert : blank);
                    if (this._flashCount == 5) {
                        this.cancel();
                    }
                }
            };
            this._flashAlert.schedule(300L, true);
        }
    }

    public void setText(String text) {
        if (this._icons == null) {
            super.setText(text);
        } else {
            this.setStatus(text, false);
        }
    }

    protected String getDefaultStyleConfig() {
        return "Default/StatusLabel";
    }

    protected void updateFromStyleConfig(int state, StyleConfig.Original config) {
        super.updateFromStyleConfig(state, config);
        this._icons[state] = config.icon == null ? null : config.icon.getIcon(this._ctx);
    }
}

