/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.opengl.gui;

import com.threerings.opengl.gui.BoundedRangeModel;
import com.threerings.opengl.gui.Button;
import com.threerings.opengl.gui.Component;
import com.threerings.opengl.gui.Container;
import com.threerings.opengl.gui.UIConstants;
import com.threerings.opengl.gui.event.ActionEvent;
import com.threerings.opengl.gui.event.ActionListener;
import com.threerings.opengl.gui.event.ChangeEvent;
import com.threerings.opengl.gui.event.ChangeListener;
import com.threerings.opengl.gui.event.MouseAdapter;
import com.threerings.opengl.gui.event.MouseEvent;
import com.threerings.opengl.gui.event.MouseListener;
import com.threerings.opengl.gui.event.MouseWheelListener;
import com.threerings.opengl.gui.layout.BorderLayout;
import com.threerings.opengl.gui.util.Insets;
import com.threerings.opengl.util.GlContext;

public class ScrollBar
extends Container
implements UIConstants {
    protected ChangeListener _updater = new ChangeListener(){

        public void stateChanged(ChangeEvent event) {
            ScrollBar.this.update();
        }
    };
    protected MouseListener _wellListener = new MouseAdapter(){

        public void mousePressed(MouseEvent event) {
            int mx = event.getX() - ScrollBar.this.getAbsoluteX();
            int my = event.getY() - ScrollBar.this.getAbsoluteY();
            int dv = 0;
            if (ScrollBar.this._orient == 0) {
                if (mx < ScrollBar.this._thumb.getX()) {
                    dv = -1;
                } else if (mx > ScrollBar.this._thumb.getX() + ScrollBar.this._thumb.getWidth()) {
                    dv = 1;
                }
            } else if (my < ScrollBar.this._thumb.getY()) {
                dv = 1;
            } else if (my > ScrollBar.this._thumb.getY() + ScrollBar.this._thumb.getHeight()) {
                dv = -1;
            }
            if (dv != 0) {
                ScrollBar.this._model.setValue(ScrollBar.this._model.getValue() + (dv *= Math.max(1, ScrollBar.this._model.getExtent())));
            }
        }
    };
    protected MouseAdapter _thumbListener = new MouseAdapter(){
        protected int _sx;
        protected int _sy;
        protected int _sv;

        public void mousePressed(MouseEvent event) {
            this._sv = ScrollBar.this._model.getValue();
            this._sx = event.getX() - ScrollBar.this.getAbsoluteX();
            this._sy = event.getY() - ScrollBar.this.getAbsoluteY();
        }

        public void mouseDragged(MouseEvent event) {
            int dv = 0;
            if (ScrollBar.this._orient == 0) {
                int mx = event.getX() - ScrollBar.this.getAbsoluteX();
                dv = (mx - this._sx) * ScrollBar.this._model.getRange() / (ScrollBar.this._well.getWidth() - ScrollBar.this._well.getInsets().getHorizontal());
            } else {
                int my = event.getY() - ScrollBar.this.getAbsoluteY();
                dv = (this._sy - my) * ScrollBar.this._model.getRange() / (ScrollBar.this._well.getHeight() - ScrollBar.this._well.getInsets().getVertical());
            }
            if (dv != 0) {
                ScrollBar.this._model.setValue(this._sv + dv);
            }
        }
    };
    protected ActionListener _buttoner = new ActionListener(){

        public void actionPerformed(ActionEvent event) {
            int delta = ScrollBar.this._model.getScrollIncrement();
            if (event.getAction().equals("less")) {
                ScrollBar.this._model.setValue(ScrollBar.this._model.getValue() - delta);
            } else {
                ScrollBar.this._model.setValue(ScrollBar.this._model.getValue() + delta);
            }
        }
    };
    protected BoundedRangeModel _model;
    protected int _orient;
    protected Button _less;
    protected Button _more;
    protected Component _well;
    protected Component _thumb;
    protected MouseWheelListener _wheelListener;

    public ScrollBar(GlContext ctx) {
        this(ctx, 1);
    }

    public ScrollBar(GlContext ctx, int orientation) {
        this(ctx, orientation, 0, 100, 0, 10);
    }

    public ScrollBar(GlContext ctx, int orientation, int min, int value, int extent, int max) {
        this(ctx, orientation, new BoundedRangeModel(min, value, extent, max));
    }

    public ScrollBar(GlContext ctx, int orientation, BoundedRangeModel model) {
        super(ctx, new BorderLayout());
        this._orient = orientation;
        this._model = model;
        this._model.addChangeListener(this._updater);
    }

    public BoundedRangeModel getModel() {
        return this._model;
    }

    public void wasAdded() {
        super.wasAdded();
        this._wheelListener = this._model.createWheelListener();
        this.addListener(this._wheelListener);
        String oprefix = "Default/ScrollBar" + (this._orient == 0 ? "H" : "V");
        this._well = new Component(this._ctx);
        this._well.setStyleConfig(oprefix + "Well");
        this.add(this._well, BorderLayout.CENTER);
        this._well.addListener(this._wellListener);
        this._thumb = new Component(this._ctx);
        this._thumb.setStyleConfig(oprefix + "Thumb");
        this.add(this._thumb, BorderLayout.IGNORE);
        this._thumb.addListener(this._thumbListener);
        this._less = new Button(this._ctx, "");
        this._less.setStyleConfig(oprefix + "Less");
        this.add(this._less, this._orient == 0 ? BorderLayout.WEST : BorderLayout.NORTH);
        this._less.addListener(this._buttoner);
        this._less.setAction("less");
        this._more = new Button(this._ctx, "");
        this._more.setStyleConfig(oprefix + "More");
        this.add(this._more, this._orient == 0 ? BorderLayout.EAST : BorderLayout.SOUTH);
        this._more.addListener(this._buttoner);
        this._more.setAction("more");
    }

    public void wasRemoved() {
        super.wasRemoved();
        if (this._wheelListener != null) {
            this.removeListener(this._wheelListener);
            this._wheelListener = null;
        }
        if (this._well != null) {
            this.remove(this._well);
            this._well = null;
        }
        if (this._thumb != null) {
            this.remove(this._thumb);
            this._thumb = null;
        }
        if (this._less != null) {
            this.remove(this._less);
            this._less = null;
        }
        if (this._more != null) {
            this.remove(this._more);
            this._more = null;
        }
    }

    public Component getHitComponent(int mx, int my) {
        if (this._thumb.getHitComponent(mx - this._x, my - this._y) != null) {
            return this._thumb;
        }
        return super.getHitComponent(mx, my);
    }

    protected void update() {
        if (!this.isAdded()) {
            return;
        }
        Insets winsets = this._well.getInsets();
        int tx = 0;
        int ty = 0;
        int twidth = this._well.getWidth() - winsets.getHorizontal();
        int theight = this._well.getHeight() - winsets.getVertical();
        int range = Math.max(this._model.getRange(), 1);
        int extent = Math.max(this._model.getExtent(), 1);
        if (this._orient == 0) {
            int wellSize = twidth;
            tx = this._model.getValue() * wellSize / range;
            twidth = extent * wellSize / range;
        } else {
            int wellSize = theight;
            ty = (range - extent - this._model.getValue()) * wellSize / range;
            theight = extent * wellSize / range;
        }
        this._thumb.setBounds(this._well.getX() + winsets.left + tx, this._well.getY() + winsets.bottom + ty, twidth, theight);
    }

    protected String getDefaultStyleConfig() {
        return "Default/ScrollBar";
    }

    protected void layout() {
        super.layout();
        this.update();
    }
}

