/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.opengl.gui;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.samskivert.util.StringUtil;
import com.threerings.expr.DynamicScope;
import com.threerings.expr.Scoped;
import com.threerings.math.Transform3D;
import com.threerings.math.Vector3f;
import com.threerings.opengl.camera.Camera;
import com.threerings.opengl.camera.CameraHandler;
import com.threerings.opengl.camera.OrbitCameraHandler;
import com.threerings.opengl.compositor.Compositable;
import com.threerings.opengl.compositor.Compositor;
import com.threerings.opengl.compositor.Dependency;
import com.threerings.opengl.compositor.RenderQueue;
import com.threerings.opengl.gui.Component;
import com.threerings.opengl.gui.Image;
import com.threerings.opengl.gui.Root;
import com.threerings.opengl.gui.util.Insets;
import com.threerings.opengl.gui.util.Rectangle;
import com.threerings.opengl.model.Model;
import com.threerings.opengl.renderer.Color4f;
import com.threerings.opengl.renderer.Renderer;
import com.threerings.opengl.renderer.Texture2D;
import com.threerings.opengl.renderer.TextureRenderer;
import com.threerings.opengl.renderer.state.ColorMaskState;
import com.threerings.opengl.renderer.state.DepthState;
import com.threerings.opengl.renderer.state.TransformState;
import com.threerings.opengl.util.GlContext;
import com.threerings.opengl.util.GlUtil;
import com.threerings.opengl.util.Tickable;
import java.util.List;
import java.util.Map;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.PixelFormat;

public class RenderableView
extends Component
implements Tickable {
    protected DynamicScope _scope = new DynamicScope(this, "view");
    protected Root _root;
    protected Camera _camera = new Camera();
    protected CameraHandler _camhand;
    protected RenderQueue.Group.State _gstate = new RenderQueue.Group.State();
    protected Map<Dependency, Dependency> _dependencies = Maps.newHashMap();
    protected boolean _static;
    protected String _viewNode;
    protected Model[] _configModels = new Model[0];
    protected List<Compositable> _compositables = Lists.newArrayList();
    protected Image _image;
    protected TextureRenderer _renderer;
    @Scoped
    protected Transform3D _viewTransform = this._camera.getViewTransform();
    @Scoped
    protected TransformState _viewTransformState = new TransformState();
    protected Rectangle _oscissor = new Rectangle();

    public RenderableView(GlContext ctx) {
        super(ctx);
        this._camhand = this.createCameraHandler();
    }

    public DynamicScope getScope() {
        return this._scope;
    }

    public Camera getCamera() {
        return this._camera;
    }

    public CameraHandler getCameraHandler() {
        return this._camhand;
    }

    public void setStatic(boolean stat) {
        if (this._static == stat) {
            return;
        }
        this._static = stat;
        if (this._static) {
            this.invalidate();
        } else {
            this._image = null;
            this._renderer = null;
        }
    }

    public boolean isStatic() {
        return this._static;
    }

    public void setViewNode(String node) {
        this._viewNode = node;
    }

    public String getViewNode() {
        return this._viewNode;
    }

    public void setConfigModels(Model[] models) {
        this._configModels = models;
    }

    public Model[] getConfigModels() {
        return this._configModels;
    }

    public void add(Compositable compositable) {
        this._compositables.add(compositable);
    }

    public void remove(Compositable compositable) {
        this._compositables.remove(compositable);
    }

    public void removeAll() {
        this._compositables.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void render() {
        if (!this._static) {
            return;
        }
        Insets insets = this.getInsets();
        int width = this._width - insets.getHorizontal();
        int height = this._height - insets.getVertical();
        if (this._image == null || this._image.getWidth() != width || this._image.getHeight() != height) {
            Texture2D texture;
            Renderer renderer = this._ctx.getRenderer();
            Texture2D texture2D = texture = this._image == null ? null : this._image.getTexture(renderer);
            if (texture == null) {
                texture = new Texture2D(renderer);
                texture.setMinFilter(9729);
                texture.setWrap(33071, 33071);
            }
            int twidth = GlUtil.nextPowerOfTwo(width);
            int theight = GlUtil.nextPowerOfTwo(height);
            if (texture.getWidth() != twidth || texture.getHeight() != theight) {
                texture.setImage(6408, twidth, theight, false, false);
            }
            this._image = new Image(texture, width, height);
            this._renderer = new TextureRenderer(this._ctx, texture, null, width, height, new PixelFormat(1, 8, 0));
        }
        this._renderer.startRender();
        try {
            this.renderView(this._ctx.getRenderer());
        }
        finally {
            this._renderer.commitRender();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void tick(float elapsed) {
        if (this._static) {
            elapsed = 0.0f;
        }
        Compositor compositor = this._ctx.getCompositor();
        Camera ocamera = compositor.getCamera();
        compositor.setCamera(this._camera);
        try {
            for (Model model : this._configModels) {
                model.tick(elapsed);
            }
            int nn = this._compositables.size();
            for (int ii = 0; ii < nn; ++ii) {
                Compositable compositable = this._compositables.get(ii);
                if (!(compositable instanceof Tickable)) continue;
                ((Tickable)((Object)compositable)).tick(elapsed);
            }
        }
        finally {
            compositor.setCamera(ocamera);
        }
    }

    protected void wasAdded() {
        super.wasAdded();
        this._root = this.getWindow().getRoot();
        this._root.addTickParticipant(this);
    }

    protected void wasRemoved() {
        super.wasRemoved();
        this._root.removeTickParticipant(this);
        this._root = null;
    }

    protected void layout() {
        this.render();
    }

    protected void renderComponent(Renderer renderer) {
        if (this._static) {
            if (this._image != null) {
                Insets insets = this.getInsets();
                this._image.render(renderer, insets.left, insets.bottom, this._width - insets.getHorizontal(), this._height - insets.getVertical(), this._alpha);
            }
        } else {
            this.renderView(renderer);
        }
    }

    protected CameraHandler createCameraHandler() {
        return new OrbitCameraHandler(this._ctx, this._camera, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void renderView(Renderer renderer) {
        block11: {
            Compositor compositor = this._ctx.getCompositor();
            Camera ocamera = compositor.getCamera();
            Map<Dependency, Dependency> odeps = compositor.getDependencies();
            RenderQueue.Group group = compositor.getGroup();
            this._gstate.swap(group);
            compositor.setCamera(this._camera);
            compositor.setDependencies(this._dependencies);
            Insets insets = this.getInsets();
            this._camera.getViewport().set(this._static ? 0 : this.getAbsoluteX() + insets.left, this._static ? 0 : this.getAbsoluteY() + insets.bottom, this._width - insets.getHorizontal(), this._height - insets.getVertical());
            this._camhand.updatePerspective();
            Transform3D viewNodeTransform = this.getViewNodeTransform();
            if (viewNodeTransform == null) {
                this._camhand.updatePosition();
            } else {
                this._camera.getWorldTransform().set(viewNodeTransform);
                this._camera.updateTransform();
            }
            this._viewTransformState.getModelview().set(this._viewTransform);
            this._viewTransformState.setDirty(true);
            try {
                if (!this._static) {
                    renderer.setMatrixMode(5888);
                    GL11.glPushMatrix();
                    GL11.glLoadIdentity();
                }
                for (Model model : this._configModels) {
                    model.composite();
                }
                int nn = this._compositables.size();
                for (int ii = 0; ii < nn; ++ii) {
                    this._compositables.get(ii).composite();
                }
                compositor.enqueueEnqueueables();
                group.sortQueues();
                this._camera.apply(renderer);
                Rectangle oscissor = renderer.getScissor();
                if (oscissor != null) {
                    this._oscissor.set(oscissor);
                }
                renderer.setScissor(this._camera.getViewport());
                renderer.setClearDepth(1.0f);
                renderer.setState(DepthState.TEST_WRITE);
                if (this._static) {
                    renderer.setState(ColorMaskState.ALL);
                    renderer.setClearColor(new Color4f(0.0f, 0.0f, 0.0f, 0.0f));
                    GL11.glClear((int)16640);
                } else {
                    GL11.glClear((int)256);
                }
                renderer.setScissor(oscissor == null ? null : this._oscissor);
                group.renderQueues("normal");
                Object var13_14 = null;
                compositor.clearDependencies();
                group.clearQueues();
                compositor.setCamera(ocamera);
                compositor.setDependencies(odeps);
                this._gstate.swap(group);
                if (this._static) break block11;
                Rectangle viewport = ocamera.getViewport();
                renderer.setViewport(viewport);
                renderer.setProjection(0.0f, viewport.width, 0.0f, viewport.height, -1.0f, 1.0f, Vector3f.UNIT_Z, true);
                renderer.setStates(this._root.getStates());
                renderer.setMatrixMode(5888);
            }
            catch (Throwable throwable) {
                Object var13_15 = null;
                compositor.clearDependencies();
                group.clearQueues();
                compositor.setCamera(ocamera);
                compositor.setDependencies(odeps);
                this._gstate.swap(group);
                if (!this._static) {
                    Rectangle viewport = ocamera.getViewport();
                    renderer.setViewport(viewport);
                    renderer.setProjection(0.0f, viewport.width, 0.0f, viewport.height, -1.0f, 1.0f, Vector3f.UNIT_Z, true);
                    renderer.setStates(this._root.getStates());
                    renderer.setMatrixMode(5888);
                    GL11.glPopMatrix();
                }
                throw throwable;
            }
            GL11.glPopMatrix();
            {
            }
        }
    }

    protected Transform3D getViewNodeTransform() {
        if (StringUtil.isBlank((String)this._viewNode)) {
            return null;
        }
        for (Model model : this._configModels) {
            Transform3D xform = model.getPointWorldTransform(this._viewNode);
            if (xform == null) continue;
            return xform;
        }
        int nn = this._compositables.size();
        for (int ii = 0; ii < nn; ++ii) {
            Transform3D xform;
            Compositable compositable = this._compositables.get(ii);
            if (!(compositable instanceof Model) || (xform = ((Model)compositable).getPointWorldTransform(this._viewNode)) == null) continue;
            return xform;
        }
        return null;
    }
}

