/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.opengl.gui;

import com.samskivert.util.ListUtil;
import com.threerings.opengl.gui.Component;
import com.threerings.opengl.gui.TransferHandler;
import com.threerings.opengl.gui.icon.Icon;
import com.threerings.util.ToolUtil;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LocalTransferHandler<T>
extends TransferHandler {
    protected Class<T> _clazz;
    protected DataFlavor _flavor;

    public LocalTransferHandler(Class<T> clazz) {
        this._clazz = clazz;
        this._flavor = ToolUtil.createLocalFlavor(clazz);
    }

    @Override
    public Icon getVisualRepresentation(Transferable data) {
        try {
            return this.getVisualRepresentation(this._clazz.cast(data.getTransferData(this._flavor)));
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public boolean canImport(Component comp, DataFlavor[] transferFlavors) {
        return ListUtil.contains((Object[])transferFlavors, (Object)this._flavor) && this.canImport(comp);
    }

    @Override
    public boolean importData(Component comp, Transferable data) {
        try {
            return this.importObject(comp, this._clazz.cast(data.getTransferData(this._flavor)));
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    protected Transferable createTransferable(Component comp) {
        final T object = this.getObject(comp);
        return new Transferable(){

            public DataFlavor[] getTransferDataFlavors() {
                return new DataFlavor[]{LocalTransferHandler.this._flavor};
            }

            public boolean isDataFlavorSupported(DataFlavor flavor) {
                return flavor.equals(LocalTransferHandler.this._flavor);
            }

            public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException {
                if (flavor.equals(LocalTransferHandler.this._flavor)) {
                    return object;
                }
                throw new UnsupportedFlavorException(flavor);
            }
        };
    }

    @Override
    protected void exportDone(Component source, Transferable data, int action) {
        try {
            this.exportDone(source, this._clazz.cast(data.getTransferData(this._flavor)), action);
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    protected Icon getVisualRepresentation(T object) {
        return null;
    }

    protected boolean canImport(Component comp) {
        return false;
    }

    protected boolean importObject(Component comp, T object) {
        return false;
    }

    protected T getObject(Component comp) {
        throw new UnsupportedOperationException();
    }

    protected void exportDone(Component source, T object, int action) {
    }
}

