/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.opengl.gui;

import com.threerings.opengl.gui.Cursor;
import com.threerings.opengl.gui.Log;
import com.threerings.opengl.gui.Root;
import com.threerings.opengl.util.GlContext;
import java.awt.Component;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;

public class CanvasRoot
extends Root
implements MouseListener,
MouseMotionListener,
MouseWheelListener,
KeyListener {
    protected Component _canvas;

    public CanvasRoot(GlContext ctx, Component canvas) {
        super(ctx);
        this._canvas = canvas;
        this._clipboard = canvas.getToolkit().getSystemClipboard();
        canvas.addMouseListener(this);
        canvas.addMouseMotionListener(this);
        canvas.addMouseWheelListener(this);
        canvas.addKeyListener(this);
    }

    public int getDisplayWidth() {
        return this._canvas.getWidth();
    }

    public int getDisplayHeight() {
        return this._canvas.getHeight();
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
        this._modifiers = this.convertModifiers(e.getModifiersEx());
        this.mousePressed(e.getWhen(), this.convertButton(e), e.getX(), this._canvas.getHeight() - e.getY() - 1, e.isConsumed());
    }

    public void mouseReleased(MouseEvent e) {
        this._modifiers = this.convertModifiers(e.getModifiersEx());
        this.mouseReleased(e.getWhen(), this.convertButton(e), e.getX(), this._canvas.getHeight() - e.getY() - 1, e.isConsumed());
    }

    public void mouseDragged(MouseEvent e) {
        this.mouseMoved(e);
    }

    public void mouseMoved(MouseEvent e) {
        this._modifiers = this.convertModifiers(e.getModifiersEx());
        this.mouseMoved(e.getWhen(), e.getX(), this._canvas.getHeight() - e.getY() - 1, e.isConsumed());
    }

    public void mouseWheelMoved(MouseWheelEvent e) {
        this._modifiers = this.convertModifiers(e.getModifiersEx());
        this.mouseWheeled(e.getWhen(), e.getX(), this._canvas.getHeight() - e.getY() - 1, -e.getWheelRotation(), e.isConsumed());
    }

    public void keyPressed(KeyEvent e) {
        this._modifiers = this.convertModifiers(e.getModifiersEx());
        this.keyPressed(e.getWhen(), e.getKeyChar(), this.convertKeyCode(e), e.isConsumed());
    }

    public void keyReleased(KeyEvent e) {
        this._modifiers = this.convertModifiers(e.getModifiersEx());
        this.keyReleased(e.getWhen(), e.getKeyChar(), this.convertKeyCode(e), e.isConsumed());
    }

    public void keyTyped(KeyEvent e) {
    }

    protected void updateCursor(Cursor cursor) {
        if (cursor == null) {
            cursor = this.getDefaultCursor();
        }
        if (cursor == null) {
            this._canvas.setCursor(null);
        } else {
            this._canvas.setCursor(cursor.getAWTCursor(this._canvas.getToolkit()));
            cursor.show();
        }
    }

    protected int convertModifiers(int modifiers) {
        int nmodifiers = 0;
        if ((modifiers & 0x400) != 0) {
            nmodifiers |= 1;
        }
        if ((modifiers & 0x1000) != 0) {
            nmodifiers |= 2;
        }
        if ((modifiers & 0x800) != 0) {
            nmodifiers |= 4;
        }
        if ((modifiers & 0x40) != 0) {
            nmodifiers |= 8;
        }
        if ((modifiers & 0x80) != 0) {
            nmodifiers |= 0x10;
        }
        if ((modifiers & 0x200) != 0) {
            nmodifiers |= 0x20;
        }
        if ((modifiers & 0x100) != 0) {
            nmodifiers |= 0x40;
        }
        return nmodifiers;
    }

    protected int convertButton(MouseEvent e) {
        switch (e.getButton()) {
            case 1: {
                return 0;
            }
            case 3: {
                return 1;
            }
            case 2: {
                return 2;
            }
            case 0: {
                return -1;
            }
        }
        Log.log.warning((Object)("Requested to map unknown button '" + e.getButton() + "'."), new Object[0]);
        return e.getButton();
    }

    protected int convertKeyCode(KeyEvent e) {
        switch (e.getKeyCode()) {
            case 27: {
                return 1;
            }
            case 49: {
                return 2;
            }
            case 50: {
                return 3;
            }
            case 51: {
                return 4;
            }
            case 52: {
                return 5;
            }
            case 53: {
                return 6;
            }
            case 54: {
                return 7;
            }
            case 55: {
                return 8;
            }
            case 56: {
                return 9;
            }
            case 57: {
                return 10;
            }
            case 48: {
                return 11;
            }
            case 45: {
                return 12;
            }
            case 61: {
                return e.getKeyLocation() == 4 ? 141 : 13;
            }
            case 8: {
                return 14;
            }
            case 9: {
                return 15;
            }
            case 81: {
                return 16;
            }
            case 87: {
                return 17;
            }
            case 69: {
                return 18;
            }
            case 82: {
                return 19;
            }
            case 84: {
                return 20;
            }
            case 89: {
                return 21;
            }
            case 85: {
                return 22;
            }
            case 73: {
                return 23;
            }
            case 79: {
                return 24;
            }
            case 80: {
                return 25;
            }
            case 91: {
                return 26;
            }
            case 93: {
                return 27;
            }
            case 10: {
                return e.getKeyLocation() == 4 ? 156 : 28;
            }
            case 17: {
                return e.getKeyLocation() == 2 ? 29 : 157;
            }
            case 65: {
                return 30;
            }
            case 83: {
                return 31;
            }
            case 68: {
                return 32;
            }
            case 70: {
                return 33;
            }
            case 71: {
                return 34;
            }
            case 72: {
                return 35;
            }
            case 74: {
                return 36;
            }
            case 75: {
                return 37;
            }
            case 76: {
                return 38;
            }
            case 59: {
                return 39;
            }
            case 222: {
                return 40;
            }
            case 192: {
                return 41;
            }
            case 16: {
                return e.getKeyLocation() == 2 ? 42 : 54;
            }
            case 92: {
                return 43;
            }
            case 90: {
                return 44;
            }
            case 88: {
                return 45;
            }
            case 67: {
                return 46;
            }
            case 86: {
                return 47;
            }
            case 66: {
                return 48;
            }
            case 78: {
                return 49;
            }
            case 77: {
                return 50;
            }
            case 44: {
                return e.getKeyLocation() == 4 ? 179 : 51;
            }
            case 46: {
                return 52;
            }
            case 47: {
                return 53;
            }
            case 106: {
                return 55;
            }
            case 32: {
                return 57;
            }
            case 20: {
                return 58;
            }
            case 112: {
                return 59;
            }
            case 113: {
                return 60;
            }
            case 114: {
                return 61;
            }
            case 115: {
                return 62;
            }
            case 116: {
                return 63;
            }
            case 117: {
                return 64;
            }
            case 118: {
                return 65;
            }
            case 119: {
                return 66;
            }
            case 120: {
                return 67;
            }
            case 121: {
                return 68;
            }
            case 144: {
                return 69;
            }
            case 145: {
                return 70;
            }
            case 103: {
                return 71;
            }
            case 104: {
                return 72;
            }
            case 105: {
                return 73;
            }
            case 109: {
                return 74;
            }
            case 100: {
                return 75;
            }
            case 101: {
                return 76;
            }
            case 102: {
                return 77;
            }
            case 107: {
                return 78;
            }
            case 97: {
                return 79;
            }
            case 98: {
                return 80;
            }
            case 99: {
                return 81;
            }
            case 96: {
                return 82;
            }
            case 110: {
                return 83;
            }
            case 122: {
                return 87;
            }
            case 123: {
                return 88;
            }
            case 61440: {
                return 100;
            }
            case 61441: {
                return 101;
            }
            case 61442: {
                return 102;
            }
            case 21: {
                return 112;
            }
            case 28: {
                return 121;
            }
            case 29: {
                return 123;
            }
            case 514: {
                return 144;
            }
            case 512: {
                return 145;
            }
            case 513: {
                return 146;
            }
            case 523: {
                return 147;
            }
            case 25: {
                return 148;
            }
            case 65480: {
                return 149;
            }
            case 0: {
                return 151;
            }
            case 111: {
                return 181;
            }
            case 154: {
                return 183;
            }
            case 19: {
                return 197;
            }
            case 36: {
                return 199;
            }
            case 38: {
                return 200;
            }
            case 33: {
                return 201;
            }
            case 37: {
                return 203;
            }
            case 39: {
                return 205;
            }
            case 35: {
                return 207;
            }
            case 40: {
                return 208;
            }
            case 34: {
                return 209;
            }
            case 155: {
                return 210;
            }
            case 127: {
                return 211;
            }
        }
        return 151;
    }
}

