/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.opengl.gui;

import com.google.common.collect.Lists;
import com.threerings.opengl.gui.Selectable;
import com.threerings.opengl.gui.ToggleButton;
import com.threerings.opengl.gui.event.ActionEvent;
import com.threerings.opengl.gui.event.ActionListener;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ButtonGroup
implements ActionListener,
Selectable<ToggleButton> {
    protected boolean _alwaysSelect;
    protected List<ToggleButton> _buttons = Lists.newArrayList();
    protected List<ActionListener> _listeners = Lists.newArrayList();

    public ButtonGroup(ToggleButton ... buttons) {
        this(true, buttons);
    }

    public ButtonGroup(boolean alwaysSelect, ToggleButton ... buttons) {
        this._alwaysSelect = alwaysSelect;
        for (ToggleButton button : buttons) {
            this.add(button);
        }
    }

    public void addListener(ActionListener listener) {
        this._listeners.add(listener);
    }

    public void removeListener(ActionListener listener) {
        this._listeners.remove(listener);
    }

    public void add(ToggleButton button) {
        if (this.getSelectedIndex() != -1) {
            button.setSelected(false);
        } else if (this._alwaysSelect) {
            button.setSelected(true);
        }
        this._buttons.add(button);
        button.addListener(this);
    }

    public void remove(ToggleButton button) {
        this._buttons.remove(button);
        button.removeListener(this);
        if (this._alwaysSelect && button.isSelected() && !this._buttons.isEmpty()) {
            this._buttons.get(0).setSelected(true);
        }
    }

    public void removeAll() {
        int nn = this._buttons.size();
        for (int ii = 0; ii < nn; ++ii) {
            this._buttons.get(ii).removeListener(this);
        }
        this._buttons.clear();
    }

    public int getButtonCount() {
        return this._buttons.size();
    }

    public void setAlwaysSelect(boolean alwaysSelect) {
        this._alwaysSelect = alwaysSelect;
        if (this._alwaysSelect && this.getSelectedIndex() == -1 && this.getButtonCount() > 0) {
            this.setSelected(this._buttons.get(0));
        }
    }

    @Override
    public ToggleButton getSelected() {
        int idx = this.getSelectedIndex();
        return idx == -1 ? null : this._buttons.get(idx);
    }

    @Override
    public void setSelected(ToggleButton button) {
        if (!button.isSelected()) {
            button.setSelected(true);
            this.selectionChanged(button, 0L, 0);
        }
    }

    public ToggleButton getButton(int idx) {
        return this._buttons.get(idx);
    }

    @Override
    public void setSelectedIndex(int idx) {
        this.setSelected(this._buttons.get(idx));
    }

    @Override
    public int getSelectedIndex() {
        int nn = this._buttons.size();
        for (int ii = 0; ii < nn; ++ii) {
            if (!this._buttons.get(ii).isSelected()) continue;
            return ii;
        }
        return -1;
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        ToggleButton button = (ToggleButton)event.getSource();
        if (button.isSelected()) {
            this.selectionChanged(button, event.getWhen(), event.getModifiers());
        } else if (this._alwaysSelect) {
            button.setSelected(true);
        }
    }

    protected void selectionChanged(ToggleButton selected, long when, int modifiers) {
        int nn = this._buttons.size();
        for (int ii = 0; ii < nn; ++ii) {
            ToggleButton button = this._buttons.get(ii);
            if (button == selected) continue;
            button.setSelected(false);
        }
        ActionEvent event = new ActionEvent(this, when, modifiers, "select", selected);
        int nn2 = this._listeners.size();
        for (int ii = 0; ii < nn2; ++ii) {
            event.dispatch(this._listeners.get(ii));
        }
    }
}

