/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.opengl.gui;

import com.threerings.opengl.gui.event.ChangeEvent;
import com.threerings.opengl.gui.event.ChangeListener;
import com.threerings.opengl.gui.event.MouseEvent;
import com.threerings.opengl.gui.event.MouseWheelListener;
import java.util.ArrayList;

public class BoundedRangeModel {
    protected int _min;
    protected int _max;
    protected int _value;
    protected int _extent;
    protected ArrayList<ChangeListener> _listeners = new ArrayList();
    protected ChangeEvent _event = new ChangeEvent(this);

    public BoundedRangeModel(int min, int value, int extent, int max) {
        this._min = min;
        this._value = value;
        this._extent = extent;
        this._max = max;
    }

    public void addChangeListener(ChangeListener listener) {
        this._listeners.add(listener);
    }

    public void removeChangeListener(ChangeListener listener) {
        this._listeners.remove(listener);
    }

    public int getMinimum() {
        return this._min;
    }

    public int getMaximum() {
        return this._max;
    }

    public int getRange() {
        return this._max - this._min;
    }

    public int getValue() {
        return this._value;
    }

    public int getExtent() {
        return this._extent;
    }

    public float getRatio() {
        return (float)(this.getValue() - this.getMinimum()) / (float)this.getRange();
    }

    public int getScrollIncrement() {
        return Math.max(1, this.getExtent() / 2);
    }

    public void setMinimum(int minimum) {
        int max = Math.max(minimum, this._max);
        int val = Math.max(minimum, this._value);
        this.setRange(minimum, val, Math.max(max - val, this._extent), max);
    }

    public void setMaximum(int maximum) {
        int min = Math.min(maximum, this._min);
        int ext = Math.min(maximum - min, this._extent);
        this.setRange(min, Math.max(maximum - ext, this._value), ext, maximum);
    }

    public void setValue(int value) {
        int val = Math.min(this._max - this._extent, Math.max(this._min, value));
        this.setRange(this._min, val, this._extent, this._max);
    }

    public void setExtent(int extent) {
        int ext = Math.min(this._max - this._value, Math.max(0, extent));
        this.setRange(this._min, this._value, ext, this._max);
    }

    public boolean setRange(int min, int value, int extent, int max) {
        min = Math.min(min, max);
        max = Math.max(max, value);
        min = Math.min(min, value);
        extent = Math.max(Math.min(extent, max - value), 0);
        if (min != this._min || this._value != value || this._extent != extent || this._max != max) {
            this._min = min;
            this._value = value;
            this._extent = extent;
            this._max = max;
            int ll = this._listeners.size();
            for (int ii = 0; ii < ll; ++ii) {
                this._listeners.get(ii).stateChanged(this._event);
            }
            return true;
        }
        return false;
    }

    public MouseWheelListener createWheelListener() {
        return new MouseWheelListener(){

            public void mouseWheeled(MouseEvent event) {
                int delta = BoundedRangeModel.this.getScrollIncrement();
                if ((event.getModifiers() & 0x10) != 0) {
                    delta *= 2;
                }
                if (event.getDelta() > 0) {
                    BoundedRangeModel.this.setValue(BoundedRangeModel.this.getValue() - delta);
                } else {
                    BoundedRangeModel.this.setValue(BoundedRangeModel.this.getValue() + delta);
                }
            }
        };
    }

    public String toString() {
        return "Bounded Range (min:" + this._min + ", max:" + this._max + ", value:" + this._value + ", extent:" + this._extent + ")";
    }
}

