/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.opengl.geometry;

import com.threerings.opengl.geometry.Geometry;
import com.threerings.opengl.renderer.BufferObject;
import java.nio.FloatBuffer;
import org.lwjgl.BufferUtils;

public abstract class DynamicGeometry
extends Geometry {
    protected float[] _data;
    protected BufferObject _arrayBuffer;
    protected FloatBuffer _floatArray;
    protected static FloatBuffer _scratchBuffer;

    public DynamicGeometry(float[] data, BufferObject arrayBuffer) {
        this(data, arrayBuffer, null);
    }

    public DynamicGeometry(float[] data, FloatBuffer floatArray) {
        this(data, null, floatArray);
    }

    public DynamicGeometry(float[] data, BufferObject arrayBuffer, FloatBuffer floatArray) {
        this._data = data;
        this._arrayBuffer = arrayBuffer;
        this._floatArray = floatArray == null ? DynamicGeometry.getScratchBuffer(data.length) : floatArray;
    }

    public boolean requiresUpdate() {
        return true;
    }

    public void update() {
        this.updateData();
        this._floatArray.clear();
        this._floatArray.put(this._data).flip();
        if (this._arrayBuffer != null) {
            this._arrayBuffer.setData(this._floatArray, 35040);
        }
    }

    protected DynamicGeometry() {
    }

    protected abstract void updateData();

    protected static FloatBuffer getScratchBuffer(int size) {
        if (_scratchBuffer == null || _scratchBuffer.capacity() < size) {
            _scratchBuffer = BufferUtils.createFloatBuffer((int)size);
        }
        return _scratchBuffer;
    }
}

