/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.opengl.effect.config;

import com.samskivert.util.RandomUtil;
import com.threerings.editor.Editable;
import com.threerings.editor.EditorTypes;
import com.threerings.export.Exportable;
import com.threerings.math.FloatMath;
import com.threerings.math.Matrix4f;
import com.threerings.math.Vector3f;
import com.threerings.opengl.effect.BaseParticleSystem;
import com.threerings.opengl.effect.Particle;
import com.threerings.opengl.effect.Shooter;
import com.threerings.util.DeepObject;

@EditorTypes(value={Cone.class, Outward.class})
public abstract class ShooterConfig
extends DeepObject
implements Exportable {
    public abstract Shooter createShooter(BaseParticleSystem.Layer var1);

    public static class Outward
    extends ShooterConfig {
        @Editable(step=0.01)
        public float upwardBias;

        public Shooter createShooter(final BaseParticleSystem.Layer layer) {
            return new Shooter(){

                public Vector3f shoot(Particle particle) {
                    Vector3f velocity = particle.getVelocity().set(Vector3f.ZERO);
                    layer.pointToLayer(velocity, true);
                    particle.getPosition().subtract(velocity, velocity);
                    float length = velocity.length();
                    if (length > 0.001f) {
                        velocity.multLocal(1.0f / length);
                    } else {
                        float cosa = FloatMath.random(-1.0f, 1.0f);
                        float sina = FloatMath.sqrt(1.0f - cosa * cosa);
                        float theta = RandomUtil.getFloat((float)((float)Math.PI * 2));
                        velocity.set(FloatMath.cos(theta) * sina, FloatMath.sin(theta) * sina, cosa);
                    }
                    return velocity.addLocal(0.0f, 0.0f, Outward.this.upwardBias).normalizeLocal();
                }
            };
        }
    }

    public static class Cone
    extends ShooterConfig {
        @Editable(mode="normalized")
        public Vector3f direction = new Vector3f(0.0f, 0.0f, 1.0f);
        @Editable(min=0.0, max=180.0, scale=0.017453292519943295)
        public float minimumAngle;
        @Editable(min=0.0, max=180.0, scale=0.017453292519943295)
        public float maximumAngle = 0.7853982f;

        public Shooter createShooter(BaseParticleSystem.Layer layer) {
            final Matrix4f matrix = new Matrix4f();
            matrix.setToRotation(Vector3f.UNIT_Z, this.direction);
            return new Shooter(){

                public Vector3f shoot(Particle particle) {
                    float cosa = FloatMath.random(FloatMath.cos(Cone.this.minimumAngle), FloatMath.cos(Cone.this.maximumAngle));
                    float sina = FloatMath.sqrt(1.0f - cosa * cosa);
                    float theta = RandomUtil.getFloat((float)((float)Math.PI * 2));
                    return matrix.transformVectorLocal(particle.getVelocity().set(FloatMath.cos(theta) * sina, FloatMath.sin(theta) * sina, cosa));
                }
            };
        }
    }
}

