/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.opengl.effect.config;

import com.samskivert.util.RandomUtil;
import com.threerings.editor.Editable;
import com.threerings.editor.EditorTypes;
import com.threerings.export.Exportable;
import com.threerings.math.FloatMath;
import com.threerings.math.Vector3f;
import com.threerings.opengl.camera.Camera;
import com.threerings.opengl.effect.BaseParticleSystem;
import com.threerings.opengl.effect.Particle;
import com.threerings.opengl.effect.Placer;
import com.threerings.util.DeepObject;

@EditorTypes(value={Point.class, Line.class, Box.class, Ring.class, Shell.class, Frustum.class})
public abstract class PlacerConfig
extends DeepObject
implements Exportable {
    public abstract Placer createPlacer(BaseParticleSystem.Layer var1);

    protected static abstract class SimplePlacer
    implements Placer {
        protected BaseParticleSystem.Layer _layer;

        public SimplePlacer(BaseParticleSystem.Layer layer) {
            this._layer = layer;
        }

        public void place(Particle particle) {
            this._layer.pointToLayer(this.place(particle.getPosition()), true);
        }

        protected abstract Vector3f place(Vector3f var1);
    }

    public static class Frustum
    extends PlacerConfig {
        @Editable(min=0.0, step=0.1)
        public float nearDistance = 10.0f;
        @Editable(min=0.0, step=0.1)
        public float farDistance = 20.0f;
        @Editable
        public boolean solid = true;

        public Placer createPlacer(final BaseParticleSystem.Layer layer) {
            return new Placer(){

                public void place(Particle particle) {
                    float exp = Frustum.this.solid ? 3.0f : 2.0f;
                    float distance = FloatMath.pow(FloatMath.random(FloatMath.pow(Frustum.this.nearDistance, exp), FloatMath.pow(Frustum.this.farDistance, exp)), 1.0f / exp);
                    Camera camera = layer.getCamera();
                    float scale = distance / camera.getNear();
                    float left = camera.getLeft() * scale;
                    float right = camera.getRight() * scale;
                    float bottom = camera.getBottom() * scale;
                    float top = camera.getTop() * scale;
                    Vector3f position = particle.getPosition();
                    if (Frustum.this.solid) {
                        position.set(FloatMath.random(left, right), FloatMath.random(bottom, top), -distance);
                    } else {
                        float width = right - left;
                        float height = top - bottom;
                        if (RandomUtil.getFloat((float)(width + height)) < width) {
                            position.set(FloatMath.random(left, right), RandomUtil.rand.nextBoolean() ? top : bottom, -distance);
                        } else {
                            position.set(RandomUtil.rand.nextBoolean() ? left : right, FloatMath.random(top, bottom), -distance);
                        }
                    }
                    layer.pointToLayer(camera.getWorldTransform().transformPointLocal(position), false);
                }
            };
        }
    }

    public static class Shell
    extends PlacerConfig {
        @Editable(min=0.0, step=0.01)
        public float innerRadius;
        @Editable(min=0.0, step=0.01)
        public float outerRadius = 1.0f;

        public Placer createPlacer(BaseParticleSystem.Layer layer) {
            return new SimplePlacer(layer){

                protected Vector3f place(Vector3f position) {
                    float radius = FloatMath.pow(FloatMath.random(Shell.this.innerRadius * Shell.this.innerRadius * Shell.this.innerRadius, Shell.this.outerRadius * Shell.this.outerRadius * Shell.this.outerRadius), 0.33333334f);
                    float sine = FloatMath.random(-1.0f, 1.0f);
                    float cose = FloatMath.sqrt(1.0f - sine * sine);
                    float angle = RandomUtil.getFloat((float)((float)Math.PI * 2));
                    return position.set(radius * FloatMath.cos(angle) * cose, radius * FloatMath.sin(angle) * cose, radius * sine);
                }
            };
        }
    }

    public static class Ring
    extends PlacerConfig {
        @Editable(min=0.0, step=0.01)
        public float innerRadius = 0.0f;
        @Editable(min=0.0, step=0.01)
        public float outerRadius = 1.0f;

        public Placer createPlacer(BaseParticleSystem.Layer layer) {
            return new SimplePlacer(layer){

                protected Vector3f place(Vector3f position) {
                    float radius = FloatMath.sqrt(FloatMath.random(Ring.this.innerRadius * Ring.this.innerRadius, Ring.this.outerRadius * Ring.this.outerRadius));
                    float angle = RandomUtil.getFloat((float)((float)Math.PI * 2));
                    return position.set(radius * FloatMath.cos(angle), radius * FloatMath.sin(angle), 0.0f);
                }
            };
        }
    }

    public static class Box
    extends PlacerConfig {
        @Editable(min=0.0, step=0.01)
        public float width = 1.0f;
        @Editable(min=0.0, step=0.01)
        public float length = 1.0f;
        @Editable(min=0.0, step=0.01)
        public float height = 1.0f;
        @Editable
        public boolean solid = true;

        public Placer createPlacer(BaseParticleSystem.Layer layer) {
            return new SimplePlacer(layer){

                protected Vector3f place(Vector3f position) {
                    if (Box.this.solid) {
                        return position.set(FloatMath.random(-0.5f, 0.5f) * Box.this.width, FloatMath.random(-0.5f, 0.5f) * Box.this.length, FloatMath.random(-0.5f, 0.5f) * Box.this.height);
                    }
                    float xy = Box.this.width * Box.this.length;
                    float xz = Box.this.width * Box.this.height;
                    float yz = Box.this.length * Box.this.height;
                    float rand = RandomUtil.getFloat((float)(xy + xz + yz));
                    if (rand < xy) {
                        return position.set(FloatMath.random(-0.5f, 0.5f) * Box.this.width, FloatMath.random(-0.5f, 0.5f) * Box.this.length, (RandomUtil.rand.nextBoolean() ? -0.5f : 0.5f) * Box.this.height);
                    }
                    if (rand < xy + xz) {
                        return position.set(FloatMath.random(-0.5f, 0.5f) * Box.this.width, (RandomUtil.rand.nextBoolean() ? -0.5f : 0.5f) * Box.this.length, FloatMath.random(-0.5f, 0.5f) * Box.this.height);
                    }
                    return position.set((RandomUtil.rand.nextBoolean() ? -0.5f : 0.5f) * Box.this.width, FloatMath.random(-0.5f, 0.5f) * Box.this.length, FloatMath.random(-0.5f, 0.5f) * Box.this.height);
                }
            };
        }
    }

    public static class Line
    extends PlacerConfig {
        @Editable(min=0.0, step=0.01)
        public float length = 1.0f;

        public Placer createPlacer(BaseParticleSystem.Layer layer) {
            return new SimplePlacer(layer){

                protected Vector3f place(Vector3f position) {
                    return position.set(FloatMath.random(-0.5f, 0.5f) * Line.this.length, 0.0f, 0.0f);
                }
            };
        }
    }

    public static class Point
    extends PlacerConfig {
        public Placer createPlacer(BaseParticleSystem.Layer layer) {
            return new SimplePlacer(layer){

                protected Vector3f place(Vector3f position) {
                    return position.set(0.0f, 0.0f, 0.0f);
                }
            };
        }
    }
}

