/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.opengl.effect;

import com.threerings.expr.Scope;
import com.threerings.expr.Scoped;
import com.threerings.math.Box;
import com.threerings.math.Quaternion;
import com.threerings.math.Transform3D;
import com.threerings.math.Vector3f;
import com.threerings.opengl.Log;
import com.threerings.opengl.compositor.Enqueueable;
import com.threerings.opengl.effect.AlphaMode;
import com.threerings.opengl.effect.BaseParticleSystem;
import com.threerings.opengl.effect.Particle;
import com.threerings.opengl.effect.config.BaseParticleSystemConfig;
import com.threerings.opengl.effect.config.MetaParticleSystemConfig;
import com.threerings.opengl.model.Model;
import com.threerings.opengl.renderer.state.ColorState;
import com.threerings.opengl.util.GlContext;

public class MetaParticleSystem
extends BaseParticleSystem {
    public MetaParticleSystem(GlContext ctx, Scope parentScope, MetaParticleSystemConfig config) {
        super(ctx, parentScope);
        this.setConfig(ctx, config);
    }

    protected BaseParticleSystem.Layer createLayer(BaseParticleSystemConfig.Layer config) {
        return new Layer(this._ctx, this, config);
    }

    public static class Layer
    extends BaseParticleSystem.Layer
    implements Enqueueable {
        protected Model[] _models;
        @Scoped
        protected Transform3D _viewTransform = new Transform3D(2);
        protected Quaternion _vrot = new Quaternion();
        protected Vector3f _view = new Vector3f();
        protected Vector3f _s = new Vector3f();
        protected Vector3f _t = new Vector3f();
        protected Vector3f _r = new Vector3f();

        public Layer(GlContext ctx, Scope parentScope, BaseParticleSystemConfig.Layer config) {
            super(ctx, parentScope);
            this.setConfig(config);
        }

        public void enqueue() {
            if (this._config.moveParticlesWithEmitter) {
                this._parentViewTransform.compose(this._config.transform, this._viewTransform);
            } else {
                this._viewTransform.set(this._ctx.getCompositor().getCamera().getViewTransform());
            }
            MetaParticleSystemConfig.Alignment alignment = ((MetaParticleSystemConfig.Layer)this._config).alignment;
            if (alignment != MetaParticleSystemConfig.Alignment.FIXED) {
                this._viewTransform.getRotation().invert(this._vrot);
                if (alignment == MetaParticleSystemConfig.Alignment.VELOCITY) {
                    this._vrot.transformUnitZ(this._view);
                }
            }
            for (int ii = 0; ii < this._living.value; ++ii) {
                Model model = this._models[ii];
                if (alignment == MetaParticleSystemConfig.Alignment.FIXED) continue;
                Particle particle = this._particles[ii];
                if (alignment == MetaParticleSystemConfig.Alignment.VELOCITY) {
                    Vector3f velocity = particle.getVelocity();
                    this._view.cross(velocity, this._t);
                    float length = this._t.length();
                    if (length > 1.0E-6f) {
                        this._t.multLocal(1.0f / length);
                        velocity.normalize(this._s);
                        this._s.cross(this._t, this._r);
                        this._vrot.fromAxes(this._s, this._t, this._r);
                    } else {
                        this._vrot.set(Quaternion.IDENTITY);
                    }
                }
                this._vrot.mult(particle.getOrientation(), model.getLocalTransform().getRotation());
            }
        }

        public void setConfig(BaseParticleSystemConfig.Layer config) {
            int ii;
            super.setConfig(config);
            Model[] omodels = this._models;
            this._models = new Model[config.particleCount];
            MetaParticleSystemConfig.Layer mconfig = (MetaParticleSystemConfig.Layer)config;
            this._geometryRadius = 0.0f;
            for (ii = 0; ii < this._models.length; ++ii) {
                Model model;
                Model model2 = model = omodels == null || ii >= omodels.length ? null : omodels[ii];
                if (model == null) {
                    model = new Model(this._ctx);
                    model.setParentScope(this);
                    model.setColorState(new ColorState());
                }
                model.setRenderScheme(config.alphaMode == AlphaMode.OPAQUE ? null : "Translucent");
                model.setConfig(mconfig.model);
                if (this._geometryRadius == 0.0f) {
                    model.setLocalTransform(new Transform3D());
                    Box bounds = model.getBounds();
                    if (!bounds.isEmpty()) {
                        float length = bounds.getDiagonalLength();
                        if (Float.isNaN(length)) {
                            Log.log.warning((Object)"Diagonal length is not-a-number.", new Object[]{"model", mconfig.model, "bounds", bounds});
                        } else {
                            this._geometryRadius = length * 0.5f;
                        }
                    }
                }
                this._models[ii] = model;
            }
            if (omodels != null) {
                for (ii = this._models.length; ii < omodels.length; ++ii) {
                    omodels[ii].dispose();
                }
            }
        }

        public boolean tick(float elapsed) {
            if (super.tick(elapsed)) {
                return true;
            }
            for (int ii = 0; ii < this._living.value; ++ii) {
                Particle particle = this._particles[ii];
                Model model = this._models[ii];
                model.getLocalTransform().set(particle.getPosition(), particle.getOrientation(), particle.getSize());
                model.getColorState().getColor().set(particle.getColor());
                model.tick(elapsed);
                this._parentBounds.addLocal(model.getBounds());
            }
            return false;
        }

        public void composite() {
            if (!this._config.visible || this._living.value == 0) {
                return;
            }
            this._ctx.getCompositor().addEnqueueable(this);
            for (int ii = 0; ii < this._living.value; ++ii) {
                this._models[ii].composite();
            }
        }

        public void dispose() {
            super.dispose();
            for (Model model : this._models) {
                model.dispose();
            }
        }

        protected void swapParticles(int idx0, int idx1) {
            super.swapParticles(idx0, idx1);
            Model tmp = this._models[idx0];
            this._models[idx0] = this._models[idx1];
            this._models[idx1] = tmp;
        }

        protected void initParticle(int idx) {
            super.initParticle(idx);
            this._models[idx].reset();
        }
    }
}

