/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.opengl.effect;

import com.threerings.editor.Editable;
import com.threerings.editor.EditorTypes;
import com.threerings.export.Exportable;
import com.threerings.math.FloatMath;
import com.threerings.opengl.effect.Easing;
import com.threerings.util.DeepObject;

@EditorTypes(value={Constant.class, Linear.class, InAndOut.class, ThreePoint.class, Multipoint.class})
public abstract class FloatFunction
extends DeepObject
implements Exportable {
    public abstract float getValue(float var1);

    public abstract FloatFunction copy(FloatFunction var1);

    public static class Multipoint
    extends FloatFunction {
        @Editable(min=-Infinity, max=-Infinity, step=-Infinity, scale=-Infinity)
        public float start;
        @Editable(min=-Infinity, max=-Infinity, step=-Infinity, scale=-Infinity)
        public Point[] middle = new Point[0];
        @Editable(min=-Infinity, max=-Infinity, step=-Infinity, scale=-Infinity)
        public float end;

        public Multipoint(FloatFunction function) {
            this.start = function.getValue(0.0f);
            this.end = function.getValue(1.0f);
        }

        public Multipoint(InAndOut function) {
            this.start = function.start;
            this.middle = new Point[]{new Point(function.end, function.in), new Point(function.end, 1.0f - function.in - function.out)};
            this.end = function.start;
        }

        public Multipoint(ThreePoint function) {
            this.start = function.start;
            this.middle = new Point[]{new Point(function.middle, function.in), new Point(function.middle, 1.0f - function.in - function.out)};
            this.end = function.end;
        }

        public Multipoint() {
        }

        public float getValue(float t) {
            float last = this.start;
            float remaining = 1.0f;
            for (Point point : this.middle) {
                if (t < point.offset) {
                    return FloatMath.lerp(last, point.value, t / point.offset);
                }
                t -= point.offset;
                remaining -= point.offset;
                last = point.value;
            }
            return FloatMath.lerp(last, this.end, t / remaining);
        }

        public FloatFunction copy(FloatFunction result) {
            Multipoint mresult = result instanceof Multipoint ? (Multipoint)result : new Multipoint();
            mresult.start = this.start;
            if (mresult.middle.length != this.middle.length) {
                Point[] oarray = mresult.middle;
                mresult.middle = new Point[this.middle.length];
                int len = Math.min(oarray.length, this.middle.length);
                System.arraycopy(oarray, 0, mresult.middle, 0, len);
                for (int ii = len; ii < this.middle.length; ++ii) {
                    mresult.middle[ii] = new Point();
                }
            }
            for (int ii = 0; ii < this.middle.length; ++ii) {
                mresult.middle[ii].set(this.middle[ii]);
            }
            mresult.end = this.end;
            return mresult;
        }

        public static class Point
        extends DeepObject
        implements Exportable {
            @Editable(min=-Infinity, max=-Infinity, step=-Infinity, scale=-Infinity)
            public float value;
            @Editable(min=0.0, max=1.0, step=0.01)
            public float offset = 0.25f;

            public Point(float value, float offset) {
                this.value = value;
                this.offset = offset;
            }

            public Point() {
            }

            public void set(Point other) {
                this.value = other.value;
                this.offset = other.offset;
            }
        }
    }

    public static class ThreePoint
    extends FloatFunction {
        @Editable(min=-Infinity, max=-Infinity, step=-Infinity, scale=-Infinity)
        public float start;
        @Editable(min=-Infinity, max=-Infinity, step=-Infinity, scale=-Infinity)
        public float middle;
        @Editable(min=-Infinity, max=-Infinity, step=-Infinity, scale=-Infinity)
        public float end;
        @Editable(min=0.0, max=1.0, step=0.01)
        public float in = 0.25f;
        @Editable(min=0.0, max=1.0, step=0.01)
        public float out = 0.25f;

        public ThreePoint(FloatFunction function) {
            this.start = function.getValue(0.0f);
            this.middle = function.getValue(0.5f);
            this.end = function.getValue(1.0f);
        }

        public ThreePoint(InAndOut function) {
            this.start = function.start;
            this.middle = function.end;
            this.end = function.start;
            this.in = function.in;
            this.out = function.out;
        }

        public ThreePoint() {
        }

        public float getValue(float t) {
            if (t < this.in) {
                return FloatMath.lerp(this.start, this.middle, t / this.in);
            }
            if (t <= 1.0f - this.out) {
                return this.middle;
            }
            return FloatMath.lerp(this.end, this.middle, (1.0f - t) / this.out);
        }

        public FloatFunction copy(FloatFunction result) {
            ThreePoint tresult = result instanceof ThreePoint ? (ThreePoint)result : new ThreePoint();
            tresult.start = this.start;
            tresult.middle = this.middle;
            tresult.end = this.end;
            tresult.in = this.in;
            tresult.out = this.out;
            return tresult;
        }
    }

    public static class InAndOut
    extends FloatFunction {
        @Editable(min=-Infinity, max=-Infinity, step=-Infinity, scale=-Infinity)
        public float start;
        @Editable(min=-Infinity, max=-Infinity, step=-Infinity, scale=-Infinity)
        public float end;
        @Editable(min=0.0, max=1.0, step=0.01)
        public float in = 0.25f;
        @Editable(min=0.0, max=1.0, step=0.01)
        public float out = 0.25f;

        public InAndOut(FloatFunction function) {
            this.start = function.getValue(0.0f);
            this.end = function.getValue(1.0f);
        }

        public InAndOut(ThreePoint function) {
            this.start = function.start;
            this.end = function.middle;
            this.in = function.in;
            this.out = function.out;
        }

        public InAndOut() {
        }

        public float getValue(float t) {
            if (t < this.in) {
                return FloatMath.lerp(this.start, this.end, t / this.in);
            }
            if (t <= 1.0f - this.out) {
                return this.end;
            }
            return FloatMath.lerp(this.start, this.end, (1.0f - t) / this.out);
        }

        public FloatFunction copy(FloatFunction result) {
            InAndOut iresult = result instanceof InAndOut ? (InAndOut)result : new InAndOut();
            iresult.start = this.start;
            iresult.end = this.end;
            iresult.in = this.in;
            iresult.out = this.out;
            return iresult;
        }
    }

    public static class Linear
    extends FloatFunction {
        @Editable(min=-Infinity, max=-Infinity, step=-Infinity, scale=-Infinity)
        public float start;
        @Editable(min=-Infinity, max=-Infinity, step=-Infinity, scale=-Infinity)
        public float end;
        @Editable
        public Easing easing = new Easing.None();

        public Linear(float start, float end) {
            this.start = start;
            this.end = end;
        }

        public Linear(FloatFunction function) {
            this.start = this.end = function.getValue(0.5f);
        }

        public Linear() {
        }

        public float getValue(float t) {
            return this.start + this.easing.getTime(t) * (this.end - this.start);
        }

        public FloatFunction copy(FloatFunction result) {
            Linear lresult = result instanceof Linear ? (Linear)result : new Linear();
            lresult.start = this.start;
            lresult.end = this.end;
            lresult.easing = this.easing.copy(lresult.easing);
            return lresult;
        }
    }

    public static class Constant
    extends FloatFunction {
        @Editable(min=-Infinity, max=-Infinity, step=-Infinity, scale=-Infinity)
        public float value;

        public Constant(float value) {
            this.value = value;
        }

        public Constant(FloatFunction function) {
            this.value = function.getValue(0.5f);
        }

        public Constant() {
        }

        public float getValue(float t) {
            return this.value;
        }

        public FloatFunction copy(FloatFunction result) {
            Constant cresult = result instanceof Constant ? (Constant)result : new Constant();
            cresult.value = this.value;
            return cresult;
        }
    }
}

