/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.opengl.compositor;

import com.threerings.math.Box;
import com.threerings.math.FloatMath;
import com.threerings.math.Frustum;
import com.threerings.math.Matrix3f;
import com.threerings.math.Plane;
import com.threerings.math.Quaternion;
import com.threerings.math.Transform3D;
import com.threerings.math.Vector3f;
import com.threerings.math.Vector4f;
import com.threerings.opengl.camera.Camera;
import com.threerings.opengl.compositor.Compositor;
import com.threerings.opengl.compositor.config.RenderEffectConfig;
import com.threerings.opengl.renderer.Color4f;
import com.threerings.opengl.renderer.Light;
import com.threerings.opengl.renderer.Texture;
import com.threerings.opengl.renderer.TextureRenderer;
import com.threerings.opengl.renderer.config.TextureConfig;
import com.threerings.opengl.scene.config.ShadowConfig;
import com.threerings.opengl.util.GlContext;
import org.lwjgl.opengl.PixelFormat;

public abstract class Dependency {
    protected GlContext _ctx;
    protected static final Quaternion[] CUBE_FACE_ROTATIONS = new Quaternion[]{new Quaternion().fromAnglesXY((float)Math.PI, 1.5707964f), new Quaternion().fromAnglesXY((float)Math.PI, -1.5707964f), new Quaternion().fromAnglesXY(1.5707964f, 0.0f), new Quaternion().fromAnglesXY(-1.5707964f, 0.0f), new Quaternion().fromAnglesXY((float)Math.PI, 0.0f), new Quaternion().fromAnglesXZ(0.0f, (float)Math.PI)};

    public Dependency(GlContext ctx) {
        this._ctx = ctx;
    }

    public void merge(Dependency dependency) {
    }

    public void resolve() {
    }

    public void cleanup() {
    }

    public static class RenderEffect
    extends Dependency {
        public RenderEffectConfig config;

        public RenderEffect(GlContext ctx) {
            super(ctx);
        }

        public void resolve() {
            this._ctx.getCompositor().addDependencyEffect(this.config);
        }

        public int hashCode() {
            return System.identityHashCode(this.config);
        }

        public boolean equals(Object other) {
            return other instanceof RenderEffect && ((RenderEffect)other).config == this.config;
        }
    }

    public static class ShadowTexture
    extends Shadows {
        public Texture color;
        public TextureConfig colorConfig;
        public Texture depth;
        public TextureConfig depthConfig;

        public ShadowTexture(GlContext ctx) {
            super(ctx);
        }

        public void merge(Dependency dependency) {
            ShadowTexture odep = (ShadowTexture)dependency;
            this.color = odep.color;
            this.colorConfig = odep.colorConfig;
            this.depth = odep.depth;
            this.depthConfig = odep.depthConfig;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void resolve() {
            super.resolve();
            ShadowConfig.TextureData data = (ShadowConfig.TextureData)this.data;
            Compositor compositor = this._ctx.getCompositor();
            Camera ocamera = compositor.getCamera();
            Color4f obackground = compositor.getBackgroundColor();
            compositor.setBackgroundColor(Color4f.TRANSPARENT_BLACK);
            Compositor.State cstate = compositor.prepareSubrender();
            Camera ncamera = compositor.getCamera();
            Transform3D transform = ncamera.getWorldTransform();
            Light.Type lightType = data.light.getType();
            Vector4f pos = data.light.position;
            TextureRenderer renderer = TextureRenderer.getInstance(this._ctx, this.color, this.depth, new PixelFormat(8, 16, 8));
            if (lightType == Light.Type.POINT) {
                ncamera.setFrustum(-data.near, data.near, -data.near, data.near, data.near, data.far);
                transform.getTranslation().set(pos.x, pos.y, pos.z);
                data.transform.set(transform.getTranslation(), Quaternion.IDENTITY);
                try {
                    for (int ii = 0; ii < 6; ++ii) {
                        transform.getRotation().set(CUBE_FACE_ROTATIONS[ii]);
                        ncamera.updateTransform();
                        renderer.startRender(0, ii);
                        try {
                            compositor.performSubrender(this);
                            continue;
                        }
                        finally {
                            renderer.commitRender();
                        }
                    }
                }
                finally {
                    compositor.cleanupSubrender(cstate);
                    compositor.setBackgroundColor(obackground);
                }
                return;
            }
            if (lightType == Light.Type.DIRECTIONAL) {
                Frustum volume = ncamera.getWorldVolume();
                if (ocamera.isOrtho()) {
                    volume.setToOrtho(ocamera.getLeft(), ocamera.getRight(), ocamera.getBottom(), ocamera.getTop(), data.near, data.far);
                } else {
                    float ns = data.near / ocamera.getNear();
                    volume.setToFrustum(ns * ocamera.getLeft(), ns * ocamera.getRight(), ns * ocamera.getBottom(), ns * ocamera.getTop(), data.near, data.far);
                }
                volume.transformLocal(ocamera.getWorldTransform());
                Quaternion trot = transform.getRotation();
                trot.fromVectorFromNegativeZ(-pos.x, -pos.y, -pos.z);
                Matrix3f mat = new Matrix3f().setToRotation(trot).transposeLocal();
                Box box = volume.getBoundsUnderRotation(mat, new Box());
                Vector3f min = box.getMinimumExtent();
                Vector3f max = box.getMaximumExtent();
                data.width = max.x - min.x;
                data.height = max.y - min.y;
                data.depth = max.z - min.z;
                float hwidth = data.width * 0.5f;
                float hheight = data.height * 0.5f;
                ncamera.setOrtho(-hwidth, hwidth, -hheight, hheight, 0.0f, data.depth);
                trot.transformLocal(transform.getTranslation().set(min.x + hwidth, min.y + hheight, max.z));
            } else {
                ncamera.setPerspective(FloatMath.toRadians(data.light.spotCutoff) * 2.0f, 1.0f, data.near, data.far);
                transform.getTranslation().set(pos.x, pos.y, pos.z);
                transform.getRotation().fromVectorFromNegativeZ(data.light.spotDirection);
            }
            data.transform.set(transform);
            ncamera.updateTransform();
            renderer.startRender();
            try {
                compositor.performSubrender(this);
            }
            finally {
                renderer.commitRender();
                compositor.cleanupSubrender(cstate);
                compositor.setBackgroundColor(obackground);
            }
        }

        public void cleanup() {
            if (this.colorConfig != null) {
                this.colorConfig.returnToPool(this._ctx, this.color);
            }
            if (this.depthConfig != null) {
                this.depthConfig.returnToPool(this._ctx, this.depth);
            }
        }
    }

    public static class ShadowVolumes
    extends Shadows {
        public ShadowVolumes(GlContext ctx) {
            super(ctx);
        }
    }

    public static abstract class Shadows
    extends Dependency {
        public ShadowConfig.Data data;

        public Shadows(GlContext ctx) {
            super(ctx);
        }

        public void resolve() {
            this.data.updater.update();
        }

        public int hashCode() {
            return this.data.hashCode();
        }

        public boolean equals(Object other) {
            return this.getClass() == other.getClass() && ((Shadows)other).data.equals(this.data);
        }
    }

    public static class CubeTexture
    extends Dependency {
        public Vector3f origin = new Vector3f();
        public float near;
        public float far;
        public Texture texture;
        public int faces;
        public TextureConfig config;

        public CubeTexture(GlContext ctx) {
            super(ctx);
        }

        public void merge(Dependency dependency) {
            CubeTexture odep = (CubeTexture)dependency;
            this.texture = odep.texture;
            this.config = odep.config;
            this.near = Math.min(this.near, odep.near);
            this.far = Math.max(this.far, odep.far);
            this.faces |= odep.faces;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void resolve() {
            Compositor compositor = this._ctx.getCompositor();
            Camera ocamera = compositor.getCamera();
            Compositor.State cstate = compositor.prepareSubrender();
            Camera ncamera = compositor.getCamera();
            ncamera.setFrustum(-this.near, this.near, -this.near, this.near, this.near, this.far);
            Quaternion rot = new Quaternion();
            ocamera.getWorldTransform().extractRotation(rot);
            ncamera.getWorldTransform().set(this.origin, rot, 1.0f);
            TextureRenderer renderer = TextureRenderer.getInstance(this._ctx, this.texture, null, new PixelFormat(8, 16, 8));
            try {
                for (int ii = 0; ii < 6; ++ii) {
                    if ((this.faces & 1 << ii) == 0) continue;
                    rot.mult(CUBE_FACE_ROTATIONS[ii], ncamera.getWorldTransform().getRotation());
                    ncamera.updateTransform();
                    renderer.startRender(0, ii);
                    try {
                        compositor.performSubrender(this);
                        continue;
                    }
                    finally {
                        renderer.commitRender();
                    }
                }
            }
            finally {
                compositor.cleanupSubrender(cstate);
            }
        }

        public void cleanup() {
            this.config.returnToPool(this._ctx, this.texture);
        }

        public int hashCode() {
            return this.origin.hashCode();
        }

        public boolean equals(Object other) {
            return this.getClass() == other.getClass() && ((CubeTexture)other).origin.equals(this.origin);
        }
    }

    public static class RefractionTexture
    extends PlanarTexture {
        public float ratio = 1.0f;
        protected Vector3f _v0 = new Vector3f();
        protected Vector3f _v1 = new Vector3f();

        public RefractionTexture(GlContext ctx) {
            super(ctx);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void resolve() {
            Compositor compositor = this._ctx.getCompositor();
            Camera ocamera = compositor.getCamera();
            Compositor.State cstate = compositor.prepareSubrender();
            Camera ncamera = compositor.getCamera();
            Vector3f normal = this.eyePlane.getNormal();
            float near = this.eyePlane.constant / normal.z;
            float scale = ocamera.isOrtho() ? 1.0f : near / ocamera.getNear();
            ncamera.setProjection(ocamera.getLeft() * scale, ocamera.getRight() * scale, ocamera.getBottom() * scale, ocamera.getTop() * scale, near, near + ocamera.getFar() - ocamera.getNear(), normal, ocamera.isOrtho(), ocamera.isMirrored());
            FloatMath.refract(this._v0.set(0.0f, 0.0f, -1.0f), normal, this.ratio, this._v1);
            this._v1.multLocal(normal.dot(this._v1));
            Transform3D transform = ncamera.getWorldTransform();
            transform.setType(3);
            transform.getMatrix().setToSkew(this.eyePlane, this._v0.set(this._v1.x, this._v1.y, this._v1.z - normal.z));
            ocamera.getWorldTransform().compose(transform, transform);
            ncamera.updateTransform();
            TextureRenderer renderer = TextureRenderer.getInstance(this._ctx, this.texture, null, new PixelFormat(8, 16, 8));
            renderer.startRender();
            try {
                compositor.performSubrender(this);
            }
            finally {
                renderer.commitRender();
                compositor.cleanupSubrender(cstate);
            }
        }

        public boolean equals(Object other) {
            return super.equals(other) && ((RefractionTexture)other).ratio == this.ratio;
        }
    }

    public static class ReflectionTexture
    extends PlanarTexture {
        public ReflectionTexture(GlContext ctx) {
            super(ctx);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void resolve() {
            Compositor compositor = this._ctx.getCompositor();
            Camera ocamera = compositor.getCamera();
            Compositor.State cstate = compositor.prepareSubrender();
            Camera ncamera = compositor.getCamera();
            Vector3f normal = this.eyePlane.getNormal();
            float near = this.eyePlane.constant / normal.z;
            float scale = ocamera.isOrtho() ? 1.0f : near / ocamera.getNear();
            ncamera.setProjection(ocamera.getLeft() * scale, ocamera.getRight() * scale, ocamera.getBottom() * scale, ocamera.getTop() * scale, near, near + ocamera.getFar() - ocamera.getNear(), normal, ocamera.isOrtho(), !ocamera.isMirrored());
            Transform3D transform = ncamera.getWorldTransform();
            transform.setType(3);
            transform.getMatrix().setToReflection(this.eyePlane);
            ocamera.getWorldTransform().compose(transform, transform);
            ncamera.updateTransform();
            TextureRenderer renderer = TextureRenderer.getInstance(this._ctx, this.texture, null, new PixelFormat(8, 16, 8));
            renderer.startRender();
            try {
                compositor.performSubrender(this);
            }
            finally {
                renderer.commitRender();
                compositor.cleanupSubrender(cstate);
            }
        }
    }

    public static abstract class PlanarTexture
    extends Planar {
        public Texture texture;
        public TextureConfig config;

        public PlanarTexture(GlContext ctx) {
            super(ctx);
        }

        public void merge(Dependency dependency) {
            super.merge(dependency);
            PlanarTexture odep = (PlanarTexture)dependency;
            this.texture = odep.texture;
            this.config = odep.config;
        }

        public void cleanup() {
            this.config.returnToPool(this._ctx, this.texture);
        }
    }

    public static class StencilRefraction
    extends Planar {
        public float ratio = 1.0f;

        public StencilRefraction(GlContext ctx) {
            super(ctx);
        }

        public boolean equals(Object other) {
            return super.equals(other) && ((StencilRefraction)other).ratio == this.ratio;
        }
    }

    public static class StencilReflection
    extends Planar {
        public StencilReflection(GlContext ctx) {
            super(ctx);
        }
    }

    public static abstract class Planar
    extends Dependency {
        public Plane worldPlane = new Plane();
        public Plane eyePlane = new Plane();
        public Box bounds = new Box();

        public Planar(GlContext ctx) {
            super(ctx);
        }

        public void merge(Dependency dependency) {
            this.bounds.addLocal(((Planar)dependency).bounds);
        }

        public int hashCode() {
            return this.worldPlane.hashCode();
        }

        public boolean equals(Object other) {
            return this.getClass() == other.getClass() && ((Planar)other).worldPlane.equals(this.worldPlane);
        }
    }

    public static interface Adder {
        public boolean add();
    }
}

