/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.opengl.camera;

import com.threerings.opengl.camera.OrbitCameraHandler;
import com.threerings.opengl.gui.event.MouseMotionListener;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;

public class MouseOrbiter
implements java.awt.event.MouseMotionListener,
MouseWheelListener,
MouseMotionListener,
com.threerings.opengl.gui.event.MouseWheelListener {
    protected OrbitCameraHandler _camhand;
    protected float _radiansPerPixel = 0.0031415927f;
    protected float _unitsPerPixel = 0.02f;
    protected float _unitsPerClick = 0.3f;
    protected boolean _panXY;
    protected int _lx;
    protected int _ly;

    public MouseOrbiter(OrbitCameraHandler camhand) {
        this(camhand, false);
    }

    public MouseOrbiter(OrbitCameraHandler camhand, boolean panXY) {
        this._camhand = camhand;
        this._panXY = panXY;
    }

    public void addTo(Component comp) {
        comp.addMouseMotionListener(this);
        comp.addMouseWheelListener(this);
    }

    public void removeFrom(Component comp) {
        comp.removeMouseMotionListener(this);
        comp.removeMouseWheelListener(this);
    }

    public void mouseDragged(MouseEvent event) {
        int modex = event.getModifiersEx();
        this.mouseDragged(event.getX(), event.getY(), (modex & 0x400) != 0, (modex & 0x800) != 0, (modex & 0x1000) != 0);
    }

    public void mouseMoved(MouseEvent event) {
        this.mouseMoved(event.getX(), event.getY());
    }

    public void mouseWheelMoved(MouseWheelEvent event) {
        this.mouseWheelMoved(event.getWheelRotation());
    }

    public void mouseMoved(com.threerings.opengl.gui.event.MouseEvent event) {
        this.mouseMoved(event.getX(), -event.getY());
    }

    public void mouseDragged(com.threerings.opengl.gui.event.MouseEvent event) {
        int mods = event.getModifiers();
        this.mouseDragged(event.getX(), -event.getY(), (mods & 1) != 0, (mods & 4) != 0, (mods & 2) != 0);
    }

    public void mouseWheeled(com.threerings.opengl.gui.event.MouseEvent event) {
        this.mouseWheelMoved(-event.getDelta());
    }

    protected void mouseDragged(int x, int y, boolean b1, boolean b2, boolean b3) {
        int dx = x - this._lx;
        int dy = y - this._ly;
        if (b1) {
            this._camhand.orbit((float)(-dx) * this._radiansPerPixel, (float)dy * this._radiansPerPixel);
        }
        if (b2) {
            this._camhand.zoom((float)dy * this._unitsPerPixel);
        }
        if (b3) {
            if (this._panXY) {
                this._camhand.panXY((float)(-dx) * this._unitsPerPixel, (float)dy * this._unitsPerPixel);
            } else {
                this._camhand.pan((float)(-dx) * this._unitsPerPixel, (float)dy * this._unitsPerPixel);
            }
        }
        if (this._camhand.isAdded()) {
            this._camhand.updatePosition();
        }
        this.mouseMoved(x, y);
    }

    protected void mouseMoved(int x, int y) {
        this._lx = x;
        this._ly = y;
    }

    protected void mouseWheelMoved(int delta) {
        this._camhand.zoom((float)delta * this._unitsPerClick);
        if (this._camhand.isAdded()) {
            this._camhand.updatePosition();
        }
    }
}

