/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.opengl;

import com.samskivert.swing.util.SwingUtil;
import com.samskivert.util.RunAnywhere;
import com.samskivert.util.RunQueue;
import com.threerings.math.Ray3D;
import com.threerings.opengl.AWTCanvas;
import com.threerings.opengl.DisplayCanvas;
import com.threerings.opengl.GlApp;
import com.threerings.opengl.GlCanvas;
import com.threerings.opengl.Log;
import com.threerings.opengl.gui.CanvasRoot;
import com.threerings.opengl.gui.Root;
import com.threerings.opengl.util.GlContext;
import com.threerings.util.KeyTranslator;
import com.threerings.util.KeyTranslatorImpl;
import com.threerings.util.KeyboardManager;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.text.JTextComponent;
import org.lwjgl.LWJGLException;
import org.lwjgl.opengl.PixelFormat;

public abstract class GlCanvasApp
extends GlApp {
    protected JFrame _frame = new JFrame();
    protected Component _canvas;
    protected Root _canvasRoot;
    protected KeyboardManager _keymgr;

    public GlCanvasApp() {
        this._frame.setSize(1024, 768);
        SwingUtil.centerWindow((Window)this._frame);
        this._frame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent event) {
                GlCanvasApp.this.shutdown();
            }
        });
        this._canvas = this.createCanvas();
        if (this._canvas == null) {
            return;
        }
        JComponent cont = this.createCanvasContainer();
        this._frame.add((Component)cont, "Center");
        this._keymgr = new KeyboardManager();
        this._keymgr.setTarget(cont, (KeyTranslator)new KeyTranslatorImpl());
        PropertyChangeListener pcl = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                GlCanvasApp.this._keymgr.setEnabled(!(event.getNewValue() instanceof JTextComponent));
            }
        };
        KeyboardFocusManager.getCurrentKeyboardFocusManager().addPropertyChangeListener("focusOwner", pcl);
    }

    public JFrame getFrame() {
        return this._frame;
    }

    public Component getCanvas() {
        return this._canvas;
    }

    public boolean getMouseRay(Ray3D result) {
        Point pt = this._canvas.getMousePosition();
        if (pt == null) {
            return false;
        }
        this.getPickRay(pt.x, pt.y, result);
        return true;
    }

    public void getPickRay(int x, int y, Ray3D result) {
        this._compositor.getCamera().getPickRay(x, this._canvas.getHeight() - y - 1, result);
    }

    public void makeCurrent() {
        ((GlCanvas)((Object)this._canvas)).makeCurrent();
    }

    public RunQueue getRunQueue() {
        return RunQueue.AWT;
    }

    public Root createRoot() {
        if (this._canvasRoot == null) {
            this._canvasRoot = new CanvasRoot((GlContext)this, this._canvas);
        }
        return this._canvasRoot;
    }

    public void startup() {
        this._frame.setVisible(true);
    }

    public void shutdown() {
        this.willShutdown();
        ((GlCanvas)((Object)this._canvas)).shutdown();
        System.exit(0);
    }

    protected void initRenderer() {
        this._renderer.init(((GlCanvas)((Object)this._canvas)).getDrawable(), this._canvas.getWidth(), this._canvas.getHeight());
    }

    protected void didInit() {
        ((GlCanvas)((Object)this._canvas)).setVSyncEnabled(!Boolean.getBoolean("no_vsync"));
        this._canvas.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent event) {
                GlCanvasApp.this._renderer.setSize(GlCanvasApp.this._canvas.getWidth(), GlCanvasApp.this._canvas.getHeight());
            }
        });
        this._canvas.requestFocusInWindow();
        this._keymgr.setEnabled(true);
    }

    protected void willShutdown() {
        if (this._canvasRoot != null) {
            this._canvasRoot.dispose();
            this._canvasRoot = null;
        }
        super.willShutdown();
    }

    protected Component createCanvas() {
        if (RunAnywhere.isLinux() || RunAnywhere.isWindows()) {
            return new DisplayCanvas(this.getAntialiasingLevel()){

                protected void didInit() {
                    GlCanvasApp.this.init();
                }

                protected void updateView() {
                    GlCanvasApp.this.updateView();
                }

                protected void renderView() {
                    GlCanvasApp.this.renderView();
                }
            };
        }
        for (PixelFormat format : this.getPixelFormats()) {
            try {
                return new AWTCanvas(format){

                    protected void didInit() {
                        GlCanvasApp.this.init();
                    }

                    protected void updateView() {
                        GlCanvasApp.this.updateView();
                    }

                    protected void renderView() {
                        GlCanvasApp.this.renderView();
                    }
                };
            }
            catch (LWJGLException e) {
            }
        }
        Log.log.warning((Object)"Couldn't find valid pixel format.", new Object[0]);
        return null;
    }

    protected JComponent createCanvasContainer() {
        JPanel panel = new JPanel(new BorderLayout());
        panel.add(this._canvas, "Center");
        return panel;
    }
}

