/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.math;

import com.samskivert.util.StringUtil;
import com.threerings.export.Encodable;
import com.threerings.io.Streamable;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.FloatBuffer;

public final class Vector4f
implements Encodable,
Streamable {
    public float x;
    public float y;
    public float z;
    public float w;

    public Vector4f(float x, float y, float z, float w) {
        this.set(x, y, z, w);
    }

    public Vector4f(float[] values) {
        this.set(values);
    }

    public Vector4f(FloatBuffer buf) {
        this.set(buf);
    }

    public Vector4f(Vector4f other) {
        this.set(other);
    }

    public Vector4f() {
    }

    public Vector4f set(Vector4f other) {
        return this.set(other.x, other.y, other.z, other.w);
    }

    public Vector4f set(float[] values) {
        return this.set(values[0], values[1], values[2], values[3]);
    }

    public Vector4f set(FloatBuffer buf) {
        return this.set(buf.get(), buf.get(), buf.get(), buf.get());
    }

    public Vector4f set(float x, float y, float z, float w) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.w = w;
        return this;
    }

    public FloatBuffer get(FloatBuffer buf) {
        return buf.put(this.x).put(this.y).put(this.z).put(this.w);
    }

    public boolean epsilonEquals(Vector4f other, float epsilon) {
        return Math.abs(this.x - other.x) < epsilon && Math.abs(this.y - other.y) < epsilon && Math.abs(this.z - other.z) < epsilon && Math.abs(this.w - other.w) < epsilon;
    }

    public String encodeToString() {
        return this.x + ", " + this.y + ", " + this.z + ", " + this.w;
    }

    public void decodeFromString(String string) throws Exception {
        this.set(StringUtil.parseFloatArray((String)string));
    }

    public void encodeToStream(DataOutputStream out) throws IOException {
        out.writeFloat(this.x);
        out.writeFloat(this.y);
        out.writeFloat(this.z);
        out.writeFloat(this.w);
    }

    public void decodeFromStream(DataInputStream in) throws IOException {
        this.set(in.readFloat(), in.readFloat(), in.readFloat(), in.readFloat());
    }

    public String toString() {
        return "[" + this.x + ", " + this.y + ", " + this.z + ", " + this.w + "]";
    }

    public int hashCode() {
        return Float.floatToIntBits(this.x) ^ Float.floatToIntBits(this.y) ^ Float.floatToIntBits(this.z) ^ Float.floatToIntBits(this.w);
    }

    public boolean equals(Object other) {
        if (!(other instanceof Vector4f)) {
            return false;
        }
        Vector4f ovec = (Vector4f)other;
        return this.x == ovec.x && this.y == ovec.y && this.z == ovec.z && this.w == ovec.w;
    }
}

