/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.math;

import com.samskivert.util.StringUtil;
import com.threerings.export.Encodable;
import com.threerings.io.Streamable;
import com.threerings.math.FloatMath;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.FloatBuffer;

public final class Vector3f
implements Encodable,
Streamable {
    public static final Vector3f UNIT_X = new Vector3f(1.0f, 0.0f, 0.0f);
    public static final Vector3f UNIT_Y = new Vector3f(0.0f, 1.0f, 0.0f);
    public static final Vector3f UNIT_Z = new Vector3f(0.0f, 0.0f, 1.0f);
    public static final Vector3f UNIT_XYZ = new Vector3f(1.0f, 1.0f, 1.0f);
    public static final Vector3f NORMAL_XYZ = UNIT_XYZ.normalize();
    public static final Vector3f ZERO = new Vector3f(0.0f, 0.0f, 0.0f);
    public static final Vector3f MIN_VALUE = new Vector3f(-3.4028235E38f, -3.4028235E38f, -3.4028235E38f);
    public static final Vector3f MAX_VALUE = new Vector3f(Float.MAX_VALUE, Float.MAX_VALUE, Float.MAX_VALUE);
    public float x;
    public float y;
    public float z;

    public Vector3f(float x, float y, float z) {
        this.set(x, y, z);
    }

    public Vector3f(float[] values) {
        this.set(values);
    }

    public Vector3f(Vector3f other) {
        this.set(other);
    }

    public Vector3f() {
    }

    public float dot(Vector3f other) {
        return this.x * other.x + this.y * other.y + this.z * other.z;
    }

    public Vector3f crossLocal(Vector3f other) {
        return this.cross(other, this);
    }

    public Vector3f cross(Vector3f other) {
        return this.cross(other, new Vector3f());
    }

    public Vector3f cross(Vector3f other, Vector3f result) {
        return result.set(this.y * other.z - this.z * other.y, this.z * other.x - this.x * other.z, this.x * other.y - this.y * other.x);
    }

    public float triple(Vector3f b, Vector3f c) {
        return this.x * (b.y * c.z - b.z * c.y) + this.y * (b.z * c.x - b.x * c.z) + this.z * (b.x * c.y - b.y * c.x);
    }

    public Vector3f negateLocal() {
        return this.negate(this);
    }

    public Vector3f negate() {
        return this.negate(new Vector3f());
    }

    public Vector3f negate(Vector3f result) {
        return result.set(-this.x, -this.y, -this.z);
    }

    public Vector3f normalizeLocal() {
        return this.normalize(this);
    }

    public Vector3f normalize() {
        return this.normalize(new Vector3f());
    }

    public Vector3f normalize(Vector3f result) {
        return this.mult(1.0f / this.length(), result);
    }

    public float angle(Vector3f other) {
        return FloatMath.acos(this.dot(other) / (this.length() * other.length()));
    }

    public float length() {
        return FloatMath.sqrt(this.lengthSquared());
    }

    public float lengthSquared() {
        return this.x * this.x + this.y * this.y + this.z * this.z;
    }

    public float distance(Vector3f other) {
        return FloatMath.sqrt(this.distanceSquared(other));
    }

    public float distanceSquared(Vector3f other) {
        float dx = this.x - other.x;
        float dy = this.y - other.y;
        float dz = this.z - other.z;
        return dx * dx + dy * dy + dz * dz;
    }

    public float manhattanDistance(Vector3f other) {
        return Math.abs(this.x - other.x) + Math.abs(this.y - other.y) + Math.abs(this.z - other.z);
    }

    public Vector3f multLocal(float v) {
        return this.mult(v, this);
    }

    public Vector3f mult(float v) {
        return this.mult(v, new Vector3f());
    }

    public Vector3f mult(float v, Vector3f result) {
        return result.set(this.x * v, this.y * v, this.z * v);
    }

    public Vector3f multLocal(Vector3f other) {
        return this.mult(other, this);
    }

    public Vector3f mult(Vector3f other) {
        return this.mult(other, new Vector3f());
    }

    public Vector3f mult(Vector3f other, Vector3f result) {
        return result.set(this.x * other.x, this.y * other.y, this.z * other.z);
    }

    public Vector3f addLocal(Vector3f other) {
        return this.add(other, this);
    }

    public Vector3f add(Vector3f other) {
        return this.add(other, new Vector3f());
    }

    public Vector3f add(Vector3f other, Vector3f result) {
        return this.add(other.x, other.y, other.z, result);
    }

    public Vector3f subtractLocal(Vector3f other) {
        return this.subtract(other, this);
    }

    public Vector3f subtract(Vector3f other) {
        return this.subtract(other, new Vector3f());
    }

    public Vector3f subtract(Vector3f other, Vector3f result) {
        return this.add(-other.x, -other.y, -other.z, result);
    }

    public Vector3f addLocal(float x, float y, float z) {
        return this.add(x, y, z, this);
    }

    public Vector3f add(float x, float y, float z) {
        return this.add(x, y, z, new Vector3f());
    }

    public Vector3f add(float x, float y, float z, Vector3f result) {
        return result.set(this.x + x, this.y + y, this.z + z);
    }

    public Vector3f addScaledLocal(Vector3f other, float v) {
        return this.addScaled(other, v, this);
    }

    public Vector3f addScaled(Vector3f other, float v) {
        return this.addScaled(other, v, new Vector3f());
    }

    public Vector3f addScaled(Vector3f other, float v, Vector3f result) {
        return result.set(this.x + other.x * v, this.y + other.y * v, this.z + other.z * v);
    }

    public Vector3f lerpLocal(Vector3f other, float t) {
        return this.lerp(other, t, this);
    }

    public Vector3f lerp(Vector3f other, float t) {
        return this.lerp(other, t, new Vector3f());
    }

    public Vector3f lerp(Vector3f other, float t, Vector3f result) {
        return result.set(this.x + t * (other.x - this.x), this.y + t * (other.y - this.y), this.z + t * (other.z - this.z));
    }

    public Vector3f set(Vector3f other) {
        return this.set(other.x, other.y, other.z);
    }

    public Vector3f set(float[] values) {
        return this.set(values[0], values[1], values[2]);
    }

    public Vector3f set(float x, float y, float z) {
        this.x = x;
        this.y = y;
        this.z = z;
        return this;
    }

    public float get(int idx) {
        switch (idx) {
            case 0: {
                return this.x;
            }
            case 1: {
                return this.y;
            }
            case 2: {
                return this.z;
            }
        }
        throw new IndexOutOfBoundsException(Integer.toString(idx));
    }

    public void get(float[] values) {
        values[0] = this.x;
        values[1] = this.y;
        values[2] = this.z;
    }

    public FloatBuffer get(FloatBuffer buf) {
        return buf.put(this.x).put(this.y).put(this.z);
    }

    public String encodeToString() {
        return this.x + ", " + this.y + ", " + this.z;
    }

    public void decodeFromString(String string) throws Exception {
        this.set(StringUtil.parseFloatArray((String)string));
    }

    public void encodeToStream(DataOutputStream out) throws IOException {
        out.writeFloat(this.x);
        out.writeFloat(this.y);
        out.writeFloat(this.z);
    }

    public void decodeFromStream(DataInputStream in) throws IOException {
        this.set(in.readFloat(), in.readFloat(), in.readFloat());
    }

    public String toString() {
        return "[" + this.x + ", " + this.y + ", " + this.z + "]";
    }

    public int hashCode() {
        return Float.floatToIntBits(this.x) ^ Float.floatToIntBits(this.y) ^ Float.floatToIntBits(this.z);
    }

    public boolean equals(Object other) {
        if (!(other instanceof Vector3f)) {
            return false;
        }
        Vector3f ovec = (Vector3f)other;
        return this.x == ovec.x && this.y == ovec.y && this.z == ovec.z;
    }
}

