/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.math;

import com.samskivert.util.StringUtil;
import com.threerings.editor.Editable;
import com.threerings.export.Encodable;
import com.threerings.io.Streamable;
import com.threerings.math.FloatMath;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class SphereCoords
implements Encodable,
Streamable {
    @Editable(min=-180.0, max=180.0, scale=0.017453292519943295, hgroup="c")
    public float azimuth;
    @Editable(min=-90.0, max=90.0, scale=0.017453292519943295, hgroup="c")
    public float elevation;
    @Editable(min=0.0, step=0.01, hgroup="c")
    public float distance;

    public SphereCoords(float azimuth, float elevation, float distance) {
        this.set(azimuth, elevation, distance);
    }

    public SphereCoords(float[] values) {
        this.set(values);
    }

    public SphereCoords(SphereCoords other) {
        this.set(other);
    }

    public SphereCoords() {
    }

    public SphereCoords lerpLocal(SphereCoords other, float t) {
        return this.lerp(other, t, this);
    }

    public SphereCoords lerp(SphereCoords other, float t) {
        return this.lerp(other, t, new SphereCoords());
    }

    public SphereCoords lerp(SphereCoords other, float t, SphereCoords result) {
        return result.set(FloatMath.lerpa(this.azimuth, other.azimuth, t), this.elevation + t * (other.elevation - this.elevation), this.distance + t * (other.distance - this.distance));
    }

    public SphereCoords set(SphereCoords other) {
        return this.set(other.azimuth, other.elevation, other.distance);
    }

    public SphereCoords set(float[] values) {
        return this.set(values[0], values[1], values[2]);
    }

    public SphereCoords set(float azimuth, float elevation, float distance) {
        this.azimuth = azimuth;
        this.elevation = elevation;
        this.distance = distance;
        return this;
    }

    public String encodeToString() {
        return this.azimuth + ", " + this.elevation + ", " + this.distance;
    }

    public void decodeFromString(String string) throws Exception {
        this.set(StringUtil.parseFloatArray((String)string));
    }

    public void encodeToStream(DataOutputStream out) throws IOException {
        out.writeFloat(this.azimuth);
        out.writeFloat(this.elevation);
        out.writeFloat(this.distance);
    }

    public void decodeFromStream(DataInputStream in) throws IOException {
        this.set(in.readFloat(), in.readFloat(), in.readFloat());
    }

    public String toString() {
        return "[" + this.azimuth + ", " + this.elevation + ", " + this.distance + "]";
    }

    public int hashCode() {
        return Float.floatToIntBits(this.azimuth) ^ Float.floatToIntBits(this.elevation) ^ Float.floatToIntBits(this.distance);
    }

    public boolean equals(Object other) {
        if (!(other instanceof SphereCoords)) {
            return false;
        }
        SphereCoords ocoords = (SphereCoords)other;
        return this.azimuth == ocoords.azimuth && this.elevation == ocoords.elevation && this.distance == ocoords.distance;
    }
}

