/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.math;

import com.threerings.export.Exportable;
import com.threerings.math.Matrix3f;
import com.threerings.math.Ray2D;
import com.threerings.math.Transform2D;
import com.threerings.math.Vector2f;

public final class Rect
implements Exportable {
    public static final Rect ZERO = new Rect(Vector2f.ZERO, Vector2f.ZERO);
    public static final Rect EMPTY = new Rect(Vector2f.MAX_VALUE, Vector2f.MIN_VALUE);
    public static final Rect MAX_VALUE = new Rect(Vector2f.MIN_VALUE, Vector2f.MAX_VALUE);
    protected Vector2f _minExtent = new Vector2f();
    protected Vector2f _maxExtent = new Vector2f();

    public Rect(Vector2f minExtent, Vector2f maxExtent) {
        this.set(minExtent, maxExtent);
    }

    public Rect(Rect other) {
        this.set(other);
    }

    public Rect() {
        this.setToEmpty();
    }

    public Vector2f getMinimumExtent() {
        return this._minExtent;
    }

    public Vector2f getMaximumExtent() {
        return this._maxExtent;
    }

    public Vector2f getCenter() {
        return this.getCenter(new Vector2f());
    }

    public Vector2f getCenter(Vector2f result) {
        return this._minExtent.add(this._maxExtent, result).multLocal(0.5f);
    }

    public float getLongestEdge() {
        return Math.max(this._maxExtent.x - this._minExtent.x, this._maxExtent.y - this._minExtent.y);
    }

    public float getShortestEdge() {
        return Math.min(this._maxExtent.x - this._minExtent.x, this._maxExtent.y - this._minExtent.y);
    }

    public float getWidth() {
        return this._maxExtent.x - this._minExtent.x;
    }

    public float getHeight() {
        return this._maxExtent.y - this._minExtent.y;
    }

    public boolean isEmpty() {
        return this._minExtent.x > this._maxExtent.x || this._minExtent.y > this._maxExtent.y;
    }

    public Rect fromPoints(Vector2f ... points) {
        this.setToEmpty();
        for (Vector2f point : points) {
            this.addLocal(point);
        }
        return this;
    }

    public Rect addLocal(Vector2f point) {
        return this.add(point, this);
    }

    public Rect add(Vector2f point) {
        return this.add(point, new Rect());
    }

    public Rect add(Vector2f point, Rect result) {
        result.getMinimumExtent().set(Math.min(this._minExtent.x, point.x), Math.min(this._minExtent.y, point.y));
        result.getMaximumExtent().set(Math.max(this._maxExtent.x, point.x), Math.max(this._maxExtent.y, point.y));
        return result;
    }

    public Rect addLocal(Rect other) {
        return this.add(other, this);
    }

    public Rect add(Rect other) {
        return this.add(other, new Rect());
    }

    public Rect add(Rect other, Rect result) {
        Vector2f omin = other.getMinimumExtent();
        Vector2f omax = other.getMaximumExtent();
        result.getMinimumExtent().set(Math.min(this._minExtent.x, omin.x), Math.min(this._minExtent.y, omin.y));
        result.getMaximumExtent().set(Math.max(this._maxExtent.x, omax.x), Math.max(this._maxExtent.y, omax.y));
        return result;
    }

    public Rect intersectLocal(Rect other) {
        return this.intersect(other, this);
    }

    public Rect intersect(Rect other) {
        return this.intersect(other, new Rect());
    }

    public Rect intersect(Rect other, Rect result) {
        Vector2f omin = other.getMinimumExtent();
        Vector2f omax = other.getMaximumExtent();
        result.getMinimumExtent().set(Math.max(this._minExtent.x, omin.x), Math.max(this._minExtent.y, omin.y));
        result.getMaximumExtent().set(Math.min(this._maxExtent.x, omax.x), Math.min(this._maxExtent.y, omax.y));
        return result;
    }

    public Rect transformLocal(Transform2D transform) {
        return this.transform(transform, this);
    }

    public Rect transform(Transform2D transform) {
        return this.transform(transform, new Rect());
    }

    public Rect transform(Transform2D transform, Rect result) {
        transform.update(3);
        Matrix3f matrix = transform.getMatrix();
        float minx = matrix.m00 * (matrix.m00 > 0.0f ? this._minExtent.x : this._maxExtent.x) + matrix.m10 * (matrix.m10 > 0.0f ? this._minExtent.y : this._maxExtent.y) + matrix.m20;
        float miny = matrix.m01 * (matrix.m01 > 0.0f ? this._minExtent.x : this._maxExtent.x) + matrix.m11 * (matrix.m11 > 0.0f ? this._minExtent.y : this._maxExtent.y) + matrix.m21;
        float maxx = matrix.m00 * (matrix.m00 < 0.0f ? this._minExtent.x : this._maxExtent.x) + matrix.m10 * (matrix.m10 < 0.0f ? this._minExtent.y : this._maxExtent.y) + matrix.m20;
        float maxy = matrix.m01 * (matrix.m01 < 0.0f ? this._minExtent.x : this._maxExtent.x) + matrix.m11 * (matrix.m11 < 0.0f ? this._minExtent.y : this._maxExtent.y) + matrix.m21;
        result.getMinimumExtent().set(minx, miny);
        result.getMaximumExtent().set(maxx, maxy);
        return result;
    }

    public Rect expandLocal(float x, float y) {
        return this.expand(x, y, this);
    }

    public Rect expand(float x, float y) {
        return this.expand(x, y, new Rect());
    }

    public Rect expand(float x, float y, Rect result) {
        result.getMinimumExtent().set(this._minExtent.x - x, this._minExtent.y - y);
        result.getMaximumExtent().set(this._maxExtent.x + x, this._maxExtent.y + y);
        return result;
    }

    public Rect setToEmpty() {
        return this.set(Vector2f.MAX_VALUE, Vector2f.MIN_VALUE);
    }

    public Rect set(Rect other) {
        return this.set(other.getMinimumExtent(), other.getMaximumExtent());
    }

    public Rect set(Vector2f minExtent, Vector2f maxExtent) {
        this._minExtent.set(minExtent);
        this._maxExtent.set(maxExtent);
        return this;
    }

    public Vector2f[] getPerimeterPath() {
        return new Vector2f[]{this.getVertex(0), this.getVertex(2), this.getVertex(3), this.getVertex(1), this.getVertex(0)};
    }

    public Vector2f getVertex(int code) {
        return this.getVertex(code, new Vector2f());
    }

    public Vector2f getVertex(int code, Vector2f result) {
        return result.set((code & 2) == 0 ? this._minExtent.x : this._maxExtent.x, (code & 1) == 0 ? this._minExtent.y : this._maxExtent.y);
    }

    public boolean contains(Vector2f point) {
        return this.contains(point.x, point.y);
    }

    public boolean contains(float x, float y) {
        return x >= this._minExtent.x && x <= this._maxExtent.x && y >= this._minExtent.y && y <= this._maxExtent.y;
    }

    public boolean contains(Rect other) {
        Vector2f omin = other._minExtent;
        Vector2f omax = other._maxExtent;
        return omin.x >= this._minExtent.x && omax.x <= this._maxExtent.x && omin.y >= this._minExtent.y && omax.y <= this._maxExtent.y;
    }

    public boolean intersects(Rect other) {
        return this._maxExtent.x >= other._minExtent.x && this._minExtent.x <= other._maxExtent.x && this._maxExtent.y >= other._minExtent.y && this._minExtent.y <= other._maxExtent.y;
    }

    public boolean intersects(Ray2D ray) {
        Vector2f dir = ray.getDirection();
        return Math.abs(dir.x) > 1.0E-6f && (this.intersectsX(ray, this._minExtent.x) || this.intersectsX(ray, this._maxExtent.x)) || Math.abs(dir.y) > 1.0E-6f && (this.intersectsY(ray, this._minExtent.y) || this.intersectsY(ray, this._maxExtent.y));
    }

    public boolean getIntersection(Ray2D ray, Vector2f result) {
        Vector2f origin = ray.getOrigin();
        if (this.contains(origin)) {
            result.set(origin);
            return true;
        }
        Vector2f dir = ray.getDirection();
        float t = Float.MAX_VALUE;
        if (Math.abs(dir.x) > 1.0E-6f) {
            t = Math.min(t, this.getIntersectionX(ray, this._minExtent.x));
            t = Math.min(t, this.getIntersectionX(ray, this._maxExtent.x));
        }
        if (Math.abs(dir.y) > 1.0E-6f) {
            t = Math.min(t, this.getIntersectionY(ray, this._minExtent.y));
            t = Math.min(t, this.getIntersectionY(ray, this._maxExtent.y));
        }
        if (t == Float.MAX_VALUE) {
            return false;
        }
        origin.addScaled(dir, t, result);
        return true;
    }

    public String toString() {
        return "[min=" + this._minExtent + ", max=" + this._maxExtent + "]";
    }

    public int hashCode() {
        return this._minExtent.hashCode() + 31 * this._maxExtent.hashCode();
    }

    public boolean equals(Object other) {
        if (!(other instanceof Rect)) {
            return false;
        }
        Rect orect = (Rect)other;
        return this._minExtent.equals(orect._minExtent) && this._maxExtent.equals(orect._maxExtent);
    }

    protected boolean intersectsX(Ray2D ray, float x) {
        Vector2f origin = ray.getOrigin();
        Vector2f dir = ray.getDirection();
        float t = (x - origin.x) / dir.x;
        if (t < 0.0f) {
            return false;
        }
        float iy = origin.y + t * dir.y;
        return iy >= this._minExtent.y && iy <= this._maxExtent.y;
    }

    protected boolean intersectsY(Ray2D ray, float y) {
        Vector2f origin = ray.getOrigin();
        Vector2f dir = ray.getDirection();
        float t = (y - origin.y) / dir.y;
        if (t < 0.0f) {
            return false;
        }
        float ix = origin.x + t * dir.x;
        return ix >= this._minExtent.x && ix <= this._maxExtent.x;
    }

    protected float getIntersectionX(Ray2D ray, float x) {
        Vector2f origin = ray.getOrigin();
        Vector2f dir = ray.getDirection();
        float t = (x - origin.x) / dir.x;
        if (t < 0.0f) {
            return Float.MAX_VALUE;
        }
        float iy = origin.y + t * dir.y;
        return iy >= this._minExtent.y && iy <= this._maxExtent.y ? t : Float.MAX_VALUE;
    }

    protected float getIntersectionY(Ray2D ray, float y) {
        Vector2f origin = ray.getOrigin();
        Vector2f dir = ray.getDirection();
        float t = (y - origin.y) / dir.y;
        if (t < 0.0f) {
            return Float.MAX_VALUE;
        }
        float ix = origin.x + t * dir.x;
        return ix >= this._minExtent.x && ix <= this._maxExtent.x ? t : Float.MAX_VALUE;
    }
}

