/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.expr;

import com.threerings.editor.Editable;
import com.threerings.editor.EditorTypes;
import com.threerings.expr.FloatExpression;
import com.threerings.expr.ObjectExpression;
import com.threerings.expr.Scope;
import com.threerings.expr.util.ScopeUtil;
import com.threerings.math.Vector3f;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@EditorTypes(value={Constant.class, Reference.class, Cartesian.class})
public abstract class Vector3fExpression
extends ObjectExpression<Vector3f> {

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Cartesian
    extends Vector3fExpression {
        @Editable
        public FloatExpression x = new FloatExpression.Constant();
        @Editable
        public FloatExpression y = new FloatExpression.Constant();
        @Editable
        public FloatExpression z = new FloatExpression.Constant();

        @Override
        public ObjectExpression.Evaluator<Vector3f> createEvaluator(Scope scope) {
            final FloatExpression.Evaluator xeval = this.x.createEvaluator(scope);
            final FloatExpression.Evaluator yeval = this.y.createEvaluator(scope);
            final FloatExpression.Evaluator zeval = this.z.createEvaluator(scope);
            return new ObjectExpression.Evaluator<Vector3f>(){
                protected Vector3f _result = new Vector3f();

                @Override
                public Vector3f evaluate() {
                    return this._result.set(xeval.evaluate(), yeval.evaluate(), zeval.evaluate());
                }
            };
        }

        @Override
        public void invalidate() {
            this.x.invalidate();
            this.y.invalidate();
            this.z.invalidate();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Reference
    extends Vector3fExpression {
        @Editable
        public String name = "";
        @Editable(step=0.01)
        public Vector3f defvalue = new Vector3f();

        @Override
        public ObjectExpression.Evaluator<Vector3f> createEvaluator(Scope scope) {
            final Vector3f value = ScopeUtil.resolve(scope, this.name, this.defvalue);
            return new ObjectExpression.Evaluator<Vector3f>(){

                @Override
                public Vector3f evaluate() {
                    return value;
                }
            };
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Constant
    extends Vector3fExpression {
        @Editable(step=0.01)
        public Vector3f value = new Vector3f();

        public Constant(Vector3f value) {
            this.value.set(value);
        }

        public Constant() {
        }

        @Override
        public ObjectExpression.Evaluator<Vector3f> createEvaluator(Scope scope) {
            return new ObjectExpression.Evaluator<Vector3f>(){

                @Override
                public Vector3f evaluate() {
                    return Constant.this.value;
                }
            };
        }
    }
}

