/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.expr;

import com.threerings.editor.Editable;
import com.threerings.editor.EditorTypes;
import com.threerings.expr.FloatExpression;
import com.threerings.expr.ObjectExpression;
import com.threerings.expr.Scope;
import com.threerings.expr.util.ScopeUtil;
import com.threerings.math.Vector2f;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@EditorTypes(value={Constant.class, Reference.class, Cartesian.class})
public abstract class Vector2fExpression
extends ObjectExpression<Vector2f> {

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Cartesian
    extends Vector2fExpression {
        @Editable
        public FloatExpression x = new FloatExpression.Constant();
        @Editable
        public FloatExpression y = new FloatExpression.Constant();

        @Override
        public ObjectExpression.Evaluator<Vector2f> createEvaluator(Scope scope) {
            final FloatExpression.Evaluator xeval = this.x.createEvaluator(scope);
            final FloatExpression.Evaluator yeval = this.y.createEvaluator(scope);
            return new ObjectExpression.Evaluator<Vector2f>(){
                protected Vector2f _result = new Vector2f();

                @Override
                public Vector2f evaluate() {
                    return this._result.set(xeval.evaluate(), yeval.evaluate());
                }
            };
        }

        @Override
        public void invalidate() {
            this.x.invalidate();
            this.y.invalidate();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Reference
    extends Vector2fExpression {
        @Editable
        public String name = "";
        @Editable(step=0.01)
        public Vector2f defvalue = new Vector2f();

        @Override
        public ObjectExpression.Evaluator<Vector2f> createEvaluator(Scope scope) {
            final Vector2f value = ScopeUtil.resolve(scope, this.name, this.defvalue);
            return new ObjectExpression.Evaluator<Vector2f>(){

                @Override
                public Vector2f evaluate() {
                    return value;
                }
            };
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Constant
    extends Vector2fExpression {
        @Editable(step=0.01)
        public Vector2f value = new Vector2f();

        public Constant(Vector2f value) {
            this.value.set(value);
        }

        public Constant() {
        }

        @Override
        public ObjectExpression.Evaluator<Vector2f> createEvaluator(Scope scope) {
            return new ObjectExpression.Evaluator<Vector2f>(){

                @Override
                public Vector2f evaluate() {
                    return Constant.this.value;
                }
            };
        }
    }
}

