/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.expr;

import com.threerings.editor.Editable;
import com.threerings.editor.EditorTypes;
import com.threerings.expr.FloatExpression;
import com.threerings.expr.ObjectExpression;
import com.threerings.expr.Scope;
import com.threerings.expr.util.ScopeUtil;
import com.threerings.opengl.renderer.Color4f;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@EditorTypes(value={Constant.class, Reference.class, Blend.class})
public abstract class Color4fExpression
extends ObjectExpression<Color4f> {

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Blend
    extends Color4fExpression {
        @Editable
        public Color4fExpression firstColor = new Constant();
        @Editable
        public Color4fExpression secondColor = new Constant();
        @Editable
        public FloatExpression blendFactor = new FloatExpression.Constant();

        @Override
        public ObjectExpression.Evaluator<Color4f> createEvaluator(Scope scope) {
            final ObjectExpression.Evaluator eval1 = this.firstColor.createEvaluator(scope);
            final ObjectExpression.Evaluator eval2 = this.secondColor.createEvaluator(scope);
            final FloatExpression.Evaluator beval = this.blendFactor.createEvaluator(scope);
            return new ObjectExpression.Evaluator<Color4f>(){
                protected Color4f _result = new Color4f();

                @Override
                public Color4f evaluate() {
                    return ((Color4f)eval1.evaluate()).lerp((Color4f)eval2.evaluate(), beval.evaluate(), this._result);
                }
            };
        }

        @Override
        public void invalidate() {
            this.firstColor.invalidate();
            this.secondColor.invalidate();
            this.blendFactor.invalidate();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Reference
    extends Color4fExpression {
        @Editable
        public String name = "";
        @Editable(mode="alpha")
        public Color4f defvalue = new Color4f();

        @Override
        public ObjectExpression.Evaluator<Color4f> createEvaluator(Scope scope) {
            final Color4f value = ScopeUtil.resolve(scope, this.name, this.defvalue);
            return new ObjectExpression.Evaluator<Color4f>(){

                @Override
                public Color4f evaluate() {
                    return value;
                }
            };
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Constant
    extends Color4fExpression {
        @Editable(mode="alpha")
        public Color4f value = new Color4f();

        @Override
        public ObjectExpression.Evaluator<Color4f> createEvaluator(Scope scope) {
            return new ObjectExpression.Evaluator<Color4f>(){

                @Override
                public Color4f evaluate() {
                    return Constant.this.value;
                }
            };
        }
    }
}

