/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.export.util;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class LazyFileOutputStream
extends OutputStream {
    protected File _file;
    protected FileOutputStream _out;

    public LazyFileOutputStream(File file) {
        this._file = file;
    }

    public LazyFileOutputStream(String file) {
        this._file = new File(file);
    }

    public void write(int b) throws IOException {
        this.ensureInitialized();
        this._out.write(b);
    }

    public void write(byte[] b) throws IOException {
        this.ensureInitialized();
        this._out.write(b);
    }

    public void write(byte[] b, int off, int len) throws IOException {
        this.ensureInitialized();
        this._out.write(b, off, len);
    }

    public void flush() throws IOException {
        if (this._out != null) {
            this._out.flush();
        }
    }

    public void close() throws IOException {
        if (this._out != null) {
            this._out.close();
        }
    }

    protected void ensureInitialized() throws IOException {
        if (this._out == null) {
            this._out = new FileOutputStream(this._file);
        }
    }
}

