/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.export.util;

import com.google.common.io.Closeables;
import com.threerings.export.BinaryImporter;
import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExportFileUtil {
    public static <T> T readObject(File file, Class<T> clazz) throws IOException {
        T t;
        BinaryImporter in = null;
        try {
            in = new BinaryImporter(new BufferedInputStream(new FileInputStream(file)));
            t = clazz.cast(in.readObject());
        }
        catch (ClassCastException cce) {
            try {
                String msg = "File " + file + " doesn't contain a " + clazz;
                throw (IOException)new IOException(msg).initCause(cce);
            }
            catch (Throwable throwable) {
                Closeables.closeQuietly(in);
                throw throwable;
            }
        }
        Closeables.closeQuietly((Closeable)in);
        return t;
    }
}

