/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.export.tools;

import com.google.common.collect.Lists;
import com.samskivert.util.ArrayUtil;
import com.threerings.export.BinaryExporter;
import com.threerings.export.BinaryImporter;
import com.threerings.export.Log;
import java.io.EOFException;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.tools.ant.DirectoryScanner;

public class BinaryToBinaryConverter {
    public static void main(String[] args) throws Exception {
        boolean compress = true;
        while (args.length > 0 && args[0].startsWith("-")) {
            String options = args[0];
            args = (String[])ArrayUtil.splice((Object[])args, (int)0, (int)1);
            int nn = options.length();
            block4: for (int ii = 1; ii < nn; ++ii) {
                char option = options.charAt(ii);
                switch (option) {
                    case 'u': {
                        compress = false;
                        continue block4;
                    }
                    default: {
                        System.err.println("Unrecognized option: -" + option);
                        System.exit(1);
                    }
                }
            }
        }
        if (args.length == 2) {
            BinaryToBinaryConverter.convert(args[0], args[1], compress);
        } else if (args.length == 1) {
            BinaryToBinaryConverter.convert(args[0], compress);
        } else {
            System.err.println("Usage: BinaryToBinaryConverter [-options] <binary input file> <binary output file>");
            System.err.println("   or  BinaryToBinaryConverter [-options] <binary input file pattern>");
            System.err.println();
            System.err.println("where options include:");
            System.err.println("    -u            do not compress output");
            return;
        }
    }

    public static void convert(String pattern, boolean compress) throws IOException {
        DirectoryScanner scanner = new DirectoryScanner();
        scanner.setBasedir(".");
        scanner.setIncludes(new String[]{pattern});
        scanner.scan();
        for (String source : scanner.getIncludedFiles()) {
            try {
                BinaryToBinaryConverter.convert(source, source, compress);
            }
            catch (IOException e) {
                Log.log.warning((Object)"Error converting file.", new Object[]{"file", source, e});
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void convert(String source, String dest, boolean compress) throws IOException {
        BinaryImporter in = new BinaryImporter(new FileInputStream(source));
        ArrayList objects = Lists.newArrayList();
        try {
            try {
                while (true) {
                    objects.add(in.readObject());
                }
            }
            catch (EOFException e) {
                Object var7_7 = null;
                in.close();
            }
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            in.close();
            throw throwable;
        }
        BinaryExporter out = new BinaryExporter(new FileOutputStream(dest), compress);
        try {
            int nn = objects.size();
            for (int ii = 0; ii < nn; ++ii) {
                out.writeObject(objects.get(ii));
            }
            Object var9_12 = null;
        }
        catch (Throwable throwable) {
            Object var9_13 = null;
            out.close();
            throw throwable;
        }
        out.close();
    }
}

