/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.export;

import com.samskivert.util.Tuple;
import com.threerings.export.Exportable;
import com.threerings.export.Exporter;
import com.threerings.export.Streamer;
import com.threerings.util.ReflectionUtil;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Array;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.zip.DeflaterOutputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BinaryExporter
extends Exporter {
    public static final int MAGIC_NUMBER = -87118066;
    public static final short VERSION = 4096;
    public static final short COMPRESSED_FORMAT_FLAG = 4096;
    public static final byte FINAL_CLASS_FLAG = 1;
    public static final byte INNER_CLASS_FLAG = 2;
    public static final byte COLLECTION_CLASS_FLAG = 4;
    public static final byte MAP_CLASS_FLAG = 8;
    public static final Class<?>[] BOOTSTRAP_CLASSES = new Class[]{Boolean.TYPE, Byte.TYPE, Character.TYPE, Double.TYPE, Float.TYPE, Integer.TYPE, Long.TYPE, Short.TYPE};
    protected OutputStream _base;
    protected DataOutputStream _out;
    protected boolean _compress;
    protected DeflaterOutputStream _defout;
    protected IdentityHashMap<Object, Integer> _objectIds;
    protected IDWriter _objectIdWriter = new IDWriter();
    protected int _lastObjectId;
    protected HashMap<Class<?>, Integer> _classIds = new HashMap();
    protected IDWriter _classIdWriter = new IDWriter();
    protected int _lastClassId;
    protected HashMap<String, Tuple<Object, Class<?>>> _fields;
    protected HashMap<Class<?>, ClassData> _classData = new HashMap();

    public BinaryExporter(OutputStream out) {
        this(out, true);
    }

    public BinaryExporter(OutputStream out, boolean compress) {
        this._base = out;
        this._out = new DataOutputStream(this._base);
        this._compress = compress;
        for (Class<?> clazz : BOOTSTRAP_CLASSES) {
            this._classIds.put(clazz, ++this._lastClassId);
        }
    }

    @Override
    public void writeObject(Object object) throws IOException {
        if (this._objectIds == null) {
            OutputStream outputStream;
            this._out.writeInt(-87118066);
            this._out.writeShort(4096);
            this._out.writeShort(this._compress ? 4096 : 0);
            if (this._compress) {
                this._defout = new DeflaterOutputStream(this._base);
                outputStream = this._defout;
            } else {
                outputStream = this._base;
            }
            this._out = new DataOutputStream(outputStream);
            this._objectIds = new IdentityHashMap();
            this._objectIds.put(null, 0);
        }
        this.write(object, Object.class);
    }

    @Override
    public void write(String name, boolean value) throws IOException {
        this._fields.put(name, new Tuple((Object)value, Boolean.TYPE));
    }

    @Override
    public void write(String name, byte value) throws IOException {
        this._fields.put(name, new Tuple((Object)value, Byte.TYPE));
    }

    @Override
    public void write(String name, char value) throws IOException {
        this._fields.put(name, new Tuple((Object)Character.valueOf(value), Character.TYPE));
    }

    @Override
    public void write(String name, double value) throws IOException {
        this._fields.put(name, new Tuple((Object)value, Double.TYPE));
    }

    @Override
    public void write(String name, float value) throws IOException {
        this._fields.put(name, new Tuple((Object)Float.valueOf(value), Float.TYPE));
    }

    @Override
    public void write(String name, int value) throws IOException {
        this._fields.put(name, new Tuple((Object)value, Integer.TYPE));
    }

    @Override
    public void write(String name, long value) throws IOException {
        this._fields.put(name, new Tuple((Object)value, Long.TYPE));
    }

    @Override
    public void write(String name, short value) throws IOException {
        this._fields.put(name, new Tuple((Object)value, Short.TYPE));
    }

    @Override
    public <T> void write(String name, T value, Class<T> clazz) throws IOException {
        this._fields.put(name, new Tuple(value, clazz));
    }

    @Override
    public void close() throws IOException {
        this._out.close();
    }

    @Override
    public void finish() throws IOException {
        if (this._defout != null) {
            this._defout.finish();
        }
    }

    protected void write(Object value, Class<?> clazz) throws IOException {
        if (clazz.isPrimitive()) {
            this.writeValue(value, clazz);
            return;
        }
        Integer objectId = this._objectIds.get(value);
        if (objectId != null) {
            this._objectIdWriter.write(objectId);
            return;
        }
        this._objectIdWriter.write(++this._lastObjectId);
        this._objectIds.put(value, this._lastObjectId);
        this.writeValue(value, clazz);
    }

    protected void writeValue(Object value, Class<?> clazz) throws IOException {
        Object outer;
        Streamer streamer;
        Class<?> cclazz = BinaryExporter.getClass(value);
        if (!Modifier.isFinal(clazz.getModifiers())) {
            this.writeClass(cclazz);
        }
        if ((streamer = Streamer.getStreamer(cclazz)) != null) {
            streamer.write(value, this._out);
            return;
        }
        if (cclazz.isArray()) {
            this._out.writeInt(Array.getLength(value));
        }
        if ((outer = ReflectionUtil.getOuter(value)) != null) {
            this.write(outer, Object.class);
        }
        if (value instanceof Exportable) {
            this.writeFields((Exportable)value);
        } else if (value instanceof Object[]) {
            Class<?> ctype = cclazz.getComponentType();
            this.writeEntries((Object[])value, ctype);
        } else if (value instanceof Collection) {
            this.writeEntries((Collection)value);
        } else if (value instanceof Map) {
            this.writeEntries((Map)value);
        } else {
            throw new IOException("Value is not exportable [class=" + cclazz + "].");
        }
    }

    protected void writeClass(Class<?> clazz) throws IOException {
        Integer classId = this._classIds.get(clazz);
        if (classId != null) {
            this._classIdWriter.write(classId);
            return;
        }
        this._classIdWriter.write(++this._lastClassId);
        this._classIds.put(clazz, this._lastClassId);
        this._out.writeUTF(clazz.getName());
        this._out.writeByte(BinaryExporter.getFlags(BinaryExporter.getInmostComponentType(clazz)));
    }

    @Override
    protected void writeFields(Exportable object) throws IOException {
        HashMap fields = new HashMap();
        this._fields = fields;
        super.writeFields(object);
        this._fields = null;
        Class<?> clazz = object.getClass();
        ClassData cdata = this._classData.get(clazz);
        if (cdata == null) {
            cdata = new ClassData();
            this._classData.put(clazz, cdata);
        }
        cdata.writeFields(fields);
    }

    protected <T> void writeEntries(T[] array, Class<T> ctype) throws IOException {
        for (T entry : array) {
            this.write(entry, ctype);
        }
    }

    protected void writeEntries(Collection collection) throws IOException {
        this._out.writeInt(collection.size());
        for (Object entry : collection) {
            this.write(entry, Object.class);
        }
    }

    protected void writeEntries(Map<?, ?> map) throws IOException {
        this._out.writeInt(map.size());
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            this.write(entry.getKey(), Object.class);
            this.write(entry.getValue(), Object.class);
        }
    }

    protected static Class<?> getInmostComponentType(Class<?> clazz) {
        while (clazz.isArray()) {
            clazz = clazz.getComponentType();
        }
        return clazz;
    }

    protected static byte getFlags(Class<?> clazz) {
        byte flags = 0;
        int mods = clazz.getModifiers();
        if (Modifier.isFinal(mods)) {
            flags = (byte)(flags | 1);
        }
        if (ReflectionUtil.isInner(clazz)) {
            flags = (byte)(flags | 2);
        }
        if (!Exportable.class.isAssignableFrom(clazz)) {
            if (Collection.class.isAssignableFrom(clazz)) {
                flags = (byte)(flags | 4);
            } else if (Map.class.isAssignableFrom(clazz)) {
                flags = (byte)(flags | 8);
            }
        }
        return flags;
    }

    protected class IDWriter {
        protected int _highest;

        protected IDWriter() {
        }

        public void write(int id) throws IOException {
            if (this._highest < 255) {
                BinaryExporter.this._out.writeByte(id);
            } else if (this._highest < 65535) {
                BinaryExporter.this._out.writeShort(id);
            } else {
                BinaryExporter.this._out.writeInt(id);
            }
            this._highest = Math.max(this._highest, id);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class ClassData {
        protected HashMap<Tuple<String, Class<?>>, Integer> _fieldIds = new HashMap();
        protected IDWriter _fieldIdWriter = new IDWriter();
        protected int _lastFieldId;

        protected ClassData() {
        }

        public void writeFields(HashMap<String, Tuple<Object, Class<?>>> fields) throws IOException {
            BinaryExporter.this._out.writeInt(fields.size());
            for (Map.Entry<String, Tuple<Object, Class<?>>> entry : fields.entrySet()) {
                Tuple<Object, Class<?>> value = entry.getValue();
                this.writeField(entry.getKey(), value.left, (Class)value.right);
            }
        }

        protected void writeField(String name, Object value, Class<?> clazz) throws IOException {
            Tuple field = new Tuple((Object)name, clazz);
            Integer fieldId = this._fieldIds.get(field);
            if (fieldId == null) {
                this._fieldIdWriter.write(++this._lastFieldId);
                this._fieldIds.put(field, this._lastFieldId);
                BinaryExporter.this.write((Object)name, String.class);
                BinaryExporter.this.writeClass(clazz);
            } else {
                this._fieldIdWriter.write(fieldId);
            }
            BinaryExporter.this.write(value, clazz);
        }
    }
}

