/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.editor.swing.editors;

import com.threerings.editor.swing.DraggableSpinner;
import com.threerings.editor.swing.PropertyEditor;
import com.threerings.opengl.renderer.Color4f;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.basic.BasicButtonUI;

public class Color4fEditor
extends PropertyEditor
implements ActionListener,
ChangeListener {
    protected JButton _button;
    protected JColorChooser _chooser;
    protected JDialog _dialog;
    protected DraggableSpinner _spinner;

    public void actionPerformed(ActionEvent event) {
        if (this._chooser == null) {
            this._chooser = new JColorChooser();
            this._chooser.getSelectionModel().addChangeListener(this);
            this._dialog = JColorChooser.createDialog((Component)((Object)this), this.getPropertyLabel(), false, this._chooser, null, null);
        }
        Color4f color = (Color4f)this._property.get(this._object);
        this._chooser.setColor(color.getColor(false));
        this._dialog.setVisible(true);
    }

    public void stateChanged(ChangeEvent event) {
        Color4f ncolor;
        Color awtColor;
        Color4f ocolor = (Color4f)this._property.get(this._object);
        if (event.getSource() == this._spinner) {
            awtColor = ocolor.getColor(false);
            ncolor = new Color4f(ocolor.r, ocolor.g, ocolor.b, ((Number)this._spinner.getValue()).floatValue());
        } else {
            awtColor = this._chooser.getColor();
            ncolor = new Color4f(awtColor);
            ncolor.a = ocolor.a;
        }
        if (!ocolor.equals(ncolor)) {
            this._property.set(this._object, ncolor);
            this._button.setBackground(awtColor);
            this.fireStateChanged();
        }
    }

    public void update() {
        Color4f color = (Color4f)this._property.get(this._object);
        Color awtColor = color.getColor(false);
        this._button.setBackground(awtColor);
        if (this._spinner != null) {
            this._spinner.setValue(Float.valueOf(color.a));
        }
        if (this._chooser != null && this._chooser.isShowing()) {
            this._chooser.setColor(awtColor);
        }
    }

    protected void didInit() {
        this.add(new JLabel(this.getPropertyLabel() + ":"));
        this._button = new JButton(){
            {
                this.setUI(BasicButtonUI.createUI(this));
            }
        };
        this.add(this._button);
        this._button.setPreferredSize(new Dimension(40, 20));
        this._button.addActionListener(this);
        if (this.getMode().equals("alpha")) {
            this._spinner = new DraggableSpinner(1.0f, 0.0f, 1.0f, 0.01f);
            this.add(this._spinner);
            this._spinner.addChangeListener(this);
        }
    }
}

