/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.editor.swing;

import com.samskivert.swing.GroupLayout;
import com.samskivert.swing.VGroupLayout;
import com.threerings.editor.swing.BasePropertyEditor;
import com.threerings.editor.swing.DraggableSpinner;
import com.threerings.math.FloatMath;
import com.threerings.math.Vector3f;
import com.threerings.util.MessageBundle;
import java.awt.LayoutManager;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class Vector3fPanel
extends BasePropertyEditor
implements ChangeListener {
    protected Mode _mode;
    protected float _scale;
    protected JSpinner[] _spinners;

    public Vector3fPanel(MessageBundle msgs, Mode mode, float step, float scale) {
        this._msgs = msgs;
        this._mode = mode;
        this._scale = scale;
        this.setLayout((LayoutManager)new VGroupLayout(GroupLayout.NONE, GroupLayout.STRETCH, 5, GroupLayout.TOP));
        this.setBackground(null);
        this._spinners = new JSpinner[this._mode == Mode.NORMALIZED ? 2 : 3];
        if (this._mode == Mode.CARTESIAN || this._mode == Mode.ANGLES) {
            float extent = Float.MAX_VALUE;
            if (this._mode == Mode.ANGLES) {
                extent = 180.0f;
                this._scale = (float)Math.PI / 180;
            }
            this._spinners[0] = this.addSpinnerPanel("x", -extent, extent, step);
            this._spinners[1] = this.addSpinnerPanel("y", -extent, extent, step);
            this._spinners[2] = this.addSpinnerPanel("z", -extent, extent, step);
        } else {
            this._spinners[0] = this.addSpinnerPanel("azimuth", -180.0f, 180.0f, 1.0f);
            this._spinners[1] = this.addSpinnerPanel("elevation", -90.0f, 90.0f, 1.0f);
            if (this._mode != Mode.NORMALIZED) {
                this._spinners[2] = this.addSpinnerPanel("length", 0.0f, Float.MAX_VALUE, step);
            }
        }
    }

    public void setValue(Vector3f value) {
        float v3;
        float v2;
        float v1;
        if (this._mode == Mode.CARTESIAN || this._mode == Mode.ANGLES) {
            v1 = value.x / this._scale;
            v2 = value.y / this._scale;
            v3 = value.z;
        } else {
            v3 = value.length();
            if (v3 > 1.0E-4f) {
                v1 = FloatMath.hypot(value.x, value.y) > 1.0E-4f ? FloatMath.toDegrees(FloatMath.atan2(-value.x, value.y)) : 0.0f;
                v2 = FloatMath.toDegrees(FloatMath.asin(value.z / v3));
            } else {
                v2 = 0.0f;
                v1 = 0.0f;
            }
        }
        this._spinners[0].setValue(Float.valueOf(v1));
        this._spinners[1].setValue(Float.valueOf(v2));
        if (this._spinners.length >= 3) {
            this._spinners[2].setValue(Float.valueOf(v3 / this._scale));
        }
    }

    public Vector3f getValue() {
        float v3;
        float v1 = ((Number)this._spinners[0].getValue()).floatValue();
        float v2 = ((Number)this._spinners[1].getValue()).floatValue();
        float f = v3 = this._spinners.length < 3 ? 1.0f : ((Number)this._spinners[2].getValue()).floatValue() * this._scale;
        if (this._mode == Mode.CARTESIAN || this._mode == Mode.ANGLES) {
            return new Vector3f(v1 * this._scale, v2 * this._scale, v3);
        }
        float az = FloatMath.toRadians(v1);
        float el = FloatMath.toRadians(v2);
        float cose = FloatMath.cos(el);
        return new Vector3f(-FloatMath.sin(az) * cose * v3, FloatMath.cos(az) * cose * v3, FloatMath.sin(el) * v3);
    }

    public void stateChanged(ChangeEvent event) {
        this.fireStateChanged();
    }

    protected JSpinner addSpinnerPanel(String name, float min, float max, float step) {
        JPanel panel = new JPanel();
        panel.setBackground(null);
        this.add(panel);
        panel.add(new JLabel(this.getLabel(name) + ":"));
        DraggableSpinner spinner = new DraggableSpinner(Float.valueOf(0.0f), min == -3.4028235E38f ? null : Float.valueOf(min), max == Float.MAX_VALUE ? null : Float.valueOf(max), Float.valueOf(step));
        panel.add(spinner);
        spinner.addChangeListener(this);
        return spinner;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Mode {
        CARTESIAN,
        SPHERICAL,
        NORMALIZED,
        ANGLES;

    }
}

