/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.editor.swing;

import com.samskivert.swing.GroupLayout;
import com.samskivert.swing.util.SwingUtil;
import com.samskivert.util.ArrayUtil;
import com.threerings.config.Parameter;
import com.threerings.config.ParameterizedConfig;
import com.threerings.editor.swing.BaseEditorPanel;
import com.threerings.editor.util.EditorContext;
import com.threerings.util.MessageBundle;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JTextField;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;

public class DirectDialog
extends JDialog
implements ActionListener {
    protected MessageBundle _msgs;
    protected JTextField _field;
    protected JLabel _path;
    protected JLabel _status;
    protected BaseEditorPanel _epanel;
    protected String _term;
    protected JComponent _last;
    protected JComponent _first;
    protected JViewport _viewport;

    public static DirectDialog createDialog(Component parent, EditorContext ctx) {
        Component root = SwingUtilities.getRoot(parent);
        MessageBundle msgs = ctx.getMessageManager().getBundle("editor.default");
        String title = msgs.get("m.direct");
        DirectDialog dialog = root instanceof Dialog ? new DirectDialog((Dialog)root, ctx, title) : new DirectDialog((Frame)(root instanceof Frame ? root : null), ctx, title);
        SwingUtil.centerWindow((Window)dialog);
        dialog.setAlwaysOnTop(true);
        return dialog;
    }

    public DirectDialog(Dialog parent, EditorContext ctx, String title) {
        super(parent, title);
        this.init(ctx);
    }

    public DirectDialog(Frame parent, EditorContext ctx, String title) {
        super(parent, title);
        this.init(ctx);
    }

    public void show(BaseEditorPanel epanel, String name, String path) {
        this.setEditorPanel(epanel);
        this.setVisible(true);
        this._field.requestFocus();
        this._field.setText(name);
        this._field.selectAll();
        this._path.setText(path);
        this._status.setText("");
        this.pack();
    }

    public void setEditorPanel(BaseEditorPanel epanel) {
        if (this._epanel != epanel) {
            this._epanel = epanel;
            this._first = null;
            this._last = null;
        }
    }

    public void create() {
        if (this._epanel == null) {
            return;
        }
        ParameterizedConfig pc = (ParameterizedConfig)this._epanel.getObject();
        Parameter.Direct direct = null;
        String name = this._field.getText().trim();
        for (Parameter param : pc.parameters) {
            if (!param.name.equals(name)) continue;
            if (param instanceof Parameter.Direct) {
                direct = (Parameter.Direct)param;
                break;
            }
            this._status.setText(this._msgs.get("m.param_name_in_use"));
            return;
        }
        if (direct == null) {
            direct = new Parameter.Direct();
            pc.parameters = (Parameter[])ArrayUtil.append((Object[])pc.parameters, (Object)direct);
            direct.name = name;
        }
        String path = this._path.getText().trim();
        for (String opath : direct.paths) {
            if (!path.equals(opath)) continue;
            path = null;
            break;
        }
        if (path != null && path.length() > 0) {
            direct.paths = (String[])ArrayUtil.append((Object[])direct.paths, (Object)path);
            pc.wasUpdated();
        }
        this.setVisible(false);
    }

    public void actionPerformed(ActionEvent event) {
        Object source = event.getSource();
        if (source == this._field) {
            this.create();
        }
    }

    protected void init(EditorContext ctx) {
        this._msgs = ctx.getMessageManager().getBundle("editor.default");
        JPanel cont = GroupLayout.makeVBox();
        this._field = new JTextField(20);
        cont.add(this._field);
        this._path = new JLabel();
        cont.add(this._path);
        this._field.addActionListener(this);
        this._status = new JLabel();
        cont.add(this._status);
        this.add(cont);
        this.pack();
    }

    protected JRootPane createRootPane() {
        KeyStroke stroke = KeyStroke.getKeyStroke(27, 0);
        JRootPane rootPane = new JRootPane();
        rootPane.registerKeyboardAction(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                DirectDialog.this.setVisible(false);
            }
        }, stroke, 2);
        return rootPane;
    }
}

