/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.delta;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.threerings.delta.BareArrayMask;
import com.threerings.delta.Delta;
import com.threerings.delta.DeltaFinal;
import com.threerings.expr.MutableInteger;
import com.threerings.io.ArrayMask;
import com.threerings.io.ObjectInputStream;
import com.threerings.io.ObjectOutputStream;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReflectiveDelta
extends Delta {
    protected Class<?> _clazz;
    protected BareArrayMask _mask;
    protected Object[] _values;
    protected static Map<Class<?>, ClassMapping> _classes = Maps.newHashMap();
    protected static final Map<Class<?>, FieldHandler> PRIMITIVE_FIELD_HANDLERS = Maps.newHashMap();
    protected static final Map<Class<?>, FieldHandler> FINAL_PRIMITIVE_FIELD_HANDLERS;
    protected static final FieldHandler OBJECT_FIELD_HANDLER;
    protected static final FieldHandler FINAL_OBJECT_FIELD_HANDLER;

    public ReflectiveDelta(Object original, Object revised) {
        this._clazz = original.getClass();
        ClassMapping cmap = ReflectiveDelta.getClassMapping(this._clazz);
        this._mask = new BareArrayMask(cmap.getMaskLength());
        Field[] fields = cmap.getFields();
        FieldHandler[] handlers = cmap.getHandlers();
        ArrayList values = Lists.newArrayList();
        MutableInteger midx = new MutableInteger();
        for (int ii = 0; ii < fields.length; ++ii) {
            try {
                handlers[ii].populate(fields[ii], original, revised, this._mask, midx, values);
                continue;
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException("Failed to access " + fields[ii] + " for delta computation", e);
            }
        }
        this._values = values.toArray();
    }

    public ReflectiveDelta() {
    }

    public boolean isEmpty() {
        return this._values.length == 0;
    }

    public void writeObject(ObjectOutputStream out) throws IOException {
        _classStreamer.writeObject(this._clazz, out, true);
        this._mask.writeTo(out);
        MutableInteger midx = new MutableInteger();
        MutableInteger vidx = new MutableInteger();
        for (FieldHandler handler : ReflectiveDelta.getClassMapping(this._clazz).getHandlers()) {
            handler.write(this._mask, midx, this._values, vidx, out);
        }
    }

    public void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this._clazz = (Class)_classStreamer.createObject(in);
        ClassMapping cmap = ReflectiveDelta.getClassMapping(this._clazz);
        this._mask = new BareArrayMask(cmap.getMaskLength());
        this._mask.readFrom(in);
        ArrayList values = Lists.newArrayList();
        MutableInteger midx = new MutableInteger();
        for (FieldHandler handler : cmap.getHandlers()) {
            handler.read(this._mask, midx, values, in);
        }
        this._values = values.toArray();
    }

    @Override
    public Object apply(Object original) {
        Object revised;
        if (original.getClass() != this._clazz) {
            throw new IllegalArgumentException("Delta class mismatch: original is " + original.getClass() + ", expected " + this._clazz);
        }
        try {
            revised = this._clazz.newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to instantiate " + this._clazz + " for delta application", e);
        }
        ClassMapping cmap = ReflectiveDelta.getClassMapping(this._clazz);
        Field[] fields = cmap.getFields();
        FieldHandler[] handlers = cmap.getHandlers();
        MutableInteger midx = new MutableInteger();
        MutableInteger vidx = new MutableInteger();
        for (int ii = 0; ii < fields.length; ++ii) {
            try {
                handlers[ii].apply(fields[ii], original, revised, this._mask, midx, this._values, vidx);
                continue;
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException("Failed to access " + fields[ii] + " for delta application", e);
            }
        }
        return revised;
    }

    @Override
    public Delta merge(Delta other) {
        if (!(other instanceof ReflectiveDelta)) {
            throw new IllegalArgumentException("Cannot merge delta " + other);
        }
        ReflectiveDelta merged = new ReflectiveDelta();
        this.populateMerged((ReflectiveDelta)other, merged);
        return merged;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("[class=").append(this._clazz.getName());
        ClassMapping cmap = ReflectiveDelta.getClassMapping(this._clazz);
        Field[] fields = cmap.getFields();
        FieldHandler[] handlers = cmap.getHandlers();
        MutableInteger midx = new MutableInteger();
        MutableInteger vidx = new MutableInteger();
        for (int ii = 0; ii < fields.length; ++ii) {
            handlers[ii].toString(fields[ii], this._mask, midx, this._values, vidx, buf);
        }
        return buf.append("]").toString();
    }

    protected void populateMerged(ReflectiveDelta other, ReflectiveDelta merged) {
        if (this._clazz != other._clazz) {
            throw new IllegalArgumentException("Merge class mismatch: other is " + other._clazz + ", expected " + this._clazz);
        }
        merged._clazz = this._clazz;
        int mlength = ReflectiveDelta.getClassMapping(this._clazz).getMaskLength();
        merged._mask = new BareArrayMask(mlength);
        ArrayList values = Lists.newArrayList();
        int oidx = 0;
        int nidx = 0;
        for (int ii = 0; ii < mlength; ++ii) {
            Object value;
            if (this._mask.isSet(ii)) {
                Object ovalue = this._values[oidx++];
                if (other._mask.isSet(ii)) {
                    Object nvalue;
                    if ((nvalue = other._values[nidx++]) instanceof Delta) {
                        Delta ndelta = (Delta)nvalue;
                        value = ovalue instanceof Delta ? ((Delta)ovalue).merge(ndelta) : ndelta.apply(ovalue);
                    } else {
                        value = nvalue;
                    }
                } else {
                    value = ovalue;
                }
            } else {
                if (!other._mask.isSet(ii)) continue;
                value = other._values[nidx++];
            }
            merged._mask.set(ii);
            values.add(value);
        }
        merged._values = values.toArray();
    }

    protected static ClassMapping getClassMapping(Class<?> clazz) {
        ClassMapping cmap = _classes.get(clazz);
        if (cmap == null) {
            cmap = new ClassMapping(clazz);
            _classes.put(clazz, cmap);
        }
        return cmap;
    }

    protected static void collectFields(Class<?> clazz, List<Field> fields) {
        Class<?> sclazz = clazz.getSuperclass();
        if (sclazz != Object.class) {
            ReflectiveDelta.collectFields(sclazz, fields);
        }
        for (Field field : clazz.getDeclaredFields()) {
            int mods = field.getModifiers();
            if (Modifier.isStatic(mods) || Modifier.isTransient(mods) || field.isSynthetic()) continue;
            field.setAccessible(true);
            fields.add(field);
        }
    }

    static {
        PRIMITIVE_FIELD_HANDLERS.put(Boolean.TYPE, new FieldHandler(){

            @Override
            public void populate(Field field, Object original, Object revised, ArrayMask mask, MutableInteger midx, List<Object> values) throws IllegalAccessException {
                int idx = midx.value++;
                boolean nvalue = field.getBoolean(revised);
                if (field.getBoolean(original) != nvalue) {
                    mask.set(idx);
                    values.add(nvalue);
                }
            }

            @Override
            public void write(ArrayMask mask, MutableInteger midx, Object[] values, MutableInteger vidx, ObjectOutputStream out) throws IOException {
                if (mask.isSet(midx.value++)) {
                    out.writeBoolean(((Boolean)values[vidx.value++]).booleanValue());
                }
            }

            @Override
            public void read(ArrayMask mask, MutableInteger midx, List<Object> values, ObjectInputStream in) throws IOException, ClassNotFoundException {
                if (mask.isSet(midx.value++)) {
                    values.add(in.readBoolean());
                }
            }

            @Override
            public void apply(Field field, Object original, Object revised, ArrayMask mask, MutableInteger midx, Object[] values, MutableInteger vidx) throws IllegalAccessException {
                boolean value = mask.isSet(midx.value++) ? ((Boolean)values[vidx.value++]).booleanValue() : field.getBoolean(original);
                field.setBoolean(revised, value);
            }
        });
        PRIMITIVE_FIELD_HANDLERS.put(Byte.TYPE, new FieldHandler(){

            @Override
            public void populate(Field field, Object original, Object revised, ArrayMask mask, MutableInteger midx, List<Object> values) throws IllegalAccessException {
                int idx = midx.value++;
                byte nvalue = field.getByte(revised);
                if (field.getByte(original) != nvalue) {
                    mask.set(idx);
                    values.add(nvalue);
                }
            }

            @Override
            public void write(ArrayMask mask, MutableInteger midx, Object[] values, MutableInteger vidx, ObjectOutputStream out) throws IOException {
                if (mask.isSet(midx.value++)) {
                    out.writeByte((int)((Byte)values[vidx.value++]).byteValue());
                }
            }

            @Override
            public void read(ArrayMask mask, MutableInteger midx, List<Object> values, ObjectInputStream in) throws IOException, ClassNotFoundException {
                if (mask.isSet(midx.value++)) {
                    values.add(in.readByte());
                }
            }

            @Override
            public void apply(Field field, Object original, Object revised, ArrayMask mask, MutableInteger midx, Object[] values, MutableInteger vidx) throws IllegalAccessException {
                byte value = mask.isSet(midx.value++) ? ((Byte)values[vidx.value++]).byteValue() : field.getByte(original);
                field.setByte(revised, value);
            }
        });
        PRIMITIVE_FIELD_HANDLERS.put(Character.TYPE, new FieldHandler(){

            @Override
            public void populate(Field field, Object original, Object revised, ArrayMask mask, MutableInteger midx, List<Object> values) throws IllegalAccessException {
                int idx = midx.value++;
                char nvalue = field.getChar(revised);
                if (field.getChar(original) != nvalue) {
                    mask.set(idx);
                    values.add(Character.valueOf(nvalue));
                }
            }

            @Override
            public void write(ArrayMask mask, MutableInteger midx, Object[] values, MutableInteger vidx, ObjectOutputStream out) throws IOException {
                if (mask.isSet(midx.value++)) {
                    out.writeChar((int)((Character)values[vidx.value++]).charValue());
                }
            }

            @Override
            public void read(ArrayMask mask, MutableInteger midx, List<Object> values, ObjectInputStream in) throws IOException, ClassNotFoundException {
                if (mask.isSet(midx.value++)) {
                    values.add(Character.valueOf(in.readChar()));
                }
            }

            @Override
            public void apply(Field field, Object original, Object revised, ArrayMask mask, MutableInteger midx, Object[] values, MutableInteger vidx) throws IllegalAccessException {
                char value = mask.isSet(midx.value++) ? ((Character)values[vidx.value++]).charValue() : field.getChar(original);
                field.setChar(revised, value);
            }
        });
        PRIMITIVE_FIELD_HANDLERS.put(Double.TYPE, new FieldHandler(){

            @Override
            public void populate(Field field, Object original, Object revised, ArrayMask mask, MutableInteger midx, List<Object> values) throws IllegalAccessException {
                int idx = midx.value++;
                double nvalue = field.getDouble(revised);
                if (field.getDouble(original) != nvalue) {
                    mask.set(idx);
                    values.add(nvalue);
                }
            }

            @Override
            public void write(ArrayMask mask, MutableInteger midx, Object[] values, MutableInteger vidx, ObjectOutputStream out) throws IOException {
                if (mask.isSet(midx.value++)) {
                    out.writeDouble(((Double)values[vidx.value++]).doubleValue());
                }
            }

            @Override
            public void read(ArrayMask mask, MutableInteger midx, List<Object> values, ObjectInputStream in) throws IOException, ClassNotFoundException {
                if (mask.isSet(midx.value++)) {
                    values.add(in.readDouble());
                }
            }

            @Override
            public void apply(Field field, Object original, Object revised, ArrayMask mask, MutableInteger midx, Object[] values, MutableInteger vidx) throws IllegalAccessException {
                double value = mask.isSet(midx.value++) ? ((Double)values[vidx.value++]).doubleValue() : field.getDouble(original);
                field.setDouble(revised, value);
            }
        });
        PRIMITIVE_FIELD_HANDLERS.put(Float.TYPE, new FieldHandler(){

            @Override
            public void populate(Field field, Object original, Object revised, ArrayMask mask, MutableInteger midx, List<Object> values) throws IllegalAccessException {
                int idx = midx.value++;
                float nvalue = field.getFloat(revised);
                if (field.getFloat(original) != nvalue) {
                    mask.set(idx);
                    values.add(Float.valueOf(nvalue));
                }
            }

            @Override
            public void write(ArrayMask mask, MutableInteger midx, Object[] values, MutableInteger vidx, ObjectOutputStream out) throws IOException {
                if (mask.isSet(midx.value++)) {
                    out.writeFloat(((Float)values[vidx.value++]).floatValue());
                }
            }

            @Override
            public void read(ArrayMask mask, MutableInteger midx, List<Object> values, ObjectInputStream in) throws IOException, ClassNotFoundException {
                if (mask.isSet(midx.value++)) {
                    values.add(Float.valueOf(in.readFloat()));
                }
            }

            @Override
            public void apply(Field field, Object original, Object revised, ArrayMask mask, MutableInteger midx, Object[] values, MutableInteger vidx) throws IllegalAccessException {
                float value = mask.isSet(midx.value++) ? ((Float)values[vidx.value++]).floatValue() : field.getFloat(original);
                field.setFloat(revised, value);
            }
        });
        PRIMITIVE_FIELD_HANDLERS.put(Integer.TYPE, new FieldHandler(){

            @Override
            public void populate(Field field, Object original, Object revised, ArrayMask mask, MutableInteger midx, List<Object> values) throws IllegalAccessException {
                int idx = midx.value++;
                int nvalue = field.getInt(revised);
                if (field.getInt(original) != nvalue) {
                    mask.set(idx);
                    values.add(nvalue);
                }
            }

            @Override
            public void write(ArrayMask mask, MutableInteger midx, Object[] values, MutableInteger vidx, ObjectOutputStream out) throws IOException {
                if (mask.isSet(midx.value++)) {
                    out.writeInt(((Integer)values[vidx.value++]).intValue());
                }
            }

            @Override
            public void read(ArrayMask mask, MutableInteger midx, List<Object> values, ObjectInputStream in) throws IOException, ClassNotFoundException {
                if (mask.isSet(midx.value++)) {
                    values.add(in.readInt());
                }
            }

            @Override
            public void apply(Field field, Object original, Object revised, ArrayMask mask, MutableInteger midx, Object[] values, MutableInteger vidx) throws IllegalAccessException {
                int value = mask.isSet(midx.value++) ? ((Integer)values[vidx.value++]).intValue() : field.getInt(original);
                field.setInt(revised, value);
            }
        });
        PRIMITIVE_FIELD_HANDLERS.put(Long.TYPE, new FieldHandler(){

            @Override
            public void populate(Field field, Object original, Object revised, ArrayMask mask, MutableInteger midx, List<Object> values) throws IllegalAccessException {
                int idx = midx.value++;
                long nvalue = field.getLong(revised);
                if (field.getLong(original) != nvalue) {
                    mask.set(idx);
                    values.add(nvalue);
                }
            }

            @Override
            public void write(ArrayMask mask, MutableInteger midx, Object[] values, MutableInteger vidx, ObjectOutputStream out) throws IOException {
                if (mask.isSet(midx.value++)) {
                    out.writeLong(((Long)values[vidx.value++]).longValue());
                }
            }

            @Override
            public void read(ArrayMask mask, MutableInteger midx, List<Object> values, ObjectInputStream in) throws IOException, ClassNotFoundException {
                if (mask.isSet(midx.value++)) {
                    values.add(in.readLong());
                }
            }

            @Override
            public void apply(Field field, Object original, Object revised, ArrayMask mask, MutableInteger midx, Object[] values, MutableInteger vidx) throws IllegalAccessException {
                long value = mask.isSet(midx.value++) ? ((Long)values[vidx.value++]).longValue() : field.getLong(original);
                field.setLong(revised, value);
            }
        });
        PRIMITIVE_FIELD_HANDLERS.put(Short.TYPE, new FieldHandler(){

            @Override
            public void populate(Field field, Object original, Object revised, ArrayMask mask, MutableInteger midx, List<Object> values) throws IllegalAccessException {
                int idx = midx.value++;
                short nvalue = field.getShort(revised);
                if (field.getShort(original) != nvalue) {
                    mask.set(idx);
                    values.add(nvalue);
                }
            }

            @Override
            public void write(ArrayMask mask, MutableInteger midx, Object[] values, MutableInteger vidx, ObjectOutputStream out) throws IOException {
                if (mask.isSet(midx.value++)) {
                    out.writeShort((int)((Short)values[vidx.value++]).shortValue());
                }
            }

            @Override
            public void read(ArrayMask mask, MutableInteger midx, List<Object> values, ObjectInputStream in) throws IOException, ClassNotFoundException {
                if (mask.isSet(midx.value++)) {
                    values.add(in.readShort());
                }
            }

            @Override
            public void apply(Field field, Object original, Object revised, ArrayMask mask, MutableInteger midx, Object[] values, MutableInteger vidx) throws IllegalAccessException {
                short value = mask.isSet(midx.value++) ? ((Short)values[vidx.value++]).shortValue() : field.getShort(original);
                field.setShort(revised, value);
            }
        });
        FINAL_PRIMITIVE_FIELD_HANDLERS = Maps.newHashMap();
        FINAL_PRIMITIVE_FIELD_HANDLERS.put(Boolean.TYPE, new FinalFieldHandler(){

            public void apply(Field field, Object original, Object revised, ArrayMask mask, MutableInteger midx, Object[] values, MutableInteger vidx) throws IllegalAccessException {
                field.setBoolean(revised, field.getBoolean(original));
            }
        });
        FINAL_PRIMITIVE_FIELD_HANDLERS.put(Byte.TYPE, new FinalFieldHandler(){

            public void apply(Field field, Object original, Object revised, ArrayMask mask, MutableInteger midx, Object[] values, MutableInteger vidx) throws IllegalAccessException {
                field.setByte(revised, field.getByte(original));
            }
        });
        FINAL_PRIMITIVE_FIELD_HANDLERS.put(Character.TYPE, new FinalFieldHandler(){

            public void apply(Field field, Object original, Object revised, ArrayMask mask, MutableInteger midx, Object[] values, MutableInteger vidx) throws IllegalAccessException {
                field.setChar(revised, field.getChar(original));
            }
        });
        FINAL_PRIMITIVE_FIELD_HANDLERS.put(Double.TYPE, new FinalFieldHandler(){

            public void apply(Field field, Object original, Object revised, ArrayMask mask, MutableInteger midx, Object[] values, MutableInteger vidx) throws IllegalAccessException {
                field.setDouble(revised, field.getDouble(original));
            }
        });
        FINAL_PRIMITIVE_FIELD_HANDLERS.put(Float.TYPE, new FinalFieldHandler(){

            public void apply(Field field, Object original, Object revised, ArrayMask mask, MutableInteger midx, Object[] values, MutableInteger vidx) throws IllegalAccessException {
                field.setFloat(revised, field.getFloat(original));
            }
        });
        FINAL_PRIMITIVE_FIELD_HANDLERS.put(Integer.TYPE, new FinalFieldHandler(){

            public void apply(Field field, Object original, Object revised, ArrayMask mask, MutableInteger midx, Object[] values, MutableInteger vidx) throws IllegalAccessException {
                field.setInt(revised, field.getInt(original));
            }
        });
        FINAL_PRIMITIVE_FIELD_HANDLERS.put(Long.TYPE, new FinalFieldHandler(){

            public void apply(Field field, Object original, Object revised, ArrayMask mask, MutableInteger midx, Object[] values, MutableInteger vidx) throws IllegalAccessException {
                field.setLong(revised, field.getLong(original));
            }
        });
        FINAL_PRIMITIVE_FIELD_HANDLERS.put(Short.TYPE, new FinalFieldHandler(){

            public void apply(Field field, Object original, Object revised, ArrayMask mask, MutableInteger midx, Object[] values, MutableInteger vidx) throws IllegalAccessException {
                field.setShort(revised, field.getShort(original));
            }
        });
        OBJECT_FIELD_HANDLER = new FieldHandler(){
            protected Object[] _oarray = new Object[1];
            protected Object[] _narray = new Object[1];

            @Override
            public void populate(Field field, Object original, Object revised, ArrayMask mask, MutableInteger midx, List<Object> values) throws IllegalAccessException {
                int idx = midx.value++;
                Object ovalue = this._oarray[0] = field.get(original);
                Object nvalue = this._narray[0] = field.get(revised);
                if (!Arrays.deepEquals(this._oarray, this._narray)) {
                    if (Delta.checkDeltable(ovalue, nvalue)) {
                        nvalue = Delta.createDelta(ovalue, nvalue);
                    }
                    mask.set(idx);
                    values.add(nvalue);
                }
            }

            @Override
            public void write(ArrayMask mask, MutableInteger midx, Object[] values, MutableInteger vidx, ObjectOutputStream out) throws IOException {
                if (mask.isSet(midx.value++)) {
                    out.writeObject(values[vidx.value++]);
                }
            }

            @Override
            public void read(ArrayMask mask, MutableInteger midx, List<Object> values, ObjectInputStream in) throws IOException, ClassNotFoundException {
                if (mask.isSet(midx.value++)) {
                    values.add(in.readObject());
                }
            }

            @Override
            public void apply(Field field, Object original, Object revised, ArrayMask mask, MutableInteger midx, Object[] values, MutableInteger vidx) throws IllegalAccessException {
                Object value;
                if (mask.isSet(midx.value++)) {
                    if ((value = values[vidx.value++]) instanceof Delta) {
                        value = ((Delta)value).apply(field.get(original));
                    }
                } else {
                    value = field.get(original);
                }
                field.set(revised, value);
            }
        };
        FINAL_OBJECT_FIELD_HANDLER = new FinalFieldHandler(){

            public void apply(Field field, Object original, Object revised, ArrayMask mask, MutableInteger midx, Object[] values, MutableInteger vidx) throws IllegalAccessException {
                field.set(revised, field.get(original));
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static abstract class FinalFieldHandler
    extends FieldHandler {
        protected FinalFieldHandler() {
        }

        @Override
        public void populate(Field field, Object original, Object revised, ArrayMask mask, MutableInteger midx, List<Object> values) {
        }

        @Override
        public void write(ArrayMask mask, MutableInteger midx, Object[] values, MutableInteger vidx, ObjectOutputStream out) {
        }

        @Override
        public void read(ArrayMask mask, MutableInteger midx, List<Object> values, ObjectInputStream in) {
        }

        @Override
        public void toString(Field field, ArrayMask mask, MutableInteger midx, Object[] values, MutableInteger vidx, StringBuilder buf) {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static abstract class FieldHandler {
        protected FieldHandler() {
        }

        public abstract void populate(Field var1, Object var2, Object var3, ArrayMask var4, MutableInteger var5, List<Object> var6) throws IllegalAccessException;

        public abstract void write(ArrayMask var1, MutableInteger var2, Object[] var3, MutableInteger var4, ObjectOutputStream var5) throws IOException;

        public abstract void read(ArrayMask var1, MutableInteger var2, List<Object> var3, ObjectInputStream var4) throws IOException, ClassNotFoundException;

        public abstract void apply(Field var1, Object var2, Object var3, ArrayMask var4, MutableInteger var5, Object[] var6, MutableInteger var7) throws IllegalAccessException;

        public void toString(Field field, ArrayMask mask, MutableInteger midx, Object[] values, MutableInteger vidx, StringBuilder buf) {
            if (mask.isSet(midx.value++)) {
                buf.append(", " + field.getName() + "=" + values[vidx.value++]);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class ClassMapping {
        protected Field[] _fields;
        protected FieldHandler[] _handlers;
        protected int _maskLength;

        public ClassMapping(Class<?> clazz) {
            ArrayList fields = Lists.newArrayList();
            ReflectiveDelta.collectFields(clazz, fields);
            this._fields = fields.toArray(new Field[fields.size()]);
            this._handlers = new FieldHandler[this._fields.length];
            for (int ii = 0; ii < this._fields.length; ++ii) {
                Field field = this._fields[ii];
                Class<?> type = field.getType();
                if (Modifier.isFinal(field.getModifiers()) || field.isAnnotationPresent(DeltaFinal.class)) {
                    this._handlers[ii] = type.isPrimitive() ? FINAL_PRIMITIVE_FIELD_HANDLERS.get(type) : FINAL_OBJECT_FIELD_HANDLER;
                    continue;
                }
                ++this._maskLength;
                this._handlers[ii] = type.isPrimitive() ? PRIMITIVE_FIELD_HANDLERS.get(type) : OBJECT_FIELD_HANDLER;
            }
        }

        public Field[] getFields() {
            return this._fields;
        }

        public FieldHandler[] getHandlers() {
            return this._handlers;
        }

        public int getMaskLength() {
            return this._maskLength;
        }
    }
}

