/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.config;

import com.google.common.collect.Lists;
import com.samskivert.util.SoftCache;
import com.samskivert.util.Tuple;
import com.threerings.config.ArgumentMap;
import com.threerings.config.ConfigReference;
import com.threerings.config.ManagedConfig;
import com.threerings.config.Parameter;
import com.threerings.editor.Editable;
import com.threerings.editor.Property;
import com.threerings.expr.Scope;
import com.threerings.util.DeepOmit;
import com.threerings.util.DeepUtil;
import java.io.PrintStream;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParameterizedConfig
extends ManagedConfig {
    @Editable(weight=1.0)
    public Parameter[] parameters = new Parameter[0];
    @DeepOmit
    protected transient ParameterizedConfig _base;
    @DeepOmit
    protected transient ArgumentMap _args;
    @DeepOmit
    protected transient SoftCache<ArgumentMap, ParameterizedConfig> _derived;

    public Parameter getParameter(String name) {
        return ParameterizedConfig.getParameter(this.parameters, name);
    }

    @Override
    public ConfigReference<? extends ManagedConfig> getReference() {
        ConfigReference<? extends ManagedConfig> ref = super.getReference();
        if (this._args != null) {
            this._args.copy(ref.getArguments());
        }
        return ref;
    }

    @Override
    public ParameterizedConfig getInstance(Scope scope, ArgumentMap args) {
        ParameterizedConfig instance;
        if (args == null || args.isEmpty() || this.parameters.length == 0) {
            return this.getBound(scope);
        }
        ArgumentMap oargs = args;
        for (String string : args.keySet()) {
            if (this.getParameter(string) != null) continue;
            args = new ArgumentMap();
            break;
        }
        if (args != oargs) {
            for (Map.Entry entry : oargs.entrySet()) {
                String name = (String)entry.getKey();
                if (this.getParameter(name) == null) continue;
                args.put(name, entry.getValue());
            }
            if (args.isEmpty()) {
                return this.getBound(scope);
            }
        }
        if (this._derived == null) {
            this._derived = new SoftCache(1);
        }
        if ((instance = (ParameterizedConfig)this._derived.get((Object)args)) == null) {
            ArgumentMap argumentMap = args.clone();
            instance = (ParameterizedConfig)this.clone();
            this._derived.put((Object)argumentMap, (Object)instance);
            instance.init(this._cfgmgr);
            instance._base = this;
            instance._args = argumentMap;
            this.applyArguments(instance, args);
        }
        return instance.getBound(scope);
    }

    @Override
    public void wasUpdated() {
        for (Parameter parameter : this.parameters) {
            parameter.invalidateProperties();
        }
        super.wasUpdated();
        if (this._derived == null) {
            return;
        }
        HashMap map = this._derived.getMap();
        ArrayList list = Lists.newArrayListWithExpectedSize((int)map.size());
        Iterator it = map.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            ParameterizedConfig instance = (ParameterizedConfig)((SoftReference)entry.getValue()).get();
            if (instance == null) {
                it.remove();
                continue;
            }
            list.add(Tuple.newTuple(entry.getKey(), (Object)instance));
        }
        int size = list.size();
        if (size == 0) {
            this._derived = null;
            return;
        }
        for (int ii = 0; ii < size; ++ii) {
            Tuple tuple = (Tuple)list.get(ii);
            ParameterizedConfig instance = (ParameterizedConfig)tuple.right;
            this.copy(instance);
            this.applyArguments(instance, (ArgumentMap)tuple.left);
            instance.wasUpdated();
        }
    }

    @Override
    public boolean validateReferences(String where, PrintStream out) {
        boolean result = super.validateReferences(where, out);
        for (Parameter parameter : this.parameters) {
            result &= parameter.validatePaths(where, this, out);
        }
        return result;
    }

    @Override
    public void validateOuters(String where) {
        for (Parameter parameter : this.parameters) {
            parameter.validateOuters(where, this);
        }
    }

    @Override
    protected void maybeFireOnConfigManager() {
        if (this._base == null) {
            super.maybeFireOnConfigManager();
        }
    }

    protected ParameterizedConfig getBound(Scope scope) {
        return this;
    }

    protected void applyArguments(ParameterizedConfig instance, ArgumentMap args) {
        this.applyArguments(instance, args, this.parameters);
    }

    protected void applyArguments(ParameterizedConfig instance, ArgumentMap args, Parameter[] params) {
        for (Map.Entry<String, Object> entry : args.entrySet()) {
            Object value;
            Property prop;
            Parameter param = ParameterizedConfig.getParameter(params, entry.getKey());
            if (param == null || (prop = param.getProperty(this)) == null || !prop.isLegalValue(value = entry.getValue())) continue;
            prop.set(instance, DeepUtil.copy(value));
        }
    }

    protected static Parameter getParameter(Parameter[] params, String name) {
        for (Parameter param : params) {
            if (!param.name.equals(name)) continue;
            return param;
        }
        return null;
    }
}

