/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.config;

import com.threerings.config.ArgumentMap;
import com.threerings.config.ConfigManager;
import com.threerings.config.ManagedConfig;
import com.threerings.export.Exportable;
import com.threerings.io.Intern;
import com.threerings.io.Streamable;
import com.threerings.util.DeepObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigReference<T extends ManagedConfig>
extends DeepObject
implements Exportable,
Streamable {
    @Intern
    protected String _name;
    protected ArgumentMap _arguments = new ArgumentMap();

    public ConfigReference(String name) {
        this._name = name;
    }

    public ConfigReference(String name, String firstKey, Object firstValue, Object ... otherArgs) {
        this._name = name;
        this._arguments.put(firstKey, firstValue);
        for (int ii = 0; ii < otherArgs.length; ii += 2) {
            this._arguments.put((String)otherArgs[ii], otherArgs[ii + 1]);
        }
    }

    public ConfigReference() {
    }

    public String getName() {
        return this._name;
    }

    public ArgumentMap getArguments() {
        return this._arguments;
    }

    public T getConfig(ConfigManager cfgMgr, Class<T> token) {
        return cfgMgr.getConfig(token, this);
    }

    @Override
    public Object copy(Object dest) {
        ConfigReference<T> cref;
        if (dest instanceof ConfigReference) {
            cref = (ConfigReference<T>)dest;
            cref._name = this._name;
        } else {
            cref = new ConfigReference<T>(this._name);
        }
        this._arguments.copy(cref.getArguments());
        return cref;
    }

    @Override
    public boolean equals(Object other) {
        if (!(other instanceof ConfigReference)) {
            return false;
        }
        ConfigReference oref = (ConfigReference)other;
        return this._name.equals(oref.getName()) && this._arguments.equals(oref.getArguments());
    }

    @Override
    public int hashCode() {
        return 31 * this._name.hashCode() + this._arguments.hashCode();
    }

    @Override
    public String toString() {
        return "[name=" + this._name + ", arguments=" + this._arguments + "]";
    }

    @Override
    public ConfigReference<T> clone() {
        return (ConfigReference)super.clone();
    }
}

