/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.admin.client;

import com.samskivert.swing.GroupLayout;
import com.samskivert.swing.VGroupLayout;
import com.threerings.admin.client.FieldEditor;
import com.threerings.editor.Introspector;
import com.threerings.editor.Property;
import com.threerings.editor.swing.PropertyEditor;
import com.threerings.editor.util.EditorContext;
import com.threerings.presents.dobj.DObject;
import com.threerings.presents.util.PresentsContext;
import com.threerings.util.DeepUtil;
import com.threerings.util.MessageBundle;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.reflect.Field;
import java.util.Arrays;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class EditableFieldEditor
extends FieldEditor
implements ChangeListener {
    protected Object _dummy;
    protected PropertyEditor _editor;
    protected JButton _revert;
    protected JButton _commit;
    protected Object[] _a1 = new Object[1];
    protected Object[] _a2 = new Object[1];

    public EditableFieldEditor(PresentsContext ctx, Field field, DObject object) {
        super(ctx, field, object);
        this.removeAll();
        this.setLayout((LayoutManager)new VGroupLayout(GroupLayout.STRETCH, GroupLayout.STRETCH, 5, GroupLayout.TOP));
        try {
            this._dummy = object.getClass().newInstance();
        }
        catch (Exception e) {
            throw new AssertionError((Object)e);
        }
        EditorContext ectx = (EditorContext)ctx;
        for (Property prop : Introspector.getProperties(object)) {
            if (!prop.getMember().equals(field)) continue;
            this._editor = PropertyEditor.createEditor(ectx, prop, null);
            break;
        }
        if (this._editor == null) {
            throw new AssertionError((Object)("Missing property for field " + field));
        }
        this.add((Component)((Object)this._editor));
        this._editor.setObject(this._dummy);
        this._editor.addChangeListener(this);
        JPanel bpanel = new JPanel();
        this.add(bpanel, GroupLayout.FIXED);
        MessageBundle msgs = ectx.getMessageManager().getBundle("editor.default");
        this._revert = new JButton(new AbstractAction(msgs.get("m.revert")){

            public void actionPerformed(ActionEvent event) {
                EditableFieldEditor.this.noteUpdatedExternally();
            }
        });
        bpanel.add(this._revert);
        this._revert.setEnabled(false);
        this._commit = new JButton(msgs.get("m.commit"));
        bpanel.add(this._commit);
        this._commit.addActionListener((ActionListener)((Object)this));
        this._commit.setEnabled(false);
    }

    public void stateChanged(ChangeEvent event) {
        boolean modified = !this.valueMatches(this.getDisplayValue());
        this.updateBorder(modified);
        this._revert.setEnabled(modified);
        this._commit.setEnabled(modified);
    }

    public void noteUpdatedExternally() {
        super.noteUpdatedExternally();
        this._revert.setEnabled(false);
        this._commit.setEnabled(false);
    }

    protected Object getDisplayValue() {
        try {
            return DeepUtil.copy(this._field.get(this._dummy));
        }
        catch (Exception e) {
            throw new AssertionError((Object)e);
        }
    }

    protected void displayValue(Object value) {
        try {
            this._field.set(this._dummy, DeepUtil.copy(value));
        }
        catch (Exception e) {
            throw new AssertionError((Object)e);
        }
        this._editor.update();
    }

    protected boolean valueMatches(Object dvalue) {
        this._a1[0] = dvalue;
        this._a2[0] = this.getValue();
        return Arrays.deepEquals(this._a1, this._a2);
    }
}

