/*
 * Decompiled with CFR 0.152.
 */
package com.samskivert.depot.impl.operator;

import com.samskivert.depot.expression.SQLExpression;
import com.samskivert.depot.impl.operator.Arithmetic;
import com.samskivert.depot.impl.operator.BaseOperator;
import com.samskivert.util.StringUtil;

public class Div<T extends Number>
extends Arithmetic<T> {
    public Div(SQLExpression<?> column, T value) {
        super(column, value);
    }

    public Div(SQLExpression<?> ... values) {
        super(values);
    }

    @Override
    public String operator() {
        return " / ";
    }

    @Override
    public Object evaluate(Object[] operands) {
        int ii = 1;
        while (ii < operands.length) {
            if (Double.valueOf(0.0).equals(NUMERICAL.apply(operands[ii]))) {
                return new SQLExpression.NoValue("Division by zero in: " + StringUtil.toString((Object)operands));
            }
            ++ii;
        }
        return this.evaluate(operands, "/", new BaseOperator.Accumulator<Double>(){

            @Override
            public Double accumulate(Double left, Double right) {
                return left / right;
            }
        }, new BaseOperator.Accumulator<Long>(){

            @Override
            public Long accumulate(Long left, Long right) {
                return left / right;
            }
        });
    }
}

