/*
 * Decompiled with CFR 0.152.
 */
package com.samskivert.depot.impl;

import com.samskivert.Log;
import com.samskivert.depot.PersistentRecord;
import com.samskivert.depot.annotation.FullTextIndex;
import com.samskivert.depot.clause.Distinct;
import com.samskivert.depot.clause.OrderBy;
import com.samskivert.depot.expression.ColumnExp;
import com.samskivert.depot.impl.BuildVisitor;
import com.samskivert.depot.impl.DepotMarshaller;
import com.samskivert.depot.impl.DepotTypes;
import com.samskivert.depot.impl.FieldMarshaller;
import com.samskivert.depot.impl.SQLBuilder;
import com.samskivert.depot.impl.clause.DeleteClause;
import com.samskivert.depot.impl.clause.DropIndexClause;
import com.samskivert.depot.impl.expression.DateFun;
import com.samskivert.depot.impl.expression.NumericalFun;
import com.samskivert.depot.operator.FullText;
import com.samskivert.util.StringUtil;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Map;
import java.util.Set;

public class MySQLBuilder
extends SQLBuilder {
    protected static final FieldMarshaller.ColumnTyper TYPER = new FieldMarshaller.ColumnTyper(){

        @Override
        public String getBooleanType(int length) {
            return "TINYINT";
        }

        @Override
        public String getByteType(int length) {
            return "TINYINT";
        }

        @Override
        public String getShortType(int length) {
            return "SMALLINT";
        }

        @Override
        public String getIntType(int length) {
            return "INTEGER";
        }

        @Override
        public String getLongType(int length) {
            return "BIGINT";
        }

        @Override
        public String getFloatType(int length) {
            return "FLOAT";
        }

        @Override
        public String getDoubleType(int length) {
            return "DOUBLE";
        }

        @Override
        public String getStringType(int length) {
            return length < 32768 ? "VARCHAR(" + length + ")" : "TEXT";
        }

        @Override
        public String getDateType(int length) {
            return "DATE";
        }

        @Override
        public String getTimeType(int length) {
            return "TIME";
        }

        @Override
        public String getTimestampType(int length) {
            return "DATETIME";
        }

        @Override
        public String getBlobType(int length) {
            if (length < 32768) {
                return "VARBINARY(" + length + ")";
            }
            if (length < 65536) {
                return "BLOB";
            }
            if (length < 0x1000000) {
                return "MEDIUMBLOB";
            }
            return "LONGBLOB";
        }

        @Override
        public String getClobType(int length) {
            return "TEXT";
        }
    };

    protected static String massageFTQuery(FullText fullText) {
        Object[] searchTerms = fullText.getQuery().toLowerCase().trim().split("\\W+");
        if (fullText.isMatchAll()) {
            return String.valueOf('+') + StringUtil.join((Object[])searchTerms, (String)" +");
        }
        return StringUtil.join((Object[])searchTerms, (String)" ");
    }

    public MySQLBuilder(DepotTypes types) {
        super(types);
    }

    @Override
    public void getFtsIndexes(Iterable<String> columns, Iterable<String> indexes, Set<String> target) {
        for (String index : indexes) {
            if (!index.startsWith("ftsIx_")) continue;
            target.add(index.substring("ftsIx_".length()));
        }
    }

    @Override
    public <T extends PersistentRecord> boolean addFullTextSearch(Connection conn, DepotMarshaller<T> marshaller, FullTextIndex fts) throws SQLException {
        Class<T> pClass = marshaller.getPersistentClass();
        StringBuilder update = new StringBuilder("ALTER TABLE ").append(marshaller.getTableName()).append(" ADD FULLTEXT INDEX ftsIx_").append(fts.name()).append(" (");
        String[] fields = fts.fields();
        int ii = 0;
        while (ii < fields.length) {
            if (ii > 0) {
                update.append(", ");
            }
            update.append(this._types.getColumnName(pClass, fields[ii]));
            ++ii;
        }
        update.append(")");
        Log.log.info((Object)("Adding full-text search index: ftsIx_" + fts.name()), new Object[0]);
        conn.createStatement().executeUpdate(update.toString());
        return true;
    }

    @Override
    public boolean isPrivateColumn(String column, Map<String, FullTextIndex> fullTextIndexes) {
        return false;
    }

    @Override
    public boolean isPrivateIndex(String index, Map<String, FullTextIndex> fullTextIndexes) {
        return false;
    }

    @Override
    protected String getBooleanDefault() {
        return "0";
    }

    @Override
    protected BuildVisitor getBuildVisitor() {
        return new MSBuildVisitor(this._types);
    }

    @Override
    protected <T> String getColumnType(FieldMarshaller<?> fm, int length) {
        return fm.getColumnType(TYPER, length);
    }

    public class MSBuildVisitor
    extends BuildVisitor {
        @Override
        public Void visit(FullText.Match match) {
            this.renderMatch(match.getDefinition());
            return null;
        }

        @Override
        public Void visit(FullText.Rank rank) {
            this.renderMatch(rank.getDefinition());
            return null;
        }

        @Override
        public Void visit(DeleteClause deleteClause) {
            this._builder.append("delete from ");
            this.appendTableName(deleteClause.getPersistentClass());
            this._builder.append(" ");
            boolean savedFlag = this._types.getUseTableAbbreviations();
            this._types.setUseTableAbbreviations(false);
            try {
                deleteClause.getWhereClause().accept(this);
                if (deleteClause.getLimit() != null) {
                    deleteClause.getLimit().accept(this);
                }
            }
            finally {
                this._types.setUseTableAbbreviations(savedFlag);
            }
            return null;
        }

        @Override
        public Void visit(NumericalFun.Trunc<?> exp) {
            return this.appendFunctionCall("truncate", exp.getArg());
        }

        @Override
        public Void visit(Distinct distinct) {
            if (distinct.getDistinctOn() != null) {
                throw new IllegalArgumentException("MySQL does not support DISTINCT ON");
            }
            return super.visit(distinct);
        }

        @Override
        public Void visit(DateFun.DatePart exp) {
            return this.appendFunctionCall(this.getDateFunction(exp.getPart()), exp.getArg());
        }

        @Override
        public Void visit(DateFun.DateTruncate exp) {
            this._builder.append(" cast(");
            this.appendFunctionCall("date", exp.getArg());
            this._builder.append(" as datetime)");
            return null;
        }

        protected String getDateFunction(DateFun.DatePart.Part part) {
            switch (part) {
                case DAY_OF_MONTH: {
                    return "dayofmonth";
                }
                case DAY_OF_WEEK: {
                    return "dayofweek";
                }
                case DAY_OF_YEAR: {
                    return "dayofyear";
                }
                case HOUR: {
                    return "hour";
                }
                case MINUTE: {
                    return "minute";
                }
                case MONTH: {
                    return "month";
                }
                case SECOND: {
                    return "second";
                }
                case WEEK: {
                    return "week";
                }
                case YEAR: {
                    return "year";
                }
                case EPOCH: {
                    return "unix_timestamp";
                }
            }
            throw new IllegalArgumentException("Unknown date part: " + (Object)((Object)part));
        }

        @Override
        public Void visit(DropIndexClause dropIndexClause) {
            this._builder.append("drop index ");
            this.appendIdentifier(dropIndexClause.getName());
            this._builder.append(" on ");
            this.appendTableName(dropIndexClause.getPersistentClass());
            return null;
        }

        protected MSBuildVisitor(DepotTypes types) {
            super(types, false);
        }

        @Override
        protected void appendTableName(Class<? extends PersistentRecord> type) {
            this._builder.append(this._types.getTableName(type));
        }

        @Override
        protected void appendTableAbbreviation(Class<? extends PersistentRecord> type) {
            this._builder.append(this._types.getTableAbbreviation(type));
        }

        @Override
        protected void appendIdentifier(String field) {
            this._builder.append("`").append(field).append("`");
        }

        protected void renderMatch(FullText fullText) {
            this._builder.append("match(");
            Class<? extends PersistentRecord> pClass = fullText.getPersistentClass();
            String[] fields = this._types.getMarshaller(pClass).getFullTextIndex(fullText.getName()).fields();
            int ii = 0;
            while (ii < fields.length) {
                if (ii > 0) {
                    this._builder.append(", ");
                }
                new ColumnExp(pClass, fields[ii]).accept(this);
                ++ii;
            }
            this._builder.append(") against (");
            this.bindValue(MySQLBuilder.massageFTQuery(fullText));
            this._builder.append(" in boolean mode)");
        }

        @Override
        protected void appendEmptyInsertValues() {
            this._builder.append("() values ()");
        }

        @Override
        protected boolean orderSupported(OrderBy.Order order) {
            switch (order) {
                case NULL: 
                case ASC: 
                case DESC: {
                    return true;
                }
            }
            return false;
        }
    }
}

