/*
 * Decompiled with CFR 0.152.
 */
package com.samskivert.depot.impl;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.samskivert.Log;
import com.samskivert.depot.Exps;
import com.samskivert.depot.Key;
import com.samskivert.depot.PersistentRecord;
import com.samskivert.depot.annotation.Computed;
import com.samskivert.depot.clause.Distinct;
import com.samskivert.depot.clause.FieldDefinition;
import com.samskivert.depot.clause.FieldOverride;
import com.samskivert.depot.clause.ForUpdate;
import com.samskivert.depot.clause.FromOverride;
import com.samskivert.depot.clause.GroupBy;
import com.samskivert.depot.clause.InsertClause;
import com.samskivert.depot.clause.Join;
import com.samskivert.depot.clause.Limit;
import com.samskivert.depot.clause.OrderBy;
import com.samskivert.depot.clause.SelectClause;
import com.samskivert.depot.clause.WhereClause;
import com.samskivert.depot.expression.ColumnExp;
import com.samskivert.depot.expression.SQLExpression;
import com.samskivert.depot.impl.DepotMarshaller;
import com.samskivert.depot.impl.DepotTypes;
import com.samskivert.depot.impl.DepotUtil;
import com.samskivert.depot.impl.FieldMarshaller;
import com.samskivert.depot.impl.FragmentVisitor;
import com.samskivert.depot.impl.clause.CreateIndexClause;
import com.samskivert.depot.impl.clause.DeleteClause;
import com.samskivert.depot.impl.clause.DropIndexClause;
import com.samskivert.depot.impl.clause.UpdateClause;
import com.samskivert.depot.impl.expression.AggregateFun;
import com.samskivert.depot.impl.expression.ConditionalFun;
import com.samskivert.depot.impl.expression.DateFun;
import com.samskivert.depot.impl.expression.IntervalExp;
import com.samskivert.depot.impl.expression.LiteralExp;
import com.samskivert.depot.impl.expression.NumericalFun;
import com.samskivert.depot.impl.expression.StringFun;
import com.samskivert.depot.impl.expression.ValueExp;
import com.samskivert.depot.impl.operator.BinaryOperator;
import com.samskivert.depot.impl.operator.Exists;
import com.samskivert.depot.impl.operator.In;
import com.samskivert.depot.impl.operator.IsNull;
import com.samskivert.depot.impl.operator.MultiOperator;
import com.samskivert.depot.impl.operator.Not;
import com.samskivert.depot.operator.Case;
import com.samskivert.depot.operator.FullText;
import com.samskivert.util.ByteEnum;
import com.samskivert.util.Tuple;
import java.nio.ByteBuffer;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class BuildVisitor
implements FragmentVisitor<Void> {
    protected DepotTypes _types;
    protected List<Bindable> _bindables = Lists.newLinkedList();
    protected StringBuilder _builder = new StringBuilder();
    protected Map<Class<? extends PersistentRecord>, Map<String, FieldDefinition>> _definitions = Maps.newHashMap();
    protected Class<? extends PersistentRecord> _defaultType;
    protected boolean _innerClause = false;
    protected boolean _enableOverrides = false;
    protected boolean _enableAliasing = false;
    protected final boolean _allowComplexIndices;

    public String getQuery() {
        return this._builder.toString();
    }

    public Iterable<Bindable> getBindables() {
        return this._bindables;
    }

    @Override
    public Void visit(FromOverride override) {
        this._builder.append(" from ");
        List<Class<? extends PersistentRecord>> from = override.getFromClasses();
        int ii = 0;
        while (ii < from.size()) {
            if (ii > 0) {
                this._builder.append(", ");
            }
            this.appendTableName(from.get(ii));
            this._builder.append(" as ");
            this.appendTableAbbreviation(from.get(ii));
            ++ii;
        }
        return null;
    }

    @Override
    public Void visit(FieldDefinition definition) {
        definition.getDefinition().accept(this);
        return null;
    }

    @Override
    public Void visit(WhereClause where) {
        this._builder.append(" where ");
        where.getWhereExpression().accept(this);
        return null;
    }

    @Override
    public Void visit(Key.Expression key) {
        Class<? extends PersistentRecord> pClass = key.getPersistentClass();
        ColumnExp<?>[] keyFields = DepotUtil.getKeyFields(pClass);
        Comparable<?>[] values = key.getValues();
        int ii = 0;
        while (ii < keyFields.length) {
            if (ii > 0) {
                this._builder.append(" and ");
            }
            boolean saved = this._enableOverrides;
            this._enableOverrides = true;
            this.appendRhsColumn(keyFields[ii]);
            this._enableOverrides = saved;
            if (values[ii] == null) {
                this._builder.append(" is null ");
            } else {
                this._builder.append(" = ");
                this.bindValue(values[ii]);
            }
            ++ii;
        }
        return null;
    }

    @Override
    public Void visit(MultiOperator<?> multiOperator) {
        this._builder.append('(');
        SQLExpression<?>[] conditions = multiOperator.getArgs();
        int ii = 0;
        while (ii < conditions.length) {
            if (ii > 0) {
                this._builder.append(" ").append(multiOperator.operator()).append(" ");
            }
            conditions[ii].accept(this);
            ++ii;
        }
        this._builder.append(")");
        return null;
    }

    @Override
    public Void visit(BinaryOperator<?> binaryOperator) {
        this._builder.append('(');
        binaryOperator.getLeftHandSide().accept(this);
        this._builder.append(binaryOperator.operator());
        binaryOperator.getRightHandSide().accept(this);
        this._builder.append(')');
        return null;
    }

    @Override
    public Void visit(IsNull isNull) {
        isNull.getExpression().accept(this);
        this._builder.append(" is null");
        return null;
    }

    @Override
    public Void visit(In in) {
        if (in.getValues().length == 0) {
            Exps.value(false).accept(this);
            return null;
        }
        in.getExpression().accept(this);
        this._builder.append(" in (");
        Comparable<?>[] values = in.getValues();
        int ii = 0;
        while (ii < values.length) {
            if (ii > 0) {
                this._builder.append(", ");
            }
            this.bindValue(values[ii]);
            ++ii;
        }
        this._builder.append(")");
        return null;
    }

    @Override
    public abstract Void visit(FullText.Match var1);

    @Override
    public abstract Void visit(FullText.Rank var1);

    @Override
    public Void visit(Case<?> caseExp) {
        this._builder.append("(case ");
        for (Tuple<SQLExpression<?>, SQLExpression<?>> tuple : caseExp.getWhenExps()) {
            this._builder.append(" when ");
            ((SQLExpression)tuple.left).accept(this);
            this._builder.append(" then ");
            ((SQLExpression)tuple.right).accept(this);
        }
        SQLExpression<?> elseExp = caseExp.getElseExp();
        if (elseExp != null) {
            this._builder.append(" else ");
            elseExp.accept(this);
        }
        this._builder.append(" end)");
        return null;
    }

    @Override
    public Void visit(ColumnExp<?> columnExp) {
        this.appendRhsColumn(columnExp);
        return null;
    }

    @Override
    public Void visit(Not not) {
        this._builder.append(" not (");
        not.getCondition().accept(this);
        this._builder.append(")");
        return null;
    }

    @Override
    public Void visit(GroupBy groupBy) {
        this._builder.append(" group by ");
        SQLExpression<?>[] values = groupBy.getValues();
        int ii = 0;
        while (ii < values.length) {
            if (ii > 0) {
                this._builder.append(", ");
            }
            values[ii].accept(this);
            ++ii;
        }
        return null;
    }

    @Override
    public Void visit(ForUpdate forUpdate) {
        this._builder.append(" for update ");
        return null;
    }

    @Override
    public Void visit(OrderBy orderBy) {
        this._builder.append(" order by ");
        SQLExpression<?>[] values = orderBy.getValues();
        OrderBy.Order[] orders = orderBy.getOrders();
        int ii = 0;
        while (ii < values.length) {
            if (ii > 0) {
                this._builder.append(", ");
            }
            values[ii].accept(this);
            this._builder.append(" ").append((Object)this.validateOrder(orders[ii]));
            ++ii;
        }
        return null;
    }

    @Override
    public Void visit(Distinct distinct) {
        this._builder.append("distinct ");
        if (distinct.getDistinctOn() != null) {
            this._builder.append("on ");
            distinct.getDistinctOn().accept(this);
            this._builder.append(" ");
        }
        return null;
    }

    @Override
    public Void visit(Join join) {
        switch (join.getType()) {
            case INNER: {
                this._builder.append(" inner join ");
                break;
            }
            case LEFT_OUTER: {
                this._builder.append(" left outer join ");
                break;
            }
            case RIGHT_OUTER: {
                this._builder.append(" right outer join ");
            }
        }
        this.appendTableName(join.getJoinClass());
        this._builder.append(" as ");
        this.appendTableAbbreviation(join.getJoinClass());
        this._builder.append(" on ");
        join.getJoinCondition().accept(this);
        return null;
    }

    @Override
    public Void visit(Limit limit) {
        this._builder.append(" limit ").append(limit.getCount()).append(" offset ").append(limit.getOffset());
        return null;
    }

    @Override
    public Void visit(LiteralExp<?> literalExp) {
        this._builder.append(literalExp.getText());
        return null;
    }

    @Override
    public Void visit(ValueExp<?> valueExp) {
        this.bindValue(valueExp.getValue());
        return null;
    }

    @Override
    public Void visit(IntervalExp interval) {
        this._builder.append("interval ").append(interval.amount).append(" ").append((Object)interval.unit);
        return null;
    }

    @Override
    public Void visit(Exists exists) {
        this._builder.append("exists ");
        exists.getSubClause().accept(this);
        return null;
    }

    @Override
    public Void visit(SelectClause selectClause) {
        Class<? extends PersistentRecord> pClass = selectClause.getPersistentClass();
        boolean isInner = this._innerClause;
        this._innerClause = true;
        if (isInner) {
            this._builder.append("(");
        }
        this._builder.append("select ");
        Preconditions.checkArgument((!this._definitions.containsKey(pClass) ? 1 : 0) != 0, (Object)"Can not yet nest SELECTs on the same persistent record.");
        if (selectClause.getDistinct() != null) {
            selectClause.getDistinct().accept(this);
        }
        HashMap definitionMap = Maps.newHashMap();
        for (FieldDefinition definition : selectClause.getFieldDefinitions()) {
            definitionMap.put(definition.getField(), definition);
        }
        this._definitions.put(pClass, definitionMap);
        try {
            boolean comma = false;
            this._enableOverrides = true;
            this._enableAliasing = true;
            SQLExpression<?>[] sQLExpressionArray = selectClause.getSelections();
            int n = sQLExpressionArray.length;
            int n2 = 0;
            while (n2 < n) {
                SQLExpression<?> selexp = sQLExpressionArray[n2];
                StringBuilder saved = this._builder;
                this._builder = new StringBuilder();
                selexp.accept(this);
                String column = this._builder.toString();
                this._builder = saved;
                if (column.length() > 0) {
                    if (comma) {
                        this._builder.append(", ");
                    }
                    comma = true;
                    this._builder.append(column);
                }
                ++n2;
            }
            this._enableOverrides = false;
            this._enableAliasing = false;
            if (selectClause.getFromOverride() != null) {
                selectClause.getFromOverride().accept(this);
            } else {
                Class<? extends PersistentRecord> tClass;
                Computed computed = this._types.getMarshaller(pClass).getComputed();
                if (computed != null && !PersistentRecord.class.equals(computed.shadowOf())) {
                    tClass = computed.shadowOf();
                } else if (this._types.getTableName(pClass) != null) {
                    tClass = pClass;
                } else {
                    throw new IllegalStateException("Query on @Computed entity with no FromOverrideClause.");
                }
                this._builder.append(" from ");
                this.appendTableName(tClass);
                this._builder.append(" as ");
                this.appendTableAbbreviation(tClass);
            }
            for (Join clause : selectClause.getJoinClauses()) {
                clause.accept(this);
            }
            if (selectClause.getWhereClause() != null) {
                selectClause.getWhereClause().accept(this);
            }
            if (selectClause.getGroupBy() != null) {
                selectClause.getGroupBy().accept(this);
            }
            if (selectClause.getOrderBy() != null) {
                selectClause.getOrderBy().accept(this);
            }
            if (selectClause.getLimit() != null) {
                selectClause.getLimit().accept(this);
            }
            if (selectClause.getForUpdate() != null) {
                selectClause.getForUpdate().accept(this);
            }
        }
        finally {
            this._definitions.remove(pClass);
        }
        if (isInner) {
            this._builder.append(")");
        }
        return null;
    }

    @Override
    public Void visit(UpdateClause updateClause) {
        Preconditions.checkArgument((updateClause.getWhereClause() != null ? 1 : 0) != 0, (Object)"I dare not currently perform UPDATE without a WHERE clause.");
        Class<? extends PersistentRecord> pClass = updateClause.getPersistentClass();
        this._innerClause = true;
        this._builder.append("update ");
        this.appendTableName(pClass);
        this._builder.append(" as ");
        this.appendTableAbbreviation(pClass);
        this._builder.append(" set ");
        ColumnExp<?>[] fields = updateClause.getFields();
        PersistentRecord pojo = updateClause.getPojo();
        SQLExpression<?>[] values = updateClause.getValues();
        int ii = 0;
        while (ii < fields.length) {
            if (ii > 0) {
                this._builder.append(", ");
            }
            this.appendLhsColumn(pClass, fields[ii]);
            this._builder.append(" = ");
            if (pojo != null) {
                this.bindField(pClass, fields[ii], pojo);
            } else if (values[ii] instanceof ValueExp) {
                this.bindFieldValue(pClass, fields[ii], (ValueExp)values[ii]);
            } else {
                values[ii].accept(this);
            }
            ++ii;
        }
        updateClause.getWhereClause().accept(this);
        return null;
    }

    @Override
    public Void visit(DeleteClause deleteClause) {
        this._builder.append("delete from ");
        this.appendTableName(deleteClause.getPersistentClass());
        this._builder.append(" as ");
        this.appendTableAbbreviation(deleteClause.getPersistentClass());
        this._builder.append(" ");
        deleteClause.getWhereClause().accept(this);
        if (deleteClause.getLimit() != null) {
            deleteClause.getLimit().accept(this);
        }
        return null;
    }

    @Override
    public Void visit(InsertClause insertClause) {
        this._innerClause = true;
        this._builder.append("insert into ");
        this.appendTableName(insertClause.getPersistentClass());
        this._builder.append(" ");
        this.appendInsertColumns(insertClause);
        return null;
    }

    @Override
    public Void visit(CreateIndexClause createIndexClause) {
        if (!this._allowComplexIndices) {
            for (Tuple<SQLExpression<?>, OrderBy.Order> field : createIndexClause.getFields()) {
                if (field.left instanceof ColumnExp) continue;
                Log.log.warning((Object)"This database can't handle complex indexes. Not creating.", new Object[]{"ixName", createIndexClause.getName()});
                return null;
            }
        }
        this._builder.append("create ");
        if (createIndexClause.isUnique()) {
            this._builder.append("unique ");
        }
        this._builder.append("index ");
        this.appendIdentifier(createIndexClause.getName());
        this._builder.append(" on ");
        this.appendTableName(createIndexClause.getPersistentClass());
        this._builder.append(" (");
        this._defaultType = createIndexClause.getPersistentClass();
        boolean comma = false;
        for (Tuple<SQLExpression<?>, OrderBy.Order> field : createIndexClause.getFields()) {
            if (comma) {
                this._builder.append(", ");
            }
            comma = true;
            if (this._allowComplexIndices) {
                this._builder.append("(");
            }
            ((SQLExpression)field.left).accept(this);
            if (this._allowComplexIndices) {
                this._builder.append(")");
            }
            if (field.right != OrderBy.Order.DESC) continue;
            this._builder.append(" desc");
        }
        this._defaultType = null;
        this._builder.append(")");
        return null;
    }

    @Override
    public Void visit(DropIndexClause dropIndexClause) {
        this._builder.append("drop index ");
        this.appendIdentifier(dropIndexClause.getName());
        return null;
    }

    @Override
    public Void visit(NumericalFun.Abs<?> exp) {
        return this.appendFunctionCall("abs", exp.getArg());
    }

    @Override
    public Void visit(NumericalFun.Ceil<?> exp) {
        return this.appendFunctionCall("ceil", exp.getArg());
    }

    @Override
    public Void visit(NumericalFun.Exp<?> exp) {
        return this.appendFunctionCall("exp", exp.getArg());
    }

    @Override
    public Void visit(NumericalFun.Floor<?> exp) {
        return this.appendFunctionCall("floor", exp.getArg());
    }

    @Override
    public Void visit(NumericalFun.Ln<?> exp) {
        return this.appendFunctionCall("ln", exp.getArg());
    }

    @Override
    public Void visit(NumericalFun.Log10<?> exp) {
        return this.appendFunctionCall("log", exp.getArg());
    }

    @Override
    public Void visit(NumericalFun.Pi<?> exp) {
        return this.appendFunctionCall("PI", new SQLExpression[0]);
    }

    @Override
    public Void visit(NumericalFun.Power<?> exp) {
        return this.appendFunctionCall("power", exp.getValue(), exp.getPower());
    }

    @Override
    public Void visit(NumericalFun.Random<?> exp) {
        return this.appendFunctionCall("random", new SQLExpression[0]);
    }

    @Override
    public Void visit(NumericalFun.Round<?> exp) {
        return this.appendFunctionCall("round", exp.getArg());
    }

    @Override
    public Void visit(NumericalFun.Sign<?> exp) {
        return this.appendFunctionCall("sign", exp.getArg());
    }

    @Override
    public Void visit(NumericalFun.Sqrt<?> exp) {
        return this.appendFunctionCall("sqrt", exp.getArg());
    }

    @Override
    public Void visit(NumericalFun.Trunc<?> exp) {
        return this.appendFunctionCall("trunc", exp.getArg());
    }

    @Override
    public Void visit(StringFun.Length exp) {
        return this.appendFunctionCall("length", exp.getArg());
    }

    @Override
    public Void visit(StringFun.Lower exp) {
        return this.appendFunctionCall("lower", exp.getArg());
    }

    @Override
    public Void visit(StringFun.Position exp) {
        this._builder.append(" position(").append(exp.getSubString()).append(" in ").append(exp.getString()).append(")");
        return null;
    }

    @Override
    public Void visit(StringFun.Substring exp) {
        return this.appendFunctionCall("substr", exp.getArgs());
    }

    @Override
    public Void visit(StringFun.Trim exp) {
        return this.appendFunctionCall("trim", exp.getArg());
    }

    @Override
    public Void visit(StringFun.Upper exp) {
        return this.appendFunctionCall("upper", exp.getArg());
    }

    @Override
    public abstract Void visit(DateFun.DatePart var1);

    @Override
    public abstract Void visit(DateFun.DateTruncate var1);

    @Override
    public Void visit(DateFun.Now exp) {
        this.appendFunctionCall("now", new SQLExpression[0]);
        return null;
    }

    @Override
    public Void visit(AggregateFun.Average<?> exp) {
        return this.appendAggregateFunctionCall("average", exp);
    }

    @Override
    public Void visit(AggregateFun.Count exp) {
        return this.appendAggregateFunctionCall("count", exp);
    }

    @Override
    public Void visit(AggregateFun.Every exp) {
        return this.appendAggregateFunctionCall("every", exp);
    }

    @Override
    public Void visit(AggregateFun.Max<?> exp) {
        return this.appendAggregateFunctionCall("max", exp);
    }

    @Override
    public Void visit(AggregateFun.Min<?> exp) {
        return this.appendAggregateFunctionCall("min", exp);
    }

    @Override
    public Void visit(AggregateFun.Sum<?> exp) {
        return this.appendAggregateFunctionCall("sum", exp);
    }

    @Override
    public Void visit(ConditionalFun.Coalesce<?> exp) {
        return this.appendFunctionCall("coalesce", exp.getArgs());
    }

    @Override
    public Void visit(ConditionalFun.Greatest<?> exp) {
        return this.appendFunctionCall("greatest", exp.getArgs());
    }

    @Override
    public Void visit(ConditionalFun.Least<?> exp) {
        return this.appendFunctionCall("least", exp.getArgs());
    }

    protected Void appendAggregateFunctionCall(String function, AggregateFun<?> exp) {
        this._builder.append(" ").append(function).append("(");
        if (exp.isDistinct()) {
            this._builder.append("DISTINCT ");
        }
        this.appendArguments(exp.getArg());
        this._builder.append(")");
        return null;
    }

    protected Void appendFunctionCall(String function, SQLExpression<?> ... args) {
        this._builder.append(" ").append(function).append("(");
        this.appendArguments(args);
        this._builder.append(")");
        return null;
    }

    protected Void appendArguments(SQLExpression<?> ... args) {
        int ii = 0;
        while (ii < args.length) {
            if (ii > 0) {
                this._builder.append(", ");
            }
            args[ii].accept(this);
            ++ii;
        }
        return null;
    }

    protected Void bindValue(final Object value) {
        this._bindables.add(new Bindable(){

            @Override
            public void doBind(Connection conn, PreparedStatement stmt, int argIx) throws Exception {
                if (value instanceof ByteEnum) {
                    stmt.setByte(argIx, ((ByteEnum)value).toByte());
                } else if (value instanceof Enum) {
                    stmt.setString(argIx, ((Enum)value).name());
                } else if (value instanceof int[]) {
                    int[] data = (int[])value;
                    ByteBuffer bbuf = ByteBuffer.allocate(data.length * 4);
                    bbuf.asIntBuffer().put(data);
                    stmt.setObject(argIx, bbuf.array());
                } else {
                    stmt.setObject(argIx, value);
                }
            }
        });
        this._builder.append("?");
        return null;
    }

    protected Void bindField(Class<? extends PersistentRecord> pClass, ColumnExp<?> field, final Object pojo) {
        final FieldMarshaller<?> fmarsh = this._types.getMarshaller(pClass).getFieldMarshaller(field.name);
        this._bindables.add(new Bindable(){

            @Override
            public void doBind(Connection conn, PreparedStatement stmt, int argIx) throws Exception {
                fmarsh.getAndWriteToStatement(stmt, argIx, pojo);
            }
        });
        this._builder.append("?");
        return null;
    }

    protected <T> Void bindFieldValue(Class<? extends PersistentRecord> pClass, ColumnExp<?> field, final ValueExp<T> value) {
        final FieldMarshaller<?> fmarsh = this._types.getMarshaller(pClass).getFieldMarshaller(field.name);
        this._bindables.add(new Bindable(){

            @Override
            public void doBind(Connection conn, PreparedStatement stmt, int argIx) throws Exception {
                fmarsh.writeToStatement(stmt, argIx, value.getValue());
            }
        });
        this._builder.append("?");
        return null;
    }

    protected abstract void appendIdentifier(String var1);

    protected void appendTableName(Class<? extends PersistentRecord> type) {
        this.appendIdentifier(this._types.getTableName(type));
    }

    protected void appendTableAbbreviation(Class<? extends PersistentRecord> type) {
        this.appendIdentifier(this._types.getTableAbbreviation(type));
    }

    protected void appendLhsColumn(Class<? extends PersistentRecord> type, ColumnExp<?> field) {
        DepotMarshaller<? extends PersistentRecord> dm = this._types.getMarshaller(type);
        Preconditions.checkArgument((dm != null ? 1 : 0) != 0, (String)"Unknown field on persistent record [record=%s, field=%s]", (Object[])new Object[]{type, field});
        FieldMarshaller<?> fm = dm.getFieldMarshaller(field.name);
        this.appendIdentifier(fm.getColumnName());
    }

    protected void appendRhsColumn(ColumnExp<?> field) {
        Computed entityComputed;
        FieldDefinition fieldDef;
        Class<PersistentRecord> type = field.getPersistentClass();
        DepotMarshaller<PersistentRecord> dm = this._types.getMarshaller(type);
        Preconditions.checkArgument((dm != null ? 1 : 0) != 0, (String)"Unknown field on persistent record [record=%s, field=%s]", (Object[])new Object[]{type, field});
        FieldMarshaller<?> fm = dm.getFieldMarshaller(field.name);
        Map<String, FieldDefinition> fieldDefs = this._definitions.get(type);
        if (fieldDefs != null && (fieldDef = fieldDefs.get(field.name)) != null) {
            boolean useOverride;
            if (fieldDef instanceof FieldOverride) {
                Preconditions.checkArgument((fm.getComputed() == null || dm.getComputed() == null ? 1 : 0) != 0, (Object)("FieldOverride cannot be used on @Computed field: " + field));
                useOverride = this._enableOverrides;
            } else {
                Preconditions.checkArgument((fm.getComputed() != null || dm.getComputed() != null ? 1 : 0) != 0, (Object)("FieldDefinition must not be used on concrete field: " + field));
                useOverride = true;
            }
            if (useOverride) {
                boolean saved = this._enableOverrides;
                this._enableOverrides = false;
                fieldDef.accept(this);
                if (this._enableAliasing) {
                    this._builder.append(" as ");
                    this.appendIdentifier(fm.getColumnName());
                }
                this._enableOverrides = saved;
                return;
            }
        }
        Class<PersistentRecord> tableClass = (entityComputed = dm.getComputed()) == null ? type : (!PersistentRecord.class.equals(entityComputed.shadowOf()) ? entityComputed.shadowOf() : null);
        Computed fieldComputed = fm.getComputed();
        if (fieldComputed != null) {
            if (fieldComputed.fieldDefinition().length() > 0) {
                this._builder.append(fieldComputed.fieldDefinition());
                if (this._enableAliasing) {
                    this._builder.append(" as ");
                    this.appendIdentifier(fm.getColumnName());
                }
                return;
            }
            if (!fieldComputed.required()) {
                return;
            }
            if (fieldComputed.shadowOf() != null) {
                tableClass = fieldComputed.shadowOf();
            }
        }
        if (tableClass != null && this._defaultType != tableClass) {
            this.appendTableAbbreviation(tableClass);
            this._builder.append(".");
        }
        if (tableClass != type && tableClass != null) {
            this.appendIdentifier(this._types.getColumnName(tableClass, field.name));
        } else {
            this.appendIdentifier(fm.getColumnName());
        }
    }

    protected void appendEmptyInsertValues() {
        this._builder.append("default values");
    }

    protected void appendInsertColumns(InsertClause insertClause) {
        Class<? extends PersistentRecord> pClass = insertClause.getPersistentClass();
        Object pojo = insertClause.getPojo();
        DepotMarshaller<? extends PersistentRecord> marsh = this._types.getMarshaller(pClass);
        Set<String> idFields = insertClause.getIdentityFields();
        ColumnExp<?>[] fields = marsh.getColumnFieldNames();
        boolean insertingSomething = false;
        ColumnExp<?>[] columnExpArray = fields;
        int n = fields.length;
        int n2 = 0;
        while (n2 < n) {
            ColumnExp<?> field = columnExpArray[n2];
            if (!idFields.contains(field.name)) {
                insertingSomething = true;
                break;
            }
            ++n2;
        }
        if (!insertingSomething) {
            this.appendEmptyInsertValues();
            return;
        }
        this._builder.append("(");
        boolean comma = false;
        ColumnExp<?>[] columnExpArray2 = fields;
        int n3 = fields.length;
        n = 0;
        while (n < n3) {
            ColumnExp<?> field = columnExpArray2[n];
            if (!idFields.contains(field.name)) {
                if (comma) {
                    this._builder.append(", ");
                }
                comma = true;
                this.appendLhsColumn(pClass, field);
            }
            ++n;
        }
        this._builder.append(") values (");
        comma = false;
        columnExpArray2 = fields;
        n3 = fields.length;
        n = 0;
        while (n < n3) {
            ColumnExp<?> field = columnExpArray2[n];
            if (!idFields.contains(field.name)) {
                if (comma) {
                    this._builder.append(", ");
                }
                comma = true;
                this.bindField(pClass, field, pojo);
            }
            ++n;
        }
        this._builder.append(")");
    }

    protected OrderBy.Order validateOrder(OrderBy.Order order) {
        Preconditions.checkNotNull((Object)((Object)order));
        if (this.orderSupported(order)) {
            return order;
        }
        throw new IllegalArgumentException("Order '" + order.name() + "' is not supported by your database.");
    }

    protected abstract boolean orderSupported(OrderBy.Order var1);

    protected BuildVisitor(DepotTypes types, boolean allowComplexIndices) {
        this._types = types;
        this._allowComplexIndices = allowComplexIndices;
    }

    protected static interface Bindable {
        public void doBind(Connection var1, PreparedStatement var2, int var3) throws Exception;
    }
}

