/*
 * Decompiled with CFR 0.152.
 */
package com.samskivert.depot.impl;

import com.samskivert.depot.Log;
import com.samskivert.depot.annotation.GeneratedValue;
import com.samskivert.depot.impl.DepotMarshaller;
import com.samskivert.depot.impl.FieldMarshaller;
import com.samskivert.jdbc.DatabaseLiaison;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public abstract class ValueGenerator {
    protected int _initialValue;
    protected int _allocationSize;
    protected boolean _migrateIfExists;
    protected DepotMarshaller<?> _dm;
    protected FieldMarshaller<?> _fm;

    public ValueGenerator(GeneratedValue gv, DepotMarshaller<?> dm, FieldMarshaller<?> fm) {
        this._allocationSize = gv.allocationSize();
        this._initialValue = gv.initialValue();
        this._migrateIfExists = gv.migrateIfExists();
        this._dm = dm;
        this._fm = fm;
    }

    public abstract boolean isPostFactum();

    public abstract void create(Connection var1, DatabaseLiaison var2) throws SQLException;

    public abstract int nextGeneratedValue(Connection var1, DatabaseLiaison var2) throws SQLException;

    public abstract void delete(Connection var1, DatabaseLiaison var2) throws SQLException;

    protected Integer getFieldMaximum(Connection conn, DatabaseLiaison liaison) throws SQLException {
        String column = this._fm.getColumnName();
        String table = this._dm.getTableName();
        Statement stmt = conn.createStatement();
        ResultSet rs = stmt.executeQuery(" SELECT COUNT(*), MAX(" + liaison.columnSQL(column) + ") " + "   FROM " + liaison.tableSQL(table));
        if (!rs.next()) {
            Log.log.warning((Object)"Query on count()/max() bizarrely returned no rows.", new Object[0]);
            return null;
        }
        int cnt = rs.getInt(1);
        if (cnt > 0) {
            return rs.getInt(2);
        }
        return null;
    }

    public DepotMarshaller<?> getDepotMarshaller() {
        return this._dm;
    }

    public FieldMarshaller<?> getFieldMarshaller() {
        return this._fm;
    }
}

