/*
 * Decompiled with CFR 0.152.
 */
package com.samskivert.depot;

import com.google.common.collect.Iterables;
import com.samskivert.depot.clause.SelectClause;
import com.samskivert.depot.expression.FluentExp;
import com.samskivert.depot.expression.SQLExpression;
import com.samskivert.depot.impl.operator.Add;
import com.samskivert.depot.impl.operator.Exists;
import com.samskivert.depot.impl.operator.Like;
import com.samskivert.depot.impl.operator.Mul;
import com.samskivert.depot.impl.operator.MultiOperator;
import com.samskivert.depot.impl.operator.Not;

public class Ops {
    public static SQLExpression<Boolean> not(SQLExpression<Boolean> expr) {
        return new Not(expr);
    }

    public static FluentExp<Boolean> and(Iterable<? extends SQLExpression<?>> conditions) {
        return Ops.and((SQLExpression[])Iterables.toArray(conditions, SQLExpression.class));
    }

    public static FluentExp<Boolean> and(SQLExpression<?> ... conditions) {
        return new MultiOperator<Boolean>((SQLExpression[])conditions){

            @Override
            public String operator() {
                return " and ";
            }

            @Override
            public Object evaluate(Object[] values) {
                boolean allTrue = true;
                Object[] objectArray = values;
                int n = values.length;
                int n2 = 0;
                while (n2 < n) {
                    Object value = objectArray[n2];
                    if (value instanceof SQLExpression.NoValue) {
                        return value;
                    }
                    if (Boolean.FALSE.equals(value)) {
                        allTrue = false;
                    } else if (!Boolean.TRUE.equals(value)) {
                        return new SQLExpression.NoValue("Non-boolean operand to AND: " + value);
                    }
                    ++n2;
                }
                return allTrue;
            }
        };
    }

    public static FluentExp<Boolean> or(Iterable<? extends SQLExpression<?>> conditions) {
        return Ops.or((SQLExpression[])Iterables.toArray(conditions, SQLExpression.class));
    }

    public static FluentExp<Boolean> or(SQLExpression<?> ... conditions) {
        return new MultiOperator<Boolean>((SQLExpression[])conditions){

            @Override
            public String operator() {
                return " or ";
            }

            @Override
            public Object evaluate(Object[] values) {
                boolean anyTrue = false;
                Object[] objectArray = values;
                int n = values.length;
                int n2 = 0;
                while (n2 < n) {
                    Object value = objectArray[n2];
                    if (value instanceof SQLExpression.NoValue) {
                        return value;
                    }
                    if (Boolean.TRUE.equals(value)) {
                        anyTrue = true;
                    } else if (!Boolean.FALSE.equals(value)) {
                        return new SQLExpression.NoValue("Non-boolean operand to OR: " + value);
                    }
                    ++n2;
                }
                return anyTrue;
            }
        };
    }

    public static FluentExp<Boolean> like(SQLExpression<?> source, Comparable<?> value) {
        return new Like(source, value, true);
    }

    public static FluentExp<Boolean> like(SQLExpression<?> source, SQLExpression<?> expr) {
        return new Like(source, expr, true);
    }

    public static FluentExp<Boolean> notLike(SQLExpression<?> source, Comparable<?> value) {
        return new Like(source, value, false);
    }

    public static FluentExp<Boolean> notLike(SQLExpression<?> source, SQLExpression<?> expr) {
        return new Like(source, expr, false);
    }

    public static SQLExpression<Boolean> exists(SelectClause target) {
        return new Exists(target);
    }

    public static <T extends Number> FluentExp<T> add(SQLExpression<T> e1, SQLExpression<T> e2) {
        return new Add(e1, e2);
    }

    public static <T extends Number> FluentExp<T> add(Iterable<SQLExpression<T>> exprs) {
        return new Add((SQLExpression[])Iterables.toArray(exprs, SQLExpression.class));
    }

    public static <T extends Number> FluentExp<T> mul(SQLExpression<T> e1, SQLExpression<T> e2) {
        return new Mul(e1, e2);
    }

    public static <T extends Number> FluentExp<T> mul(Iterable<SQLExpression<T>> exprs) {
        return new Mul((SQLExpression[])Iterables.toArray(exprs, SQLExpression.class));
    }
}

