/*
 * Decompiled with CFR 0.152.
 */
package com.samskivert.depot.clause;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.samskivert.depot.PersistentRecord;
import com.samskivert.depot.clause.Distinct;
import com.samskivert.depot.clause.FieldDefinition;
import com.samskivert.depot.clause.ForUpdate;
import com.samskivert.depot.clause.FromOverride;
import com.samskivert.depot.clause.GroupBy;
import com.samskivert.depot.clause.Join;
import com.samskivert.depot.clause.Limit;
import com.samskivert.depot.clause.OrderBy;
import com.samskivert.depot.clause.QueryClause;
import com.samskivert.depot.clause.WhereClause;
import com.samskivert.depot.expression.SQLExpression;
import com.samskivert.depot.impl.FragmentVisitor;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public class SelectClause
implements QueryClause {
    protected Map<String, FieldDefinition> _disMap = Maps.newHashMap();
    protected Class<? extends PersistentRecord> _pClass;
    protected SQLExpression<?>[] _selexps;
    protected FromOverride _fromOverride;
    protected WhereClause _where;
    protected List<Join> _joinClauses = Lists.newArrayList();
    protected OrderBy _orderBy;
    protected Distinct _distinct;
    protected GroupBy _groupBy;
    protected Limit _limit;
    protected ForUpdate _forUpdate;

    public SelectClause(Class<? extends PersistentRecord> pClass, SQLExpression<?>[] selexps, QueryClause ... clauses) {
        this(pClass, selexps, Arrays.asList(clauses));
    }

    public SelectClause(Class<? extends PersistentRecord> pClass, SQLExpression<?>[] selexps, Iterable<? extends QueryClause> clauses) {
        this._pClass = pClass;
        this._selexps = selexps;
        for (QueryClause queryClause : clauses) {
            if (queryClause == null) continue;
            if (queryClause instanceof WhereClause) {
                Preconditions.checkArgument((this._where == null ? 1 : 0) != 0, (Object)"Query can't contain multiple Where clauses.");
                this._where = (WhereClause)queryClause;
                continue;
            }
            if (queryClause instanceof FromOverride) {
                Preconditions.checkArgument((this._fromOverride == null ? 1 : 0) != 0, (Object)"Query can't contain multiple FromOverride clauses.");
                this._fromOverride = (FromOverride)queryClause;
                continue;
            }
            if (queryClause instanceof Join) {
                this._joinClauses.add((Join)queryClause);
                continue;
            }
            if (queryClause instanceof FieldDefinition) {
                this._disMap.put(((FieldDefinition)queryClause).getField(), (FieldDefinition)queryClause);
                continue;
            }
            if (queryClause instanceof Distinct) {
                Preconditions.checkArgument((this._distinct == null ? 1 : 0) != 0, (Object)"Query can't contain multiple Distinct clauses.");
                this._distinct = (Distinct)queryClause;
                continue;
            }
            if (queryClause instanceof OrderBy) {
                Preconditions.checkArgument((this._orderBy == null ? 1 : 0) != 0, (Object)"Query can't contain multiple OrderBy clauses.");
                this._orderBy = (OrderBy)queryClause;
                continue;
            }
            if (queryClause instanceof GroupBy) {
                Preconditions.checkArgument((this._groupBy == null ? 1 : 0) != 0, (Object)"Query can't contain multiple GroupBy clauses.");
                this._groupBy = (GroupBy)queryClause;
                continue;
            }
            if (queryClause instanceof Limit) {
                Preconditions.checkArgument((this._limit == null ? 1 : 0) != 0, (Object)"Query can't contain multiple Limit clauses.");
                this._limit = (Limit)queryClause;
                continue;
            }
            if (queryClause instanceof ForUpdate) {
                Preconditions.checkArgument((this._forUpdate == null ? 1 : 0) != 0, (Object)"Query can't contain multiple For Update clauses.");
                this._forUpdate = (ForUpdate)queryClause;
                continue;
            }
            throw new IllegalArgumentException("Unknown clause provided in select " + queryClause + ".");
        }
    }

    public FieldDefinition lookupDefinition(String field) {
        return this._disMap.get(field);
    }

    public Collection<FieldDefinition> getFieldDefinitions() {
        return this._disMap.values();
    }

    public Class<? extends PersistentRecord> getPersistentClass() {
        return this._pClass;
    }

    public SQLExpression<?>[] getSelections() {
        return this._selexps;
    }

    public FromOverride getFromOverride() {
        return this._fromOverride;
    }

    public WhereClause getWhereClause() {
        return this._where;
    }

    public List<Join> getJoinClauses() {
        return this._joinClauses;
    }

    public OrderBy getOrderBy() {
        return this._orderBy;
    }

    public Distinct getDistinct() {
        return this._distinct;
    }

    public GroupBy getGroupBy() {
        return this._groupBy;
    }

    public Limit getLimit() {
        return this._limit;
    }

    public ForUpdate getForUpdate() {
        return this._forUpdate;
    }

    @Override
    public void addClasses(Collection<Class<? extends PersistentRecord>> classSet) {
        classSet.add(this._pClass);
        if (this._fromOverride != null) {
            this._fromOverride.addClasses(classSet);
        }
        if (this._where != null) {
            this._where.addClasses(classSet);
        }
        for (Join join : this._joinClauses) {
            join.addClasses(classSet);
        }
        for (FieldDefinition override : this._disMap.values()) {
            override.addClasses(classSet);
        }
    }

    @Override
    public Object accept(FragmentVisitor<?> builder) {
        return builder.visit(this);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("(where=").append(this._where);
        if (this._fromOverride != null) {
            builder.append(", from=").append(this._fromOverride);
        }
        if (!this._joinClauses.isEmpty()) {
            builder.append(", join=").append(this._joinClauses);
        }
        if (this._orderBy != null) {
            builder.append(", orderBy=").append(this._orderBy);
        }
        if (this._distinct != null) {
            builder.append(", distinct=").append(this._distinct);
        }
        if (this._groupBy != null) {
            builder.append(", groupBy=").append(this._groupBy);
        }
        if (this._limit != null) {
            builder.append(", limit=").append(this._limit);
        }
        if (this._forUpdate != null) {
            builder.append(", forUpdate=").append(this._forUpdate);
        }
        return builder.append(")").toString();
    }
}

