/*
 * Decompiled with CFR 0.152.
 */
package com.samskivert.depot.impl;

import com.samskivert.depot.CacheKey;
import com.samskivert.depot.Key;
import java.io.Serializable;
import java.util.Arrays;

public class KeyCacheKey
implements CacheKey,
Serializable {
    protected String _cacheId;
    protected Comparable<?>[] _values;

    public KeyCacheKey(Key<?> key) {
        this._cacheId = key.getPersistentClass().getName();
        Comparable<?>[] values = key.getValues();
        this._values = new Comparable[values.length];
        int ii = 0;
        while (ii < this._values.length) {
            this._values[ii] = values[ii];
            ++ii;
        }
    }

    @Override
    public String getCacheId() {
        return this._cacheId;
    }

    @Override
    public Serializable getCacheKey() {
        return this;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        return Arrays.equals(this._values, ((KeyCacheKey)obj)._values);
    }

    public int hashCode() {
        return Arrays.hashCode(this._values);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder(this._cacheId);
        builder.append("(");
        int ii = 0;
        while (ii < this._values.length) {
            if (ii > 0) {
                builder.append(", ");
            }
            builder.append(this._values[ii]);
            ++ii;
        }
        builder.append(")");
        return builder.toString();
    }
}

