/*
 * Decompiled with CFR 0.152.
 */
package com.samskivert.depot.impl;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.samskivert.depot.DatabaseException;
import com.samskivert.depot.PersistenceContext;
import com.samskivert.depot.PersistentRecord;
import com.samskivert.depot.clause.QueryClause;
import com.samskivert.depot.impl.DepotMarshaller;
import com.samskivert.depot.impl.FieldMarshaller;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Map;

public class DepotTypes {
    public static DepotTypes TRIVIAL = new DepotTypes();
    protected Map<Class<?>, Integer> _classIx = Maps.newHashMap();
    protected Map<Class<?>, DepotMarshaller<?>> _classMap = Maps.newHashMap();
    protected boolean _useTableAbbreviations = true;

    public static <T extends PersistentRecord> DepotTypes getDepotTypes(PersistenceContext ctx, Iterable<? extends QueryClause> clauses) throws DatabaseException {
        LinkedHashSet classSet = Sets.newLinkedHashSet();
        for (QueryClause queryClause : clauses) {
            if (queryClause == null) continue;
            queryClause.addClasses(classSet);
        }
        return new DepotTypes(ctx, classSet);
    }

    public static <T extends PersistentRecord> DepotTypes getDepotTypes(PersistenceContext ctx, QueryClause ... clauses) throws DatabaseException {
        return DepotTypes.getDepotTypes(ctx, Arrays.asList(clauses));
    }

    public DepotTypes(PersistenceContext ctx, Iterable<Class<? extends PersistentRecord>> others) throws DatabaseException {
        for (Class<? extends PersistentRecord> c : others) {
            this.addClass(ctx, c);
        }
    }

    public DepotTypes(PersistenceContext ctx, Class<? extends PersistentRecord> pClass) throws DatabaseException {
        this.addClass(ctx, pClass);
    }

    public String getTableName(Class<? extends PersistentRecord> cl) {
        return this.getMarshaller(cl).getTableName();
    }

    public String getTableAbbreviation(Class<? extends PersistentRecord> cl) {
        if (this._useTableAbbreviations) {
            Integer ix = this._classIx.get(cl);
            Preconditions.checkArgument((ix != null ? 1 : 0) != 0, (Object)("Unknown persistence class: " + cl));
            return "T" + (ix + 1);
        }
        return this.getTableName(cl);
    }

    public String getColumnName(Class<? extends PersistentRecord> cl, String field) {
        FieldMarshaller<?> fm = this.getMarshaller(cl).getFieldMarshaller(field);
        Preconditions.checkArgument((fm != null ? 1 : 0) != 0, (String)"Field not known on class [field=%s, class=%s]", (Object[])new Object[]{field, cl});
        return fm.getColumnName();
    }

    public <T extends PersistentRecord> DepotMarshaller<T> getMarshaller(Class<T> cl) {
        DepotMarshaller<?> marsh = this._classMap.get(cl);
        Preconditions.checkArgument((marsh != null ? 1 : 0) != 0, (Object)("Persistent class not known: " + cl));
        return marsh;
    }

    public void addClass(PersistenceContext ctx, Class<? extends PersistentRecord> type) throws DatabaseException {
        if (this._classMap.containsKey(type)) {
            return;
        }
        DepotMarshaller<? extends PersistentRecord> marsh = ctx.getMarshaller(type);
        this._classMap.put(type, marsh);
        this._classIx.put(type, this._classIx.size());
        if (marsh.getComputed() != null && !PersistentRecord.class.equals(marsh.getComputed().shadowOf())) {
            this.addClass(ctx, marsh.getComputed().shadowOf());
        }
    }

    public boolean getUseTableAbbreviations() {
        return this._useTableAbbreviations;
    }

    public void setUseTableAbbreviations(boolean doUse) {
        this._useTableAbbreviations = doUse;
    }

    protected DepotTypes() {
    }
}

