/*
 * Decompiled with CFR 0.152.
 */
package com.samskivert.depot;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Interner;
import com.google.common.collect.Interners;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.common.primitives.Ints;
import com.samskivert.depot.Log;
import com.samskivert.depot.Transformer;
import com.samskivert.depot.annotation.Transform;
import com.samskivert.util.ByteEnumUtil;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

public class Transformers {
    protected static final Interner<Object> INTERNER = Interners.newWeakInterner();

    protected static <E> Builder<E, Iterable<E>> createCollectionBuilder(Type fieldType, Class<E> elementType, boolean immutable, boolean intern, int sizeHint) {
        AbstractCollection adder;
        Type clazz;
        Collection retval = null;
        Type type = clazz = fieldType instanceof ParameterizedType ? ((ParameterizedType)fieldType).getRawType() : fieldType;
        if (clazz == HashSet.class || clazz == Set.class || clazz == EnumSet.class) {
            AbstractSet set;
            if (clazz == HashSet.class || elementType == null || !elementType.isEnum()) {
                Preconditions.checkArgument((clazz != EnumSet.class ? 1 : 0) != 0, (Object)"Cannot proceed: EnumSet field is to be populated with a null element.");
                set = sizeHint < 0 ? Sets.newHashSet() : Sets.newHashSetWithExpectedSize((int)sizeHint);
            } else {
                Class<E> eclazz = elementType;
                EnumSet<E> eSet = EnumSet.noneOf(eclazz);
                set = eSet;
            }
            adder = set;
            if (immutable && clazz == Set.class) {
                retval = Collections.unmodifiableSet(set);
            }
        } else if (clazz == LinkedList.class) {
            adder = Lists.newLinkedList();
        } else {
            ArrayList list = sizeHint < 0 ? Lists.newArrayList() : Lists.newArrayListWithCapacity((int)sizeHint);
            adder = list;
            if (immutable && (clazz == List.class || clazz == Iterable.class || clazz == Collection.class)) {
                retval = Collections.unmodifiableList(list);
            }
        }
        final LinkedList fadder = adder;
        final AbstractList fretval = retval == null ? adder : retval;
        final boolean fintern = retval != null && immutable && intern;
        return new Builder<E, Iterable<E>>(){

            @Override
            public void add(E element) {
                fadder.add(element);
            }

            @Override
            public Iterable<E> build() {
                if (fintern) {
                    Iterable built = (Iterable)INTERNER.intern((Object)fretval);
                    return built;
                }
                return fretval;
            }
        };
    }

    protected static interface Builder<E, B> {
        public void add(E var1);

        public B build();
    }

    public static class ByteEnumSet<E extends Enum<E>>
    extends Transformer<Set<E>, Integer> {
        protected Class<E> _eclass;

        @Override
        public void init(Type fieldType, Transform annotation) {
            this._eclass = (Class)((ParameterizedType)fieldType).getActualTypeArguments()[0];
        }

        @Override
        public Integer toPersistent(Set<E> value) {
            return value == null ? null : Integer.valueOf(ByteEnumUtil.setToInt(value));
        }

        @Override
        public Set<E> fromPersistent(Integer encoded) {
            return encoded == null ? null : ByteEnumUtil.intToSet(this._eclass, (int)encoded);
        }
    }

    public static class EnumIterable<E extends Enum<E>>
    extends StringBase<Iterable<E>> {
        protected Class<E> _eclass;

        @Override
        public void init(Type fieldType, Transform annotation) {
            super.init(fieldType, annotation);
            this._eclass = (Class)((ParameterizedType)fieldType).getActualTypeArguments()[0];
            this._internStrings = false;
        }

        @Override
        protected Iterable<String> asIterable(Iterable<E> value) {
            return Iterables.transform(value, (Function)new Function<E, String>(){

                public String apply(E val) {
                    return val == null ? null : ((Enum)val).name();
                }
            });
        }

        @Override
        protected Builder<String, Iterable<E>> createBuilder(String encoded) {
            final Builder<E, Iterable<E>> ebuilder = Transformers.createCollectionBuilder(this._ftype, EnumIterable.hasNullElement(encoded) ? null : this._eclass, this._immutable, this._intern, -1);
            return new Builder<String, Iterable<E>>(){

                @Override
                public void add(String s) {
                    Object value;
                    if (s == null) {
                        value = null;
                    } else {
                        try {
                            value = Enum.valueOf(EnumIterable.this._eclass, s);
                        }
                        catch (IllegalArgumentException iae) {
                            Log.log.warning((Object)"Invalid enum cannot be unpersisted", new Object[]{"e", s, iae});
                            return;
                        }
                    }
                    ebuilder.add(value);
                }

                @Override
                public Iterable<E> build() {
                    return (Iterable)ebuilder.build();
                }
            };
        }
    }

    public static class IntegerIterable
    extends Transformer<Iterable<Integer>, int[]> {
        protected Type _ftype;
        protected boolean _immutable;
        protected boolean _intern;

        @Override
        public void init(Type fieldType, Transform annotation) {
            this._ftype = fieldType;
            this._immutable = annotation.immutable();
            this._intern = annotation.intern();
        }

        @Override
        public int[] toPersistent(Iterable<Integer> itr) {
            if (itr == null) {
                return null;
            }
            Collection coll = itr instanceof Collection ? (Collection)itr : Lists.newArrayList(itr);
            return Ints.toArray((Collection)coll);
        }

        @Override
        public Iterable<Integer> fromPersistent(int[] value) {
            if (value == null) {
                return null;
            }
            Builder<Integer, Iterable<Integer>> builder = Transformers.createCollectionBuilder(this._ftype, Integer.class, this._immutable, this._intern, value.length);
            int[] nArray = value;
            int n = value.length;
            int n2 = 0;
            while (n2 < n) {
                int v = nArray[n2];
                builder.add(v);
                ++n2;
            }
            return builder.build();
        }
    }

    public static class StringArray
    extends StringBase<String[]> {
        @Override
        protected Iterable<String> asIterable(String[] value) {
            return Arrays.asList(value);
        }

        @Override
        protected Builder<String, String[]> createBuilder(String encoded) {
            final String[] result = new String[StringArray.countElements(encoded)];
            return new Builder<String, String[]>(){
                protected int idx = 0;

                @Override
                public void add(String s) {
                    result[this.idx++] = s;
                }

                @Override
                public String[] build() {
                    return result;
                }
            };
        }
    }

    protected static abstract class StringBase<F>
    extends Transformer<F, String> {
        protected Type _ftype;
        protected boolean _immutable;
        protected boolean _intern;
        protected boolean _internStrings;

        protected StringBase() {
        }

        @Override
        public void init(Type fieldType, Transform annotation) {
            this._ftype = fieldType;
            this._immutable = annotation.immutable();
            this._internStrings = this._intern = annotation.intern();
        }

        @Override
        public String toPersistent(F value) {
            if (value == null) {
                return null;
            }
            StringBuilder buf = new StringBuilder();
            for (String s : this.asIterable(value)) {
                if (s == null) {
                    buf.append("\\\n");
                    continue;
                }
                s = s.replace("\\", "\\\\");
                s = s.replace("\n", "\\n");
                buf.append(s).append('\n');
            }
            return buf.toString();
        }

        @Override
        public F fromPersistent(String encoded) {
            if (encoded == null) {
                return null;
            }
            Builder<String, F> builder = this.createBuilder(encoded);
            StringBuilder buf = new StringBuilder(encoded.length());
            boolean eof = false;
            int ii = 0;
            int nn = encoded.length();
            while (ii < nn) {
                char c = encoded.charAt(ii);
                block0 : switch (c) {
                    case '\r': {
                        if (eof) break;
                    }
                    case '\n': {
                        String s = buf.toString();
                        builder.add(this._internStrings ? s.intern() : s);
                        buf.setLength(0);
                        eof = true;
                        break;
                    }
                    case '\\': {
                        Preconditions.checkArgument((++ii < nn ? 1 : 0) != 0, (Object)"Invalid encoded string");
                        char slashed = encoded.charAt(ii);
                        switch (slashed) {
                            case '\n': {
                                Preconditions.checkArgument((buf.length() == 0 ? 1 : 0) != 0, (Object)"Invalid encoded string");
                                builder.add(null);
                                break block0;
                            }
                            case 'n': {
                                buf.append('\n');
                                break block0;
                            }
                        }
                        buf.append(slashed);
                        break;
                    }
                    default: {
                        eof = false;
                        buf.append(c);
                    }
                }
                ++ii;
            }
            Preconditions.checkArgument((buf.length() == 0 ? 1 : 0) != 0, (Object)"Invalid encoded string");
            return builder.build();
        }

        protected abstract Iterable<String> asIterable(F var1);

        protected abstract Builder<String, F> createBuilder(String var1);

        protected static int countElements(String encoded) {
            int count = 0;
            int pos = 0;
            while ((pos = 1 + encoded.indexOf(10, pos)) != 0) {
                ++count;
            }
            return count;
        }

        protected static boolean hasNullElement(String encoded) {
            int pos = 0;
            while (-1 != (pos = encoded.indexOf("\\\n", pos))) {
                if (pos == 0 || '\\' != encoded.charAt(pos - 1)) {
                    return true;
                }
                pos += 2;
            }
            return false;
        }
    }

    public static class StringIterable
    extends StringBase<Iterable<String>> {
        @Override
        protected Iterable<String> asIterable(Iterable<String> value) {
            return value;
        }

        @Override
        protected Builder<String, Iterable<String>> createBuilder(String encoded) {
            return Transformers.createCollectionBuilder(this._ftype, String.class, this._immutable, this._intern, -1);
        }
    }
}

